/*
 * Decompiled with CFR 0.152.
 */
package br.com.stant.libraries.uilibrary.components.selectdatepickerview;

import android.app.DatePickerDialog;
import android.content.Context;
import android.databinding.DataBindingUtil;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import br.com.stant.libraries.uilibrary.R;
import br.com.stant.libraries.uilibrary.components.selectdatepickerview.SelectDatePickerViewContract;
import br.com.stant.libraries.uilibrary.databinding.SelectDatePickerViewBinding;
import br.com.stant.libraries.uilibrary.utils.DateUtils;
import java.util.Calendar;
import java.util.Date;

public class SelectDatePickerView
extends LinearLayout
implements SelectDatePickerViewContract {
    private SelectDatePickerViewBinding mSelectDatePickerViewBinding;
    private DatePickerDialog mDatePickerDialog;
    private Date mDateSelected;
    private SelectDatePickerViewContract.OnDateSelect mOnDateSelected;

    public SelectDatePickerView(Context context) {
        super(context);
        if (!this.isInEditMode()) {
            this.init(context);
        }
    }

    public SelectDatePickerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (!this.isInEditMode()) {
            this.init(context);
        }
    }

    public SelectDatePickerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (!this.isInEditMode()) {
            this.init(context);
        }
    }

    private void init(Context context) {
        this.mSelectDatePickerViewBinding = (SelectDatePickerViewBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)context), (int)R.layout.select_date_picker_view, (ViewGroup)this, (boolean)true);
        this.mSelectDatePickerViewBinding.setDate(DateUtils.formatBrDate(new Date()));
        this.setOnClickListener(this::openDatePickerDialog);
        this.initializeDatePickerDialogConfiguration();
    }

    private void initializeDatePickerDialogConfiguration() {
        Calendar calendar = Calendar.getInstance();
        this.mDatePickerDialog = new DatePickerDialog(this.getContext(), this.getOnDateSetListener(), calendar.get(1), calendar.get(2), calendar.get(5));
    }

    private DatePickerDialog.OnDateSetListener getOnDateSetListener() {
        return (view, year, monthOfYear, dayOfMonth) -> {
            Calendar newDate = Calendar.getInstance();
            newDate.set(year, monthOfYear, dayOfMonth);
            this.setDate(newDate.getTime());
            if (this.mOnDateSelected != null) {
                this.mOnDateSelected.onDateSelect(this.mDateSelected);
            }
        };
    }

    @Override
    public void openDatePickerDialog(View view) {
        this.mDatePickerDialog.show();
    }

    @Override
    public void setOnDateSelected(SelectDatePickerViewContract.OnDateSelect onDateSelected) {
        this.mOnDateSelected = onDateSelected;
    }

    @Override
    public void setDate(Date date) {
        this.mDateSelected = date;
        this.mSelectDatePickerViewBinding.setDate(DateUtils.formatBrDate(this.mDateSelected));
    }

    @Override
    public Date getCurrentDate() {
        return this.mDateSelected;
    }
}

