/*
 * Decompiled with CFR 0.152.
 */
package br.com.stant.libraries.uilibrary.components.executedpercentbarview;

import android.content.Context;
import android.databinding.DataBindingUtil;
import android.support.v7.widget.CardView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import br.com.stant.libraries.uilibrary.R;
import br.com.stant.libraries.uilibrary.components.executedpercentbarview.ExecutedPercentBarViewContract;
import br.com.stant.libraries.uilibrary.databinding.ExecutedPercentBarViewBinding;
import java.util.Locale;

public class ExecutedPercentBarView
extends CardView
implements ExecutedPercentBarViewContract {
    private ExecutedPercentBarViewBinding mExecutedPercentBarViewBinding;
    private String mPercentDescriptionStringpt1;
    private String mPercentDescriptionStringpt2;
    private String mPercentValueStringpt1;
    private String mPercentValueStringpt2;
    private Integer mPercentValue;

    public ExecutedPercentBarView(Context context) {
        super(context);
        if (!this.isInEditMode()) {
            this.mExecutedPercentBarViewBinding = (ExecutedPercentBarViewBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)context), (int)R.layout.executed_percent_bar_view, (ViewGroup)this, (boolean)true);
        }
    }

    public ExecutedPercentBarView(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (!this.isInEditMode()) {
            this.init(context, attrs);
        }
    }

    public ExecutedPercentBarView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (!this.isInEditMode()) {
            this.init(context, attrs);
        }
    }

    private void init(Context context, AttributeSet attrs) {
        this.mExecutedPercentBarViewBinding = (ExecutedPercentBarViewBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)context), (int)R.layout.executed_percent_bar_view, (ViewGroup)this, (boolean)true);
    }

    @Override
    public void setPercentValue(Integer percentValue) {
        if (percentValue == null) {
            percentValue = 0;
        }
        this.mPercentValue = percentValue;
        this.executedPercentDescriptionListener(percentValue.intValue());
        this.executedPercentValueListener(percentValue.intValue());
        this.setGreenBarWeight(percentValue.intValue());
    }

    private void setGreenBarWeight(float percentValue) {
        LinearLayout.LayoutParams greenPercentBarLayoutParams = new LinearLayout.LayoutParams(0, -1, percentValue);
        this.mExecutedPercentBarViewBinding.executedPercentBarGreenBarPercentLinearLayout.setLayoutParams((ViewGroup.LayoutParams)greenPercentBarLayoutParams);
    }

    public void executedPercentDescriptionListener(float percentage) {
        this.mPercentDescriptionStringpt1 = "";
        this.mPercentDescriptionStringpt2 = "";
        String percentDescriptionLabel = this.getResources().getString(R.string.executed_percent_bar_bar_title);
        String language = Locale.getDefault().getDisplayLanguage();
        if (percentage <= 6.0f) {
            this.generatePercentDescriptionStringParts(0);
        } else if (percentage > 6.0f && percentage <= 8.0f) {
            this.generatePercentDescriptionStringParts(1);
        } else if (percentage > 8.0f && percentage <= 11.0f) {
            this.generatePercentDescriptionStringParts(2);
        } else if (percentage > 11.0f && percentage <= 13.0f) {
            this.generatePercentDescriptionStringParts(3);
        } else if (percentage > 13.0f && percentage <= 16.0f) {
            this.generatePercentDescriptionStringParts(4);
        } else if (percentage > 16.0f && percentage <= 18.0f) {
            this.generatePercentDescriptionStringParts(5);
        } else if (percentage > 18.0f && percentage <= 21.0f) {
            this.generatePercentDescriptionStringParts(6);
        } else if (percentage > 21.0f && percentage <= 23.0f) {
            this.generatePercentDescriptionStringParts(7);
        } else if (percentage > 23.0f && percentage <= 28.0f) {
            this.generatePercentDescriptionStringParts(8);
        } else if (percentage > 28.0f && percentage <= 30.0f && language.equals("portugu\u00eas")) {
            this.generatePercentDescriptionStringParts(9);
        } else {
            this.generatePercentDescriptionStringParts(percentDescriptionLabel.length());
        }
        this.mExecutedPercentBarViewBinding.setPercentDescriptionPt1(this.mPercentDescriptionStringpt1);
        this.mExecutedPercentBarViewBinding.setPercentDescriptionPt2(this.mPercentDescriptionStringpt2);
    }

    public void executedPercentValueListener(float percentage) {
        this.mPercentValueStringpt1 = "";
        this.mPercentValueStringpt2 = "";
        if (percentage <= 46.0f) {
            this.generatePercentValueStringParts(percentage, 0);
        } else if (percentage > 46.0f && percentage <= 49.0f) {
            this.generatePercentValueStringParts(percentage, 1);
        } else if (percentage > 49.0f && percentage <= 53.0f) {
            this.generatePercentValueStringParts(percentage, 2);
        } else if (percentage == 100.0f) {
            this.generatePercentValueStringParts(percentage, 4);
        } else {
            this.generatePercentValueStringParts(percentage, 3);
        }
        this.mExecutedPercentBarViewBinding.setPercentValuePt1(this.mPercentValueStringpt1);
        this.mExecutedPercentBarViewBinding.setPercentValuePt2(this.mPercentValueStringpt2);
    }

    public void generatePercentValueStringParts(float percentage, Integer limit) {
        int intPercentage = (int)percentage;
        String percentValueLabel = intPercentage + "%";
        this.mPercentValueStringpt1 = percentValueLabel.substring(0, limit);
        this.mPercentValueStringpt2 = percentValueLabel.substring(limit);
    }

    public void generatePercentDescriptionStringParts(Integer limit) {
        String percentDescriptionLabel = this.getContext().getResources().getString(R.string.executed_percent_bar_bar_title);
        this.mPercentDescriptionStringpt1 = percentDescriptionLabel.substring(0, limit);
        this.mPercentDescriptionStringpt2 = percentDescriptionLabel.substring(limit);
    }
}

