/*
 * Decompiled with CFR 0.152.
 */
package com.example.utils.permissions;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.view.View;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import com.example.agreement.R;
import com.example.utils.extensions.ContextExtension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J(\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bH\u0002J\b\u0010\u001c\u001a\u00020\fH\u0002J\u0010\u0010\u001d\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0012\u0010\u001e\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u000e\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Lcom/example/utils/permissions/AppPermissions;", "", "()V", "PERMISSIONS", "", "", "[Ljava/lang/String;", "PERMISSIONS_CODE", "", "deniedPermissions", "", "doNotAskIsChecked", "", "isNotApiAndroidM", "()Z", "addListeners", "", "context", "Landroid/content/Context;", "informationDialog", "Landroid/app/Dialog;", "okButton", "Landroid/widget/TextView;", "settingsOption", "buildPermissionDialog", "configureDialogs", "visibility", "contentText", "donNotAskIsChecked", "hasPermissions", "requestPermission", "requestPermissions", "agreement_release"})
public final class AppPermissions {
    private static final boolean doNotAskIsChecked = false;
    private static final int PERMISSIONS_CODE = 1;
    private static List<String> deniedPermissions;
    private static final String[] PERMISSIONS;
    public static final AppPermissions INSTANCE;

    public final boolean hasPermissions(@Nullable Context context) {
        boolean result = true;
        boolean bl = false;
        List deniedPermissions = new ArrayList();
        for (String permission : PERMISSIONS) {
            Integer permissionStatus;
            Integer n;
            if (context != null) {
                Context context2;
                boolean bl2 = false;
                boolean bl3 = false;
                Context it = context2;
                boolean bl4 = false;
                n = ActivityCompat.checkSelfPermission((Context)it, (String)permission);
            } else {
                n = null;
            }
            Integer n2 = permissionStatus = n;
            boolean bl5 = false;
            if (n2 != null && n2 == 0) continue;
            deniedPermissions.add(permission);
            result = false;
        }
        AppPermissions.deniedPermissions = deniedPermissions;
        deniedPermissions.add(String.valueOf(AppPermissions.deniedPermissions));
        return result;
    }

    private final boolean isNotApiAndroidM() {
        return Build.VERSION.SDK_INT < 23;
    }

    public final void requestPermissions(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.isNotApiAndroidM()) {
            return;
        }
        this.buildPermissionDialog(context).show();
    }

    private final Dialog buildPermissionDialog(Context context) {
        Dialog informationDialog = new Dialog(context);
        informationDialog.setContentView(R.layout.permission_information_dialog);
        if (this.donNotAskIsChecked()) {
            this.configureDialogs(context, informationDialog, 0, R.string.permission_information_dialog_never_checked_message);
        } else {
            this.configureDialogs(context, informationDialog, 8, R.string.permission_information_dialog_message);
        }
        return informationDialog;
    }

    private final boolean donNotAskIsChecked() {
        return false;
    }

    private final void configureDialogs(Context context, Dialog informationDialog, int visibility, int contentText) {
        TextView informationText = (TextView)informationDialog.findViewById(R.id.permission_information_dialog_text_view);
        TextView settingsButton = (TextView)informationDialog.findViewById(R.id.permission_information_dialog_go_to_settings_text_view);
        TextView okButton = (TextView)informationDialog.findViewById(R.id.permission_information_dialog_confirmation_text_view);
        TextView textView = informationText;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"informationText");
        textView.setText((CharSequence)context.getResources().getString(contentText));
        TextView textView2 = settingsButton;
        Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"settingsButton");
        textView2.setVisibility(visibility);
        Context context2 = (Context)ContextExtension.Companion.getActivity(context);
        TextView textView3 = okButton;
        Intrinsics.checkNotNullExpressionValue((Object)textView3, (String)"okButton");
        this.addListeners(context2, informationDialog, textView3, settingsButton);
    }

    private final void addListeners(Context context, Dialog informationDialog, TextView okButton, TextView settingsOption) {
        okButton.setOnClickListener(new View.OnClickListener(informationDialog, context){
            final /* synthetic */ Dialog $informationDialog;
            final /* synthetic */ Context $context;

            public final void onClick(View it) {
                this.$informationDialog.dismiss();
                AppPermissions.access$requestPermission(AppPermissions.INSTANCE, this.$context);
            }
            {
                this.$informationDialog = dialog;
                this.$context = context;
            }
        });
        settingsOption.setOnClickListener(new View.OnClickListener(context){
            final /* synthetic */ Context $context;

            public final void onClick(View it) {
                block0: {
                    Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
                    AppCompatActivity appCompatActivity = ContextExtension.Companion.getActivity(this.$context);
                    Intrinsics.checkNotNull((Object)appCompatActivity);
                    Uri uri = Uri.fromParts((String)"package", (String)appCompatActivity.getPackageName(), null);
                    intent.setData(uri);
                    AppCompatActivity appCompatActivity2 = ContextExtension.Companion.getActivity(this.$context);
                    if (appCompatActivity2 == null) break block0;
                    appCompatActivity2.startActivityForResult(intent, 1);
                }
            }
            {
                this.$context = context;
            }
        });
    }

    private final void requestPermission(Context context) {
        block3: {
            block2: {
                if (this.hasPermissions(context) || deniedPermissions == null) break block2;
                AppCompatActivity appCompatActivity = ContextExtension.Companion.getActivity(context);
                Intrinsics.checkNotNull((Object)appCompatActivity);
                Activity activity = (Activity)appCompatActivity;
                List<String> list = deniedPermissions;
                Intrinsics.checkNotNull(list);
                Collection $this$toTypedArray$iv = list;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                ActivityCompat.requestPermissions((Activity)activity, (String[])stringArray, (int)1);
                deniedPermissions = null;
                break block3;
            }
            Context context2 = context;
            if (this.hasPermissions((Context)(context2 != null ? context2.getApplicationContext() : null)) || deniedPermissions != null) break block3;
            AppCompatActivity appCompatActivity = ContextExtension.Companion.getActivity(context);
            if (appCompatActivity != null) {
                AppCompatActivity appCompatActivity2 = appCompatActivity;
                boolean bl = false;
                boolean bl2 = false;
                AppCompatActivity activity = appCompatActivity2;
                boolean bl3 = false;
                ActivityCompat.requestPermissions((Activity)((Activity)activity), (String[])PERMISSIONS, (int)1);
            }
        }
    }

    private AppPermissions() {
    }

    static {
        AppPermissions appPermissions;
        INSTANCE = appPermissions = new AppPermissions();
        PERMISSIONS = new String[]{"android.permission.READ_PHONE_STATE", "android.permission.CAMERA", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"};
    }

    public static final /* synthetic */ void access$requestPermission(AppPermissions $this, Context context) {
        $this.requestPermission(context);
    }
}

