/*
 * Decompiled with CFR 0.152.
 */
package github.com.st235.lib_expandablebottombar.utils;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.FloatRange;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.ColorUtils;
import androidx.core.graphics.drawable.DrawableCompat;
import github.com.st235.lib_expandablebottombar.utils.DimensExtsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010\u000b\u001a\u00020\n2\b\b\u0001\u0010\f\u001a\u00020\b2\b\b\u0001\u0010\r\u001a\u00020\bJ8\u0010\u000e\u001a\u00020\u00042\b\b\u0001\u0010\u000f\u001a\u00020\b2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00112\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u0014J\u000e\u0010\u0016\u001a\u00020\u0004*\u0004\u0018\u00010\u0004H\u0002\u00a8\u0006\u0017"}, d2={"Lgithub/com/st235/lib_expandablebottombar/utils/DrawableHelper;", "", "()V", "createDrawable", "Landroid/graphics/drawable/Drawable;", "context", "Landroid/content/Context;", "menuItem", "", "stateList", "Landroid/content/res/ColorStateList;", "createSelectedUnselectedStateList", "selectedColor", "unselectedColor", "createShapeDrawable", "color", "shouldFill", "", "shouldStroke", "cornerRadius", "", "opacity", "deepCopy", "lib-expandablebottombar_release"})
public final class DrawableHelper {
    @NotNull
    public static final DrawableHelper INSTANCE = new DrawableHelper();

    private DrawableHelper() {
    }

    @NotNull
    public final Drawable createShapeDrawable(@ColorInt int color, boolean shouldFill, boolean shouldStroke, @FloatRange(from=0.0) float cornerRadius, @FloatRange(from=0.0, to=1.0) float opacity) {
        GradientDrawable footerBackground = new GradientDrawable();
        float[] radii = new float[8];
        for (int i = 0; i < 8; ++i) {
            radii[i] = cornerRadius;
        }
        footerBackground.setShape(0);
        footerBackground.setCornerRadii(radii);
        if (shouldFill) {
            footerBackground.setColor(ColorUtils.setAlphaComponent((int)color, (int)((int)(opacity * (float)255))));
        }
        if (shouldStroke) {
            footerBackground.setStroke(DimensExtsKt.toPx(2), color);
        }
        return (Drawable)footerBackground;
    }

    public static /* synthetic */ Drawable createShapeDrawable$default(DrawableHelper drawableHelper, int n, boolean bl, boolean bl2, float f, float f2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        if ((n2 & 4) != 0) {
            bl2 = false;
        }
        return drawableHelper.createShapeDrawable(n, bl, bl2, f, f2);
    }

    @NotNull
    public final ColorStateList createSelectedUnselectedStateList(@ColorInt int selectedColor, @ColorInt int unselectedColor) {
        Object object = new int[2][];
        int[] nArray = new int[]{0x10100A1};
        object[0] = nArray;
        nArray = new int[]{-16842913};
        object[1] = nArray;
        int[][] nArrayArray = object;
        object = new int[2];
        object[0] = (int[])selectedColor;
        object[1] = (int[])unselectedColor;
        return new ColorStateList((int[][])nArrayArray, (int[])object);
    }

    @NotNull
    public final Drawable createDrawable(@NotNull Context context, @DrawableRes int menuItem2, @NotNull ColorStateList stateList) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)stateList, (String)"stateList");
        Drawable drawable = DrawableCompat.wrap((Drawable)this.deepCopy(ContextCompat.getDrawable((Context)context, (int)menuItem2)));
        Intrinsics.checkNotNullExpressionValue((Object)drawable, (String)"wrap(\n            Contex\u2026tem).deepCopy()\n        )");
        Drawable iconDrawable = drawable;
        DrawableCompat.setTintList((Drawable)iconDrawable, (ColorStateList)stateList);
        return iconDrawable;
    }

    private final Drawable deepCopy(Drawable $this$deepCopy) {
        Drawable drawable;
        Drawable drawable2 = $this$deepCopy;
        Drawable drawable3 = drawable2 != null && (drawable2 = drawable2.mutate()) != null && (drawable2 = drawable2.getConstantState()) != null ? drawable2.newDrawable() : (drawable = null);
        if (drawable == null) {
            throw new IllegalStateException("Cannot clone existing drawable");
        }
        return drawable;
    }
}

