/*
 * Decompiled with CFR 0.152.
 */
package github.com.st235.lib_expandablebottombar.components.notifications.badges;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import androidx.annotation.ColorInt;
import github.com.st235.lib_expandablebottombar.components.notifications.badges.CharacterDrawer;
import github.com.st235.lib_expandablebottombar.utils.MathHelperKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lgithub/com/st235/lib_expandablebottombar/components/notifications/badges/OneSymbolDrawer;", "Lgithub/com/st235/lib_expandablebottombar/components/notifications/badges/CharacterDrawer;", "textColor", "", "text", "", "(ILjava/lang/String;)V", "draw", "", "paint", "Landroid/graphics/Paint;", "viewBounds", "Landroid/graphics/RectF;", "canvas", "Landroid/graphics/Canvas;", "lib-expandablebottombar_release"})
public final class OneSymbolDrawer
extends CharacterDrawer {
    private final int textColor;

    public OneSymbolDrawer(@ColorInt int textColor, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text);
        this.textColor = textColor;
    }

    @Override
    public void draw(@NotNull Paint paint, @NotNull RectF viewBounds, @NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        Intrinsics.checkNotNullParameter((Object)viewBounds, (String)"viewBounds");
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        float width = this.getTextWidth(paint);
        float height = this.getTextHeight(paint);
        float topRightX = viewBounds.right;
        float topRightY = viewBounds.top;
        float radius = ((Number)((Object)MathHelperKt.max((Comparable)Float.valueOf(width), (Comparable)Float.valueOf(height)))).floatValue() / 2.0f + ((Number)((Object)MathHelperKt.max((Comparable)Float.valueOf(this.getVerticalPadding()), (Comparable)Float.valueOf(this.getHorizontalPadding())))).floatValue();
        float centerX = topRightX - radius / 2.0f;
        float centerY = topRightY + radius / 2.0f;
        canvas.drawCircle(centerX, centerY, radius, paint);
        int oldColor = paint.getColor();
        paint.setColor(this.textColor);
        canvas.drawText(this.getText(), centerX, centerY + this.getTextOffset(paint), paint);
        paint.setColor(oldColor);
    }
}

