/*
 * Decompiled with CFR 0.152.
 */
package github.com.st235.lib_expandablebottombar.components.notifications.badges;

import android.graphics.Paint;
import androidx.annotation.Px;
import github.com.st235.lib_expandablebottombar.components.notifications.badges.BadgeDrawer;
import github.com.st235.lib_expandablebottombar.utils.DimensExtsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0015J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0015J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0005J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0015J\b\u0010\u000e\u001a\u00020\bH\u0015R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lgithub/com/st235/lib_expandablebottombar/components/notifications/badges/CharacterDrawer;", "Lgithub/com/st235/lib_expandablebottombar/components/notifications/badges/BadgeDrawer;", "text", "", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "getHorizontalPadding", "", "getTextHeight", "paint", "Landroid/graphics/Paint;", "getTextOffset", "getTextWidth", "getVerticalPadding", "lib-expandablebottombar_release"})
public abstract class CharacterDrawer
implements BadgeDrawer {
    @NotNull
    private final String text;

    public CharacterDrawer(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.text = text;
    }

    @NotNull
    protected final String getText() {
        return this.text;
    }

    @Px
    protected float getVerticalPadding() {
        return DimensExtsKt.toPx(2.0f);
    }

    @Px
    protected float getHorizontalPadding() {
        return DimensExtsKt.toPx(2.0f);
    }

    @Px
    protected float getTextWidth(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        return paint.measureText(this.text, 0, this.text.length());
    }

    @Px
    protected float getTextHeight(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        Paint.FontMetrics fm = paint.getFontMetrics();
        return fm.descent - fm.ascent;
    }

    @Px
    protected final float getTextOffset(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        float textHeight = this.getTextHeight(paint);
        return textHeight / 2.0f - paint.descent();
    }
}

