/*
 * Decompiled with CFR 0.152.
 */
package github.com.st235.lib_expandablebottombar.behavior;

import android.animation.Animator;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.view.ViewCompat;
import github.com.st235.lib_expandablebottombar.behavior.ExpandableBottomBarBehavior;
import github.com.st235.lib_expandablebottombar.utils.AnimationHelper;
import github.com.st235.lib_expandablebottombar.utils.MathHelperKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001d\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u0014H\u0002J\u0015\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001dJ\u001d\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010 JU\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010$\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020+H\u0016\u00a2\u0006\u0002\u0010,J=\u0010-\u001a\u00020.2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010/\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u00022\u0006\u00100\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u00101J-\u00102\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010$\u001a\u00020\u00022\u0006\u0010)\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u00103J\b\u00104\u001a\u00020\u0014H\u0002R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lgithub/com/st235/lib_expandablebottombar/behavior/ExpandableBottomBarScrollableBehavior;", "V", "Landroid/view/View;", "Lgithub/com/st235/lib_expandablebottombar/behavior/ExpandableBottomBarBehavior;", "()V", "context", "Landroid/content/Context;", "attributeSet", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "animator", "Landroid/animation/Animator;", "handler", "Landroid/os/Handler;", "lastKnownDirection", "", "Ljava/lang/Integer;", "lastKnownRunnable", "Ljava/lang/Runnable;", "animateTo", "", "child", "translation", "", "(Landroid/view/View;F)V", "animateWithDirection", "(Landroid/view/View;)V", "cancelAnimation", "getMaxScrollDistance", "(Landroid/view/View;)F", "getScrollRange", "dy", "(Landroid/view/View;I)F", "onNestedScroll", "coordinatorLayout", "Landroidx/coordinatorlayout/widget/CoordinatorLayout;", "target", "dxConsumed", "dyConsumed", "dxUnconsumed", "dyUnconsumed", "type", "consumed", "", "(Landroidx/coordinatorlayout/widget/CoordinatorLayout;Landroid/view/View;Landroid/view/View;IIIII[I)V", "onStartNestedScroll", "", "directTargetChild", "axes", "(Landroidx/coordinatorlayout/widget/CoordinatorLayout;Landroid/view/View;Landroid/view/View;Landroid/view/View;II)Z", "onStopNestedScroll", "(Landroidx/coordinatorlayout/widget/CoordinatorLayout;Landroid/view/View;Landroid/view/View;I)V", "removeActiveRunnable", "lib-expandablebottombar_release"})
public final class ExpandableBottomBarScrollableBehavior<V extends View>
extends ExpandableBottomBarBehavior<V> {
    @NotNull
    private final Handler handler;
    @Nullable
    private Runnable lastKnownRunnable;
    @Nullable
    private Animator animator;
    @Nullable
    private Integer lastKnownDirection;

    public ExpandableBottomBarScrollableBehavior() {
        this.handler = new Handler(Looper.getMainLooper());
    }

    public ExpandableBottomBarScrollableBehavior(@NotNull Context context, @NotNull AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attributeSet, (String)"attributeSet");
        super(context, attributeSet);
        this.handler = new Handler(Looper.getMainLooper());
    }

    public boolean onStartNestedScroll(@NotNull CoordinatorLayout coordinatorLayout, @NotNull V child, @NotNull View directTargetChild, @NotNull View target, int axes, int type) {
        Intrinsics.checkNotNullParameter((Object)coordinatorLayout, (String)"coordinatorLayout");
        Intrinsics.checkNotNullParameter(child, (String)"child");
        Intrinsics.checkNotNullParameter((Object)directTargetChild, (String)"directTargetChild");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return axes == 2;
    }

    public void onNestedScroll(@NotNull CoordinatorLayout coordinatorLayout, @NotNull V child, @NotNull View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int type, @NotNull int[] consumed) {
        Intrinsics.checkNotNullParameter((Object)coordinatorLayout, (String)"coordinatorLayout");
        Intrinsics.checkNotNullParameter(child, (String)"child");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)consumed, (String)"consumed");
        super.onNestedScroll(coordinatorLayout, child, target, dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, type, consumed);
        this.removeActiveRunnable();
        this.cancelAnimation();
        this.lastKnownDirection = dyConsumed;
        child.setTranslationY(this.getScrollRange(child, dyConsumed));
    }

    public void onStopNestedScroll(@NotNull CoordinatorLayout coordinatorLayout, @NotNull V child, @NotNull View target, int type) {
        Intrinsics.checkNotNullParameter((Object)coordinatorLayout, (String)"coordinatorLayout");
        Intrinsics.checkNotNullParameter(child, (String)"child");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        super.onStopNestedScroll(coordinatorLayout, child, target, type);
        this.removeActiveRunnable();
        Runnable delayedAnimationRunnable = () -> ExpandableBottomBarScrollableBehavior.onStopNestedScroll$lambda-0(this, child);
        this.handler.postDelayed(delayedAnimationRunnable, 500L);
        this.lastKnownRunnable = delayedAnimationRunnable;
    }

    private final float getScrollRange(V child, int dy) {
        return ((Number)((Object)MathHelperKt.clamp((Comparable)Float.valueOf(child.getTranslationY() + (float)dy), (Comparable)Float.valueOf(0.0f), (Comparable)Float.valueOf(this.getMaxScrollDistance(child))))).floatValue();
    }

    private final float getMaxScrollDistance(V child) {
        int childHeight = ViewCompat.isLaidOut(child) ? child.getHeight() : child.getMeasuredHeight();
        float f = childHeight;
        V $this$marginBottom$iv = child;
        boolean $i$f$getMarginBottom = false;
        ViewGroup.LayoutParams layoutParams = $this$marginBottom$iv.getLayoutParams();
        if (!(layoutParams instanceof ViewGroup.MarginLayoutParams)) {
            layoutParams = null;
        }
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)layoutParams;
        return f + (float)(marginLayoutParams != null ? marginLayoutParams.bottomMargin : 0);
    }

    private final void animateWithDirection(V child) {
        boolean lessThanHalfDown;
        Integer n = this.lastKnownDirection;
        if (n == null) {
            return;
        }
        int dy = n;
        float halfOfScrollDistance = this.getMaxScrollDistance(child) / 2.0f;
        boolean overHalfUp = dy < 0 && Math.abs(child.getTranslationY()) < halfOfScrollDistance;
        boolean bl = lessThanHalfDown = dy > 0 && Math.abs(child.getTranslationY()) < halfOfScrollDistance;
        if (overHalfUp || lessThanHalfDown) {
            this.animateTo(child, 0.0f);
        } else {
            this.animateTo(child, this.getMaxScrollDistance(child));
        }
    }

    private final void animateTo(V child, float translation) {
        block1: {
            if (child.getTranslationY() == 0.0f || child.getTranslationY() == this.getMaxScrollDistance(child)) {
                return;
            }
            this.cancelAnimation();
            Animator animator = this.animator = AnimationHelper.INSTANCE.translateViewTo(child, translation);
            if (animator == null) break block1;
            animator.start();
        }
    }

    private final void cancelAnimation() {
        if (this.animator != null) {
            Animator animator = this.animator;
            boolean bl = animator != null ? animator.isRunning() : false;
            if (bl) {
                Animator animator2 = this.animator;
                if (animator2 != null) {
                    animator2.cancel();
                }
                this.animator = null;
            }
        }
    }

    private final void removeActiveRunnable() {
        Runnable runnableToDelete = this.lastKnownRunnable;
        if (runnableToDelete != null) {
            this.handler.removeCallbacks(runnableToDelete);
            this.lastKnownRunnable = null;
        }
    }

    private static final void onStopNestedScroll$lambda-0(ExpandableBottomBarScrollableBehavior this$0, View $child) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$child, (String)"$child");
        this$0.animateWithDirection($child);
    }
}

