/*
 * Decompiled with CFR 0.152.
 */
package github.com.st235.lib_expandablebottombar;

import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.IdRes;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import github.com.st235.lib_expandablebottombar.ExpandableBottomBar;
import github.com.st235.lib_expandablebottombar.Menu;
import github.com.st235.lib_expandablebottombar.MenuItem;
import github.com.st235.lib_expandablebottombar.MenuItemDescriptor;
import github.com.st235.lib_expandablebottombar.Notification;
import github.com.st235.lib_expandablebottombar.components.MenuItemView;
import github.com.st235.lib_expandablebottombar.utils.ConstraintLayoutHelper;
import github.com.st235.lib_expandablebottombar.utils.TransitionHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u000eJ\u0006\u0010\"\u001a\u00020\u001fJ\u0006\u0010#\u001a\u00020$J\b\u0010%\u001a\u00020\u001fH\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u001a\u0010&\u001a\u00020\u001f2\b\b\u0001\u0010'\u001a\u00020\u000e2\b\b\u0001\u0010(\u001a\u00020\u000eJ\u0006\u0010)\u001a\u00020\u001fJ\u0006\u0010*\u001a\u00020\u001fJ\u001a\u0010+\u001a\u00020\u001f2\b\u0010,\u001a\u0004\u0018\u00010\u00002\b\u0010-\u001a\u0004\u0018\u00010\u0000J\b\u0010.\u001a\u00020\u001fH\u0016R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lgithub/com/st235/lib_expandablebottombar/MenuItemImpl;", "Lgithub/com/st235/lib_expandablebottombar/MenuItem;", "menuItemDescriptor", "Lgithub/com/st235/lib_expandablebottombar/MenuItemDescriptor;", "rootView", "Lgithub/com/st235/lib_expandablebottombar/ExpandableBottomBar;", "itemView", "Lgithub/com/st235/lib_expandablebottombar/components/MenuItemView;", "transitionHelper", "Lgithub/com/st235/lib_expandablebottombar/utils/TransitionHelper;", "constraintLayoutHelper", "Lgithub/com/st235/lib_expandablebottombar/utils/ConstraintLayoutHelper;", "(Lgithub/com/st235/lib_expandablebottombar/MenuItemDescriptor;Lgithub/com/st235/lib_expandablebottombar/ExpandableBottomBar;Lgithub/com/st235/lib_expandablebottombar/components/MenuItemView;Lgithub/com/st235/lib_expandablebottombar/utils/TransitionHelper;Lgithub/com/st235/lib_expandablebottombar/utils/ConstraintLayoutHelper;)V", "activeColor", "", "getActiveColor", "()I", "id", "getId", "<set-?>", "", "isAttached", "()Z", "isShown", "notification", "Lgithub/com/st235/lib_expandablebottombar/Notification;", "text", "", "getText", "()Ljava/lang/CharSequence;", "attachToSuperView", "", "menuItemHorizontalMargin", "menuItemVerticalMargin", "deselect", "getView", "Landroid/view/View;", "hide", "rebuildSiblingsConnection", "previousIconId", "nextIconId", "removeFromSuperView", "select", "setAccessibleWith", "prev", "next", "show", "lib-expandablebottombar_release"})
public final class MenuItemImpl
implements MenuItem {
    @NotNull
    private final ExpandableBottomBar rootView;
    @NotNull
    private final MenuItemView itemView;
    @NotNull
    private final TransitionHelper transitionHelper;
    @NotNull
    private final ConstraintLayoutHelper constraintLayoutHelper;
    @NotNull
    private final Notification notification;
    private final int id;
    @NotNull
    private final CharSequence text;
    private final int activeColor;
    private boolean isAttached;

    public MenuItemImpl(@NotNull MenuItemDescriptor menuItemDescriptor, @NotNull ExpandableBottomBar rootView, @NotNull MenuItemView itemView, @NotNull TransitionHelper transitionHelper, @NotNull ConstraintLayoutHelper constraintLayoutHelper) {
        Intrinsics.checkNotNullParameter((Object)menuItemDescriptor, (String)"menuItemDescriptor");
        Intrinsics.checkNotNullParameter((Object)((Object)rootView), (String)"rootView");
        Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
        Intrinsics.checkNotNullParameter((Object)transitionHelper, (String)"transitionHelper");
        Intrinsics.checkNotNullParameter((Object)constraintLayoutHelper, (String)"constraintLayoutHelper");
        this.rootView = rootView;
        this.itemView = itemView;
        this.transitionHelper = transitionHelper;
        this.constraintLayoutHelper = constraintLayoutHelper;
        this.notification = new Notification(this.itemView);
        this.id = menuItemDescriptor.getItemId();
        this.text = menuItemDescriptor.getText();
        this.activeColor = menuItemDescriptor.getActiveColor();
    }

    public /* synthetic */ MenuItemImpl(MenuItemDescriptor menuItemDescriptor, ExpandableBottomBar expandableBottomBar, MenuItemView menuItemView, TransitionHelper transitionHelper, ConstraintLayoutHelper constraintLayoutHelper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            transitionHelper = new TransitionHelper();
        }
        if ((n & 0x10) != 0) {
            constraintLayoutHelper = new ConstraintLayoutHelper();
        }
        this(menuItemDescriptor, expandableBottomBar, menuItemView, transitionHelper, constraintLayoutHelper);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    @NotNull
    public CharSequence getText() {
        return this.text;
    }

    @Override
    public int getActiveColor() {
        return this.activeColor;
    }

    public final void setAccessibleWith(@Nullable MenuItemImpl prev, @Nullable MenuItemImpl next) {
        ViewCompat.setAccessibilityDelegate((View)((View)this.itemView), (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(prev, next){
            final /* synthetic */ MenuItemImpl $prev;
            final /* synthetic */ MenuItemImpl $next;
            {
                this.$prev = $prev;
                this.$next = $next;
            }

            public void onInitializeAccessibilityNodeInfo(@NotNull View host, @NotNull AccessibilityNodeInfoCompat info) {
                Intrinsics.checkNotNullParameter((Object)host, (String)"host");
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                MenuItemImpl menuItemImpl = this.$prev;
                info.setTraversalAfter((View)(menuItemImpl != null ? MenuItemImpl.access$getItemView$p(menuItemImpl) : null));
                MenuItemImpl menuItemImpl2 = this.$next;
                info.setTraversalBefore((View)(menuItemImpl2 != null ? MenuItemImpl.access$getItemView$p(menuItemImpl2) : null));
                super.onInitializeAccessibilityNodeInfo(host, info);
            }
        });
    }

    @Override
    public boolean isShown() {
        return this.itemView.getVisibility() == 0;
    }

    @Override
    public boolean isAttached() {
        return this.isAttached;
    }

    @Override
    public void show() {
        TransitionHelper.apply$default(this.transitionHelper, (ViewGroup)this.rootView, 0L, 2, null);
        this.itemView.setVisibility(0);
    }

    @Override
    public void hide() {
        Menu menu = this.rootView.getMenu();
        TransitionHelper.apply$default(this.transitionHelper, (ViewGroup)this.rootView, 0L, 2, null);
        this.itemView.setVisibility(8);
        if (Intrinsics.areEqual((Object)menu.getSelectedItem(), (Object)this)) {
            menu.deselect();
        }
    }

    @Override
    @NotNull
    public Notification notification() {
        return this.notification;
    }

    public final void select() {
        this.itemView.select();
    }

    public final void deselect() {
        this.itemView.deselect();
    }

    @NotNull
    public final View getView() {
        return (View)this.itemView;
    }

    public final void attachToSuperView(int menuItemHorizontalMargin, int menuItemVerticalMargin) {
        this.isAttached = true;
        ConstraintLayout.LayoutParams lp = this.constraintLayoutHelper.layoutParams(menuItemHorizontalMargin, menuItemVerticalMargin);
        this.rootView.addView((View)this.itemView, (ViewGroup.LayoutParams)lp);
    }

    public final void removeFromSuperView() {
        this.isAttached = false;
        this.rootView.removeView((View)this.itemView);
    }

    public final void rebuildSiblingsConnection(@IdRes int previousIconId, @IdRes int nextIconId) {
        this.constraintLayoutHelper.applyNewConstraintSetFor((View)this.itemView, this.rootView, previousIconId, nextIconId);
    }

    public static final /* synthetic */ MenuItemView access$getItemView$p(MenuItemImpl $this) {
        return $this.itemView;
    }
}

