/*
 * Decompiled with CFR 0.152.
 */
package zlc.season.rxdownload4.utils;

import io.reactivex.disposables.Disposable;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u001a\u0015\u0010\u0007\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0086\u0004\u001a\f\u0010\t\u001a\u00020\n*\u0004\u0018\u00010\u000b\u001a\u0012\u0010\f\u001a\u00020\u0006*\u00020\u00052\u0006\u0010\r\u001a\u00020\u0006\u00a8\u0006\u000e"}, d2={"decimal", "", "digits", "", "formatSize", "", "", "ratio", "bottom", "safeDispose", "", "Lio/reactivex/disposables/Disposable;", "toLongOrDefault", "defaultValue", "rxdownload4_release"})
public final class UtilKt {
    public static final void safeDispose(@Nullable Disposable $this$safeDispose) {
        if ($this$safeDispose != null && !$this$safeDispose.isDisposed()) {
            $this$safeDispose.dispose();
        }
    }

    public static final long toLongOrDefault(@NotNull String $this$toLongOrDefault, long defaultValue) {
        long l;
        Intrinsics.checkParameterIsNotNull((Object)$this$toLongOrDefault, (String)"$this$toLongOrDefault");
        try {
            String string = $this$toLongOrDefault;
            boolean bl = false;
            l = Long.parseLong(string);
        }
        catch (NumberFormatException _) {
            l = defaultValue;
        }
        return l;
    }

    @NotNull
    public static final String formatSize(long $this$formatSize) {
        boolean bl = $this$formatSize >= 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Size must larger than 0.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        double d = $this$formatSize;
        double kb = d / 1024.0;
        double mb = d / 1024.0 / 1024.0;
        double gb = d / 1024.0 / 1024.0 / 1024.0;
        double tb = d / 1024.0 / 1024.0 / 1024.0 / 1024.0;
        return tb >= 1.0 ? UtilKt.decimal(tb, 2) + " TB" : (gb >= 1.0 ? UtilKt.decimal(gb, 2) + " GB" : (mb >= 1.0 ? UtilKt.decimal(mb, 2) + " MB" : (kb >= 1.0 ? UtilKt.decimal(kb, 2) + " KB" : UtilKt.decimal(d, 2) + " B")));
    }

    public static final double decimal(double $this$decimal, int digits) {
        double d = $this$decimal;
        boolean bl = false;
        return new BigDecimal(String.valueOf(d)).setScale(digits, 4).doubleValue();
    }

    public static final double ratio(long $this$ratio, long bottom) {
        if (bottom <= 0L) {
            return 0.0;
        }
        double d = (double)$this$ratio * 100.0;
        boolean bl = false;
        BigDecimal bigDecimal = new BigDecimal(String.valueOf(d));
        d = (double)bottom * 1.0;
        BigDecimal bigDecimal2 = bigDecimal;
        bl = false;
        BigDecimal bigDecimal3 = new BigDecimal(String.valueOf(d));
        BigDecimal result = bigDecimal2.divide(bigDecimal3, 2, 4);
        return result.doubleValue();
    }
}

