/*
 * Decompiled with CFR 0.152.
 */
package zlc.season.rxdownload4.downloader;

import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import retrofit2.Response;
import zlc.season.rxdownload4.task.TaskInfo;
import zlc.season.rxdownload4.utils.HttpUtilKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u0017\u0018\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nJ\u001a\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\u001a\u0010\u0015\u001a\u00020\u00162\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lzlc/season/rxdownload4/downloader/RangeTmpFile;", "", "tmpFile", "Ljava/io/File;", "(Ljava/io/File;)V", "content", "Lzlc/season/rxdownload4/downloader/RangeTmpFile$FileContent;", "header", "Lzlc/season/rxdownload4/downloader/RangeTmpFile$FileHeader;", "lastProgress", "Lkotlin/Pair;", "", "read", "", "response", "Lretrofit2/Response;", "taskInfo", "Lzlc/season/rxdownload4/task/TaskInfo;", "undoneSegments", "", "Lzlc/season/rxdownload4/downloader/RangeTmpFile$Segment;", "write", "", "FileContent", "FileHeader", "Segment", "rxdownload4_release"})
public final class RangeTmpFile {
    private final FileHeader header;
    private final FileContent content;
    private final File tmpFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(@NotNull Response<?> response, @NotNull TaskInfo taskInfo) {
        Intrinsics.checkParameterIsNotNull(response, (String)"response");
        Intrinsics.checkParameterIsNotNull((Object)taskInfo, (String)"taskInfo");
        long totalSize = HttpUtilKt.contentLength(response);
        long totalSegments = HttpUtilKt.sliceCount(response, taskInfo.getRangeSize());
        Closeable closeable = (Closeable)Okio.buffer((Sink)Okio.sink$default((File)this.tmpFile, (boolean)false, (int)1, null));
        boolean bl = false;
        Throwable throwable = null;
        try {
            BufferedSink it = (BufferedSink)closeable;
            boolean bl2 = false;
            this.header.write(it, totalSize, totalSegments);
            this.content.write(it, totalSize, totalSegments, taskInfo.getRangeSize());
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean read(@NotNull Response<?> response, @NotNull TaskInfo taskInfo) {
        Intrinsics.checkParameterIsNotNull(response, (String)"response");
        Intrinsics.checkParameterIsNotNull((Object)taskInfo, (String)"taskInfo");
        long totalSize = HttpUtilKt.contentLength(response);
        long totalSegments = HttpUtilKt.sliceCount(response, taskInfo.getRangeSize());
        Closeable closeable = (Closeable)Okio.buffer((Source)Okio.source((File)this.tmpFile));
        boolean bl = false;
        Throwable throwable = null;
        try {
            BufferedSource it = (BufferedSource)closeable;
            boolean bl2 = false;
            this.header.read(it);
            this.content.read(it, this.header.getTotalSegments());
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return this.header.check(totalSize, totalSegments);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Segment> undoneSegments() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.content.getSegments();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Segment it = (Segment)element$iv$iv;
            boolean bl = false;
            if (!(!it.isComplete())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Pair<Long, Long> lastProgress() {
        long totalSize = this.header.getTotalSize();
        long downloadSize = this.content.downloadSize();
        return new Pair((Object)downloadSize, (Object)totalSize);
    }

    public RangeTmpFile(@NotNull File tmpFile) {
        Intrinsics.checkParameterIsNotNull((Object)tmpFile, (String)"tmpFile");
        this.tmpFile = tmpFile;
        this.header = new FileHeader(0L, 0L, 3, null);
        this.content = new FileContent();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lzlc/season/rxdownload4/downloader/RangeTmpFile$FileHeader;", "", "totalSize", "", "totalSegments", "(JJ)V", "getTotalSegments", "()J", "setTotalSegments", "(J)V", "getTotalSize", "setTotalSize", "check", "", "read", "", "source", "Lokio/BufferedSource;", "write", "sink", "Lokio/BufferedSink;", "Companion", "rxdownload4_release"})
    public static final class FileHeader {
        private long totalSize;
        private long totalSegments;
        @NotNull
        public static final String FILE_HEADER_MAGIC_NUMBER = "a1b2c3d4e5f6";
        public static final long FILE_HEADER_MAGIC_NUMBER_SIZE = 6L;
        public static final long FILE_HEADER_SIZE = 22L;
        public static final Companion Companion = new Companion(null);

        public final void write(@NotNull BufferedSink sink, long totalSize, long totalSegments) {
            Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
            this.totalSize = totalSize;
            this.totalSegments = totalSegments;
            BufferedSink bufferedSink = sink;
            boolean bl = false;
            boolean bl2 = false;
            BufferedSink $this$apply = bufferedSink;
            boolean bl3 = false;
            $this$apply.write(ByteString.Companion.decodeHex(FILE_HEADER_MAGIC_NUMBER));
            $this$apply.writeLong(totalSize);
            $this$apply.writeLong(totalSegments);
        }

        public final void read(@NotNull BufferedSource source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            String header = source.readByteString(6L).hex();
            if (Intrinsics.areEqual((Object)header, (Object)FILE_HEADER_MAGIC_NUMBER) ^ true) {
                throw (Throwable)new RuntimeException("not a tmp file");
            }
            this.totalSize = source.readLong();
            this.totalSegments = source.readLong();
        }

        public final boolean check(long totalSize, long totalSegments) {
            return this.totalSize == totalSize && this.totalSegments == totalSegments;
        }

        public final long getTotalSize() {
            return this.totalSize;
        }

        public final void setTotalSize(long l) {
            this.totalSize = l;
        }

        public final long getTotalSegments() {
            return this.totalSegments;
        }

        public final void setTotalSegments(long l) {
            this.totalSegments = l;
        }

        public FileHeader(long totalSize, long totalSegments) {
            this.totalSize = totalSize;
            this.totalSegments = totalSegments;
        }

        public /* synthetic */ FileHeader(long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                l = 0L;
            }
            if ((n & 2) != 0) {
                l2 = 0L;
            }
            this(l, l2);
        }

        public FileHeader() {
            this(0L, 0L, 3, null);
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lzlc/season/rxdownload4/downloader/RangeTmpFile$FileHeader$Companion;", "", "()V", "FILE_HEADER_MAGIC_NUMBER", "", "FILE_HEADER_MAGIC_NUMBER_SIZE", "", "FILE_HEADER_SIZE", "rxdownload4_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tJ \u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0002J&\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lzlc/season/rxdownload4/downloader/RangeTmpFile$FileContent;", "", "()V", "segments", "", "Lzlc/season/rxdownload4/downloader/RangeTmpFile$Segment;", "getSegments", "()Ljava/util/List;", "downloadSize", "", "read", "", "source", "Lokio/BufferedSource;", "totalSegments", "sliceSegments", "totalSize", "rangeSize", "write", "sink", "Lokio/BufferedSink;", "rxdownload4_release"})
    public static final class FileContent {
        @NotNull
        private final List<Segment> segments;

        @NotNull
        public final List<Segment> getSegments() {
            return this.segments;
        }

        public final void write(@NotNull BufferedSink sink, long totalSize, long totalSegments, long rangeSize) {
            Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
            this.segments.clear();
            this.sliceSegments(totalSize, totalSegments, rangeSize);
            Iterable $this$forEach$iv = this.segments;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Segment it = (Segment)element$iv;
                boolean bl = false;
                it.write(sink);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void read(@NotNull BufferedSource source, long totalSegments) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            this.segments.clear();
            long l = 0L;
            long l2 = totalSegments;
            while (l < l2) {
                void i;
                this.segments.add(new Segment(0L, 0L, 0L, 0L, 15, null).read(source));
                ++i;
            }
        }

        public final long downloadSize() {
            long downloadSize = 0L;
            Iterable $this$forEach$iv = this.segments;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Segment it = (Segment)element$iv;
                boolean bl = false;
                downloadSize += it.completeSize();
            }
            return downloadSize;
        }

        /*
         * WARNING - void declaration
         */
        private final void sliceSegments(long totalSize, long totalSegments, long rangeSize) {
            long start2 = 0L;
            long l = 0L;
            long l2 = totalSegments;
            while (l < l2) {
                void i;
                long end = i == totalSegments - 1L ? totalSize - 1L : start2 + rangeSize - 1L;
                this.segments.add(new Segment((long)i, start2, start2, end));
                start2 += rangeSize;
                ++i;
            }
        }

        public FileContent() {
            List list;
            FileContent fileContent = this;
            boolean bl = false;
            fileContent.segments = list = (List)new ArrayList();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0012\u001a\u00020\u0003J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0003J\u0006\u0010\u0019\u001a\u00020\u0003J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lzlc/season/rxdownload4/downloader/RangeTmpFile$Segment;", "", "index", "", "start", "current", "end", "(JJJJ)V", "getCurrent", "()J", "setCurrent", "(J)V", "getEnd", "setEnd", "getIndex", "setIndex", "getStart", "setStart", "completeSize", "isComplete", "", "read", "source", "Lokio/BufferedSource;", "remainSize", "startByte", "write", "sink", "Lokio/BufferedSink;", "Companion", "rxdownload4_release"})
    public static final class Segment {
        private long index;
        private long start;
        private long current;
        private long end;
        public static final long SEGMENT_SIZE = 32L;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final Segment write(@NotNull BufferedSink sink) {
            Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
            BufferedSink bufferedSink = sink;
            boolean bl = false;
            boolean bl2 = false;
            BufferedSink $this$apply = bufferedSink;
            boolean bl3 = false;
            $this$apply.writeLong(this.index);
            $this$apply.writeLong(this.start);
            $this$apply.writeLong(this.current);
            $this$apply.writeLong(this.end);
            return this;
        }

        @NotNull
        public final Segment read(@NotNull BufferedSource source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Buffer buffer = new Buffer();
            source.readFully(buffer, 32L);
            Buffer buffer2 = buffer;
            boolean bl = false;
            boolean bl2 = false;
            Buffer $this$apply = buffer2;
            boolean bl3 = false;
            this.index = $this$apply.readLong();
            this.start = $this$apply.readLong();
            this.current = $this$apply.readLong();
            this.end = $this$apply.readLong();
            return this;
        }

        public final boolean isComplete() {
            return this.current - this.end == 1L;
        }

        public final long remainSize() {
            return this.end - this.current + 1L;
        }

        public final long completeSize() {
            return this.current - this.start;
        }

        public final long startByte() {
            return 22L + 32L * this.index;
        }

        public final long getIndex() {
            return this.index;
        }

        public final void setIndex(long l) {
            this.index = l;
        }

        public final long getStart() {
            return this.start;
        }

        public final void setStart(long l) {
            this.start = l;
        }

        public final long getCurrent() {
            return this.current;
        }

        public final void setCurrent(long l) {
            this.current = l;
        }

        public final long getEnd() {
            return this.end;
        }

        public final void setEnd(long l) {
            this.end = l;
        }

        public Segment(long index, long start2, long current, long end) {
            this.index = index;
            this.start = start2;
            this.current = current;
            this.end = end;
        }

        public /* synthetic */ Segment(long l, long l2, long l3, long l4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                l = 0L;
            }
            if ((n & 2) != 0) {
                l2 = 0L;
            }
            if ((n & 4) != 0) {
                l3 = 0L;
            }
            if ((n & 8) != 0) {
                l4 = 0L;
            }
            this(l, l2, l3, l4);
        }

        public Segment() {
            this(0L, 0L, 0L, 0L, 15, null);
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lzlc/season/rxdownload4/downloader/RangeTmpFile$Segment$Companion;", "", "()V", "SEGMENT_SIZE", "", "rxdownload4_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

