/*
 * Decompiled with CFR 0.152.
 */
package zlc.season.rxdownload4.utils;

import java.io.Closeable;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import retrofit2.Response;
import zlc.season.rxdownload4.utils.UtilKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\u001a\u0010\u0010\u0006\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0007H\u0002\u001a\u000e\u0010\b\u001a\u00020\t*\u0006\u0012\u0002\b\u00030\u0007\u001a\u000e\u0010\n\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0007\u001a\u0018\u0010\u000b\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a\u000e\u0010\r\u001a\u00020\u000e*\u0006\u0012\u0002\b\u00030\u0007\u001a\u000e\u0010\u000f\u001a\u00020\u000e*\u0006\u0012\u0002\b\u00030\u0007\u001a\u0016\u0010\u0010\u001a\u00020\t*\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\u0011\u001a\u00020\t\u001a\u000e\u0010\u0002\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0007\u00a8\u0006\u0012"}, d2={"getFileNameFromUrl", "", "url", "closeQuietly", "", "Ljava/io/Closeable;", "contentDisposition", "Lretrofit2/Response;", "contentLength", "", "fileName", "header", "key", "isChunked", "", "isSupportRange", "sliceCount", "rangeSize", "rxdownload4_release"})
public final class HttpUtilKt {
    public static final void closeQuietly(@NotNull Closeable $this$closeQuietly) {
        Intrinsics.checkParameterIsNotNull((Object)$this$closeQuietly, (String)"$this$closeQuietly");
        try {
            $this$closeQuietly.close();
        }
        catch (RuntimeException rethrown) {
            throw (Throwable)rethrown;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    public static final String url(@NotNull Response<?> $this$url) {
        Intrinsics.checkParameterIsNotNull($this$url, (String)"$this$url");
        String string = $this$url.raw().request().url().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"raw().request().url().toString()");
        return string;
    }

    public static final long contentLength(@NotNull Response<?> $this$contentLength) {
        Intrinsics.checkParameterIsNotNull($this$contentLength, (String)"$this$contentLength");
        return UtilKt.toLongOrDefault(HttpUtilKt.header($this$contentLength, "Content-Length"), -1L);
    }

    public static final boolean isChunked(@NotNull Response<?> $this$isChunked) {
        Intrinsics.checkParameterIsNotNull($this$isChunked, (String)"$this$isChunked");
        return Intrinsics.areEqual((Object)HttpUtilKt.header($this$isChunked, "Transfer-Encoding"), (Object)"chunked");
    }

    public static final boolean isSupportRange(@NotNull Response<?> $this$isSupportRange) {
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull($this$isSupportRange, (String)"$this$isSupportRange");
                if ($this$isSupportRange.code() == 206) break block2;
                CharSequence charSequence = HttpUtilKt.header($this$isSupportRange, "Content-Range");
                boolean bl = false;
                if (!(charSequence.length() > 0) && !Intrinsics.areEqual((Object)HttpUtilKt.header($this$isSupportRange, "Accept-Ranges"), (Object)"bytes")) break block3;
            }
            return true;
        }
        return false;
    }

    @NotNull
    public static final String fileName(@NotNull Response<?> $this$fileName) {
        Intrinsics.checkParameterIsNotNull($this$fileName, (String)"$this$fileName");
        String url = HttpUtilKt.url($this$fileName);
        String fileName = HttpUtilKt.contentDisposition($this$fileName);
        CharSequence charSequence = fileName;
        boolean bl = false;
        if (charSequence.length() == 0) {
            fileName = HttpUtilKt.getFileNameFromUrl(url);
        }
        return fileName;
    }

    public static final long sliceCount(@NotNull Response<?> $this$sliceCount, long rangeSize) {
        Intrinsics.checkParameterIsNotNull($this$sliceCount, (String)"$this$sliceCount");
        long totalSize = HttpUtilKt.contentLength($this$sliceCount);
        long remainder = totalSize % rangeSize;
        long result = totalSize / rangeSize;
        return remainder == 0L ? result : result + 1L;
    }

    private static final String contentDisposition(@NotNull Response<?> $this$contentDisposition) {
        int n;
        int n2;
        String result;
        CharSequence charSequence = HttpUtilKt.header($this$contentDisposition, "Content-Disposition");
        Locale locale = Locale.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
        Locale locale2 = locale;
        boolean bl = false;
        String string = charSequence;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.toLowerCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase(locale)");
        String contentDisposition = string2;
        charSequence = contentDisposition;
        boolean bl2 = false;
        if (charSequence.length() == 0) {
            return "";
        }
        Matcher matcher = Pattern.compile(".*filename=(.*)").matcher(contentDisposition);
        if (!matcher.find()) {
            return "";
        }
        String string3 = result = matcher.group(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"result");
        if (StringsKt.startsWith$default((String)string3, (String)"\"", (boolean)false, (int)2, null)) {
            String string4 = result;
            n2 = 1;
            n = 0;
            String string5 = string4.substring(n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            result = string5;
        }
        String string6 = result;
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"result");
        if (StringsKt.endsWith$default((String)string6, (String)"\"", (boolean)false, (int)2, null)) {
            String string7 = result;
            n2 = 0;
            n = result.length() - 1;
            boolean bl3 = false;
            String string8 = string7.substring(n2, n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            result = string8;
        }
        String string9 = result;
        Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"result");
        result = StringsKt.replace((String)string9, (String)"/", (String)"_", (boolean)false);
        return result;
    }

    @NotNull
    public static final String getFileNameFromUrl(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        String temp = url;
        CharSequence charSequence = temp;
        boolean bl = false;
        if (charSequence.length() > 0) {
            String string;
            int n;
            int filenamePos;
            int query;
            int n2;
            int fragment = StringsKt.lastIndexOf$default((CharSequence)temp, (char)'#', (int)0, (boolean)false, (int)6, null);
            if (fragment > 0) {
                String string2 = temp;
                int n3 = 0;
                n2 = 0;
                String string3 = string2.substring(n3, fragment);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                temp = string3;
            }
            if ((query = StringsKt.lastIndexOf$default((CharSequence)temp, (char)'?', (int)0, (boolean)false, (int)6, null)) > 0) {
                String string4 = temp;
                n2 = 0;
                boolean bl2 = false;
                String string5 = string4;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(n2, query);
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                temp = string6;
            }
            if (0 <= (filenamePos = StringsKt.lastIndexOf$default((CharSequence)temp, (char)'/', (int)0, (boolean)false, (int)6, null))) {
                String string7 = temp;
                n = filenamePos + 1;
                boolean bl3 = false;
                String string8 = string7;
                if (string8 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string9 = string8.substring(n);
                string = string9;
                Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string = temp;
            }
            String filename = string;
            CharSequence charSequence2 = filename;
            n = 0;
            if (charSequence2.length() > 0 && Pattern.matches("[a-zA-Z_0-9.\\-()%]+", filename)) {
                return filename;
            }
        }
        return "";
    }

    private static final String header(@NotNull Response<?> $this$header, String key) {
        String header = $this$header.headers().get(key);
        String string = header;
        if (string == null) {
            string = "";
        }
        return string;
    }
}

