/*
 * Decompiled with CFR 0.152.
 */
package zlc.season.rxdownload4.downloader;

import io.reactivex.Emitter;
import io.reactivex.Flowable;
import io.reactivex.functions.BiConsumer;
import io.reactivex.functions.Consumer;
import java.io.File;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import retrofit2.Response;
import zlc.season.rxdownload4.Progress;
import zlc.season.rxdownload4.downloader.Downloader;
import zlc.season.rxdownload4.downloader.NormalDownloader;
import zlc.season.rxdownload4.task.TaskInfo;
import zlc.season.rxdownload4.utils.FileUtilsKt;
import zlc.season.rxdownload4.utils.HttpUtilKt;
import zlc.season.rxdownload4.validator.Validator;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J$\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lzlc/season/rxdownload4/downloader/NormalDownloader;", "Lzlc/season/rxdownload4/downloader/Downloader;", "()V", "alreadyDownloaded", "", "file", "Ljava/io/File;", "shadowFile", "beforeDownload", "", "taskInfo", "Lzlc/season/rxdownload4/task/TaskInfo;", "response", "Lretrofit2/Response;", "Lokhttp3/ResponseBody;", "download", "Lio/reactivex/Flowable;", "Lzlc/season/rxdownload4/Progress;", "startDownload", "body", "progress", "InternalState", "rxdownload4_release"})
public final class NormalDownloader
implements Downloader {
    private boolean alreadyDownloaded;
    private File file;
    private File shadowFile;

    @Override
    @NotNull
    public Flowable<Progress> download(@NotNull TaskInfo taskInfo, @NotNull Response<ResponseBody> response) {
        Flowable<Progress> flowable;
        Intrinsics.checkParameterIsNotNull((Object)taskInfo, (String)"taskInfo");
        Intrinsics.checkParameterIsNotNull(response, (String)"response");
        ResponseBody responseBody = (ResponseBody)response.body();
        if (responseBody == null) {
            throw (Throwable)new RuntimeException("Response body is NULL");
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)responseBody, (String)"response.body() ?: throw\u2026(\"Response body is NULL\")");
        ResponseBody body = responseBody;
        File file = this.file = FileUtilsKt.getFile(taskInfo.getTask());
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"file");
        }
        this.shadowFile = FileUtilsKt.shadow(file);
        this.beforeDownload(taskInfo, response);
        if (this.alreadyDownloaded) {
            Flowable<Progress> flowable2 = Flowable.just((Object)new Progress(HttpUtilKt.contentLength(response), HttpUtilKt.contentLength(response), false, 4, null));
            flowable = flowable2;
            Intrinsics.checkExpressionValueIsNotNull(flowable2, (String)"Flowable.just(Progress(\n\u2026ntLength()\n            ))");
        } else {
            flowable = this.startDownload(body, new Progress(0L, HttpUtilKt.contentLength(response), HttpUtilKt.isChunked(response), 1, null));
        }
        return flowable;
    }

    private final void beforeDownload(TaskInfo taskInfo, Response<ResponseBody> response) {
        File fileDir = FileUtilsKt.getDir(taskInfo.getTask());
        if (!fileDir.exists() || !fileDir.isDirectory()) {
            fileDir.mkdirs();
        }
        File file = this.file;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"file");
        }
        if (file.exists()) {
            Validator validator = taskInfo.getValidator();
            File file2 = this.file;
            if (file2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"file");
            }
            if (validator.validate(file2, response)) {
                this.alreadyDownloaded = true;
            } else {
                File file3 = this.file;
                if (file3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"file");
                }
                file3.delete();
                File file4 = this.shadowFile;
                if (file4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"shadowFile");
                }
                FileUtilsKt.recreate$default(file4, null, 1, null);
            }
        } else {
            File file5 = this.shadowFile;
            if (file5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"shadowFile");
            }
            FileUtilsKt.recreate$default(file5, null, 1, null);
        }
    }

    private final Flowable<Progress> startDownload(ResponseBody body, Progress progress) {
        Flowable flowable = Flowable.generate((Callable)new Callable<InternalState>(this, body){
            final /* synthetic */ NormalDownloader this$0;
            final /* synthetic */ ResponseBody $body;

            @NotNull
            public final InternalState call() {
                BufferedSource bufferedSource = this.$body.source();
                Intrinsics.checkExpressionValueIsNotNull((Object)bufferedSource, (String)"body.source()");
                return new InternalState(bufferedSource, Okio.buffer((Sink)Okio.sink$default((File)NormalDownloader.access$getShadowFile$p(this.this$0), (boolean)false, (int)1, null)), null, 4, null);
            }
            {
                this.this$0 = normalDownloader;
                this.$body = responseBody;
            }
        }, (BiConsumer)((BiConsumer)new BiConsumer<InternalState, Emitter<Progress>>(this, progress){
            final /* synthetic */ NormalDownloader this$0;
            final /* synthetic */ Progress $progress;

            public final void accept(InternalState internalState, Emitter<Progress> emitter) {
                InternalState internalState2 = internalState;
                boolean bl = false;
                boolean bl2 = false;
                InternalState $this$apply = internalState2;
                boolean bl3 = false;
                long readLen = $this$apply.getSource().read($this$apply.getBuffer(), 8192L);
                if (readLen == -1L) {
                    $this$apply.getSink().flush();
                    NormalDownloader.access$getShadowFile$p(this.this$0).renameTo(NormalDownloader.access$getFile$p(this.this$0));
                    emitter.onComplete();
                } else {
                    $this$apply.getSink().emit();
                    Progress progress = this.$progress;
                    Emitter<Progress> emitter2 = emitter;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Progress $this$apply2 = progress;
                    boolean bl6 = false;
                    Progress progress2 = $this$apply2;
                    progress2.setDownloadSize(progress2.getDownloadSize() + readLen);
                    Progress progress3 = progress;
                    emitter2.onNext((Object)progress3);
                }
            }
            {
                this.this$0 = normalDownloader;
                this.$progress = progress;
            }
        }), (Consumer)startDownload.3.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"generate(\n              \u2026     }\n                })");
        return flowable;
    }

    public static final /* synthetic */ File access$getShadowFile$p(NormalDownloader $this) {
        File file = $this.shadowFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shadowFile");
        }
        return file;
    }

    public static final /* synthetic */ void access$setShadowFile$p(NormalDownloader $this, File file) {
        $this.shadowFile = file;
    }

    public static final /* synthetic */ File access$getFile$p(NormalDownloader $this) {
        File file = $this.file;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"file");
        }
        return file;
    }

    public static final /* synthetic */ void access$setFile$p(NormalDownloader $this, File file) {
        $this.file = file;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lzlc/season/rxdownload4/downloader/NormalDownloader$InternalState;", "", "source", "Lokio/BufferedSource;", "sink", "Lokio/BufferedSink;", "buffer", "Lokio/Buffer;", "(Lokio/BufferedSource;Lokio/BufferedSink;Lokio/Buffer;)V", "getBuffer", "()Lokio/Buffer;", "getSink", "()Lokio/BufferedSink;", "getSource", "()Lokio/BufferedSource;", "rxdownload4_release"})
    public static final class InternalState {
        @NotNull
        private final BufferedSource source;
        @NotNull
        private final BufferedSink sink;
        @NotNull
        private final Buffer buffer;

        @NotNull
        public final BufferedSource getSource() {
            return this.source;
        }

        @NotNull
        public final BufferedSink getSink() {
            return this.sink;
        }

        @NotNull
        public final Buffer getBuffer() {
            return this.buffer;
        }

        public InternalState(@NotNull BufferedSource source, @NotNull BufferedSink sink, @NotNull Buffer buffer) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            this.source = source;
            this.sink = sink;
            this.buffer = buffer;
        }

        public /* synthetic */ InternalState(BufferedSource bufferedSource, BufferedSink bufferedSink, Buffer buffer, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                buffer = bufferedSink.getBuffer();
            }
            this(bufferedSource, bufferedSink, buffer);
        }
    }
}

