/*
 * Decompiled with CFR 0.152.
 */
package zlc.season.rxdownload4.downloader;

import io.reactivex.Flowable;
import io.reactivex.functions.Action;
import io.reactivex.functions.BiConsumer;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import retrofit2.Response;
import zlc.season.rxdownload4.Progress;
import zlc.season.rxdownload4.downloader.Downloader;
import zlc.season.rxdownload4.downloader.RangeDownloader;
import zlc.season.rxdownload4.downloader.RangeTmpFile;
import zlc.season.rxdownload4.request.Request;
import zlc.season.rxdownload4.task.TaskInfo;
import zlc.season.rxdownload4.utils.FileUtilsKt;
import zlc.season.rxdownload4.utils.HttpUtilKt;
import zlc.season.rxdownload4.validator.Validator;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u001e\u0010\u0012\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lzlc/season/rxdownload4/downloader/RangeDownloader;", "Lzlc/season/rxdownload4/downloader/Downloader;", "()V", "alreadyDownloaded", "", "file", "Ljava/io/File;", "rangeTmpFile", "Lzlc/season/rxdownload4/downloader/RangeTmpFile;", "shadowFile", "tmpFile", "beforeDownload", "", "taskInfo", "Lzlc/season/rxdownload4/task/TaskInfo;", "response", "Lretrofit2/Response;", "Lokhttp3/ResponseBody;", "createFiles", "download", "Lio/reactivex/Flowable;", "Lzlc/season/rxdownload4/Progress;", "startDownload", "InnerDownloader", "InternalState", "rxdownload4_release"})
public final class RangeDownloader
implements Downloader {
    private boolean alreadyDownloaded;
    private File file;
    private File shadowFile;
    private File tmpFile;
    private RangeTmpFile rangeTmpFile;

    @Override
    @NotNull
    public Flowable<Progress> download(@NotNull TaskInfo taskInfo, @NotNull Response<ResponseBody> response) {
        Flowable flowable;
        Intrinsics.checkParameterIsNotNull((Object)taskInfo, (String)"taskInfo");
        Intrinsics.checkParameterIsNotNull(response, (String)"response");
        File file = this.file = FileUtilsKt.getFile(taskInfo.getTask());
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"file");
        }
        this.shadowFile = FileUtilsKt.shadow(file);
        File file2 = this.file;
        if (file2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"file");
        }
        this.tmpFile = FileUtilsKt.tmp(file2);
        this.beforeDownload(taskInfo, response);
        if (this.alreadyDownloaded) {
            Flowable flowable2 = Flowable.just((Object)new Progress(HttpUtilKt.contentLength(response), HttpUtilKt.contentLength(response), false, 4, null));
            flowable = flowable2;
            Intrinsics.checkExpressionValueIsNotNull((Object)flowable2, (String)"Flowable.just(Progress(\n\u2026ntLength()\n            ))");
        } else {
            flowable = this.startDownload(taskInfo, response);
        }
        return flowable;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void beforeDownload(TaskInfo taskInfo, Response<ResponseBody> response) {
        File file = this.file;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"file");
        }
        if (file.exists()) {
            Validator validator = taskInfo.getValidator();
            File file2 = this.file;
            if (file2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"file");
            }
            if (validator.validate(file2, response)) {
                this.alreadyDownloaded = true;
                return;
            }
            File file3 = this.file;
            if (file3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"file");
            }
            file3.delete();
            this.createFiles(response, taskInfo);
            return;
        }
        File file4 = this.shadowFile;
        if (file4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shadowFile");
        }
        if (file4.exists()) {
            File file5 = this.tmpFile;
            if (file5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tmpFile");
            }
            if (file5.exists()) {
                File file6 = this.tmpFile;
                if (file6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"tmpFile");
                }
                RangeTmpFile rangeTmpFile = this.rangeTmpFile = new RangeTmpFile(file6);
                if (rangeTmpFile == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"rangeTmpFile");
                }
                if (rangeTmpFile.read(response, taskInfo)) return;
                this.createFiles(response, taskInfo);
                return;
            }
        }
        this.createFiles(response, taskInfo);
    }

    private final void createFiles(Response<ResponseBody> response, TaskInfo taskInfo) {
        File file = this.tmpFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tmpFile");
        }
        FileUtilsKt.recreate(file, (Function0<Unit>)((Function0)new Function0<Unit>(this, response, taskInfo){
            final /* synthetic */ RangeDownloader this$0;
            final /* synthetic */ Response $response;
            final /* synthetic */ TaskInfo $taskInfo;

            public final void invoke() {
                FileUtilsKt.recreate(RangeDownloader.access$getShadowFile$p(this.this$0), (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ createFiles.1 this$0;

                    public final void invoke() {
                        RangeDownloader.access$setRangeTmpFile$p(this.this$0.this$0, new RangeTmpFile(RangeDownloader.access$getTmpFile$p(this.this$0.this$0)));
                        RangeDownloader.access$getRangeTmpFile$p(this.this$0.this$0).write(this.this$0.$response, this.this$0.$taskInfo);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
            }
            {
                this.this$0 = rangeDownloader;
                this.$response = response;
                this.$taskInfo = taskInfo;
                super(0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final Flowable<Progress> startDownload(TaskInfo taskInfo, Response<ResponseBody> response) {
        void downloadSize;
        String url = HttpUtilKt.url(response);
        RangeTmpFile rangeTmpFile = this.rangeTmpFile;
        if (rangeTmpFile == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rangeTmpFile");
        }
        Pair<Long, Long> pair = rangeTmpFile.lastProgress();
        long l = ((Number)pair.component1()).longValue();
        long totalSize = ((Number)pair.component2()).longValue();
        Progress progress = new Progress((long)downloadSize, totalSize, false, 4, null);
        boolean bl = false;
        List sources = new ArrayList();
        RangeTmpFile rangeTmpFile2 = this.rangeTmpFile;
        if (rangeTmpFile2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rangeTmpFile");
        }
        Iterable $this$mapTo$iv = rangeTmpFile2.undoneSegments();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            RangeTmpFile.Segment segment = (RangeTmpFile.Segment)item$iv;
            Collection collection = sources;
            boolean bl2 = false;
            File file = this.shadowFile;
            if (file == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"shadowFile");
            }
            File file2 = this.tmpFile;
            if (file2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"tmpFile");
            }
            Flowable<Long> flowable = new InnerDownloader(url, (RangeTmpFile.Segment)it, file, file2, taskInfo.getRequest()).download();
            collection.add(flowable);
        }
        Flowable flowable = Flowable.mergeDelayError((Iterable)sources, (int)taskInfo.getMaxConCurrency()).map(new Function<T, R>(progress){
            final /* synthetic */ Progress $progress;

            @NotNull
            public final Progress apply(@NotNull Long it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Progress progress = this.$progress;
                boolean bl = false;
                boolean bl2 = false;
                Progress $this$apply = progress;
                boolean bl3 = false;
                Progress progress2 = $this$apply;
                progress2.setDownloadSize(progress2.getDownloadSize() + it);
                return progress;
            }
            {
                this.$progress = progress;
            }
        }).doOnComplete(new Action(this, response){
            final /* synthetic */ RangeDownloader this$0;
            final /* synthetic */ Response $response;

            public final void run() {
                block0: {
                    RangeDownloader.access$getShadowFile$p(this.this$0).renameTo(RangeDownloader.access$getFile$p(this.this$0));
                    RangeDownloader.access$getTmpFile$p(this.this$0).delete();
                    ResponseBody responseBody = (ResponseBody)this.$response.body();
                    if (responseBody == null) break block0;
                    Util.closeQuietly((Closeable)((Closeable)responseBody));
                }
            }
            {
                this.this$0 = rangeDownloader;
                this.$response = response;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"Flowable.mergeDelayError\u2026ietly()\n                }");
        return flowable;
    }

    public static final /* synthetic */ File access$getShadowFile$p(RangeDownloader $this) {
        File file = $this.shadowFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shadowFile");
        }
        return file;
    }

    public static final /* synthetic */ void access$setShadowFile$p(RangeDownloader $this, File file) {
        $this.shadowFile = file;
    }

    public static final /* synthetic */ RangeTmpFile access$getRangeTmpFile$p(RangeDownloader $this) {
        RangeTmpFile rangeTmpFile = $this.rangeTmpFile;
        if (rangeTmpFile == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rangeTmpFile");
        }
        return rangeTmpFile;
    }

    public static final /* synthetic */ void access$setRangeTmpFile$p(RangeDownloader $this, RangeTmpFile rangeTmpFile) {
        $this.rangeTmpFile = rangeTmpFile;
    }

    public static final /* synthetic */ File access$getTmpFile$p(RangeDownloader $this) {
        File file = $this.tmpFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tmpFile");
        }
        return file;
    }

    public static final /* synthetic */ void access$setTmpFile$p(RangeDownloader $this, File file) {
        $this.tmpFile = file;
    }

    public static final /* synthetic */ File access$getFile$p(RangeDownloader $this) {
        File file = $this.file;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"file");
        }
        return file;
    }

    public static final /* synthetic */ void access$setFile$p(RangeDownloader $this, File file) {
        $this.file = file;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u000e\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lzlc/season/rxdownload4/downloader/RangeDownloader$InternalState;", "", "source", "Ljava/io/InputStream;", "shadowChannel", "Ljava/nio/channels/FileChannel;", "tmpFileBuffer", "Ljava/nio/MappedByteBuffer;", "buffer", "", "current", "", "(Ljava/io/InputStream;Ljava/nio/channels/FileChannel;Ljava/nio/MappedByteBuffer;[BJ)V", "getBuffer", "()[B", "getCurrent", "()J", "setCurrent", "(J)V", "getShadowChannel", "()Ljava/nio/channels/FileChannel;", "getSource", "()Ljava/io/InputStream;", "getTmpFileBuffer", "()Ljava/nio/MappedByteBuffer;", "rxdownload4_release"})
    public static final class InternalState {
        @NotNull
        private final InputStream source;
        @NotNull
        private final FileChannel shadowChannel;
        @NotNull
        private final MappedByteBuffer tmpFileBuffer;
        @NotNull
        private final byte[] buffer;
        private long current;

        @NotNull
        public final InputStream getSource() {
            return this.source;
        }

        @NotNull
        public final FileChannel getShadowChannel() {
            return this.shadowChannel;
        }

        @NotNull
        public final MappedByteBuffer getTmpFileBuffer() {
            return this.tmpFileBuffer;
        }

        @NotNull
        public final byte[] getBuffer() {
            return this.buffer;
        }

        public final long getCurrent() {
            return this.current;
        }

        public final void setCurrent(long l) {
            this.current = l;
        }

        public InternalState(@NotNull InputStream source, @NotNull FileChannel shadowChannel, @NotNull MappedByteBuffer tmpFileBuffer, @NotNull byte[] buffer, long current) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Intrinsics.checkParameterIsNotNull((Object)shadowChannel, (String)"shadowChannel");
            Intrinsics.checkParameterIsNotNull((Object)tmpFileBuffer, (String)"tmpFileBuffer");
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            this.source = source;
            this.shadowChannel = shadowChannel;
            this.tmpFileBuffer = tmpFileBuffer;
            this.buffer = buffer;
            this.current = current;
        }

        public /* synthetic */ InternalState(InputStream inputStream, FileChannel fileChannel, MappedByteBuffer mappedByteBuffer, byte[] byArray, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                byArray = new byte[8192];
            }
            if ((n & 0x10) != 0) {
                l = 0L;
            }
            this(inputStream, fileChannel, mappedByteBuffer, byArray, l);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u0015H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lzlc/season/rxdownload4/downloader/RangeDownloader$InnerDownloader;", "", "url", "", "segment", "Lzlc/season/rxdownload4/downloader/RangeTmpFile$Segment;", "shadowFile", "Ljava/io/File;", "tmpFile", "request", "Lzlc/season/rxdownload4/request/Request;", "(Ljava/lang/String;Lzlc/season/rxdownload4/downloader/RangeTmpFile$Segment;Ljava/io/File;Ljava/io/File;Lzlc/season/rxdownload4/request/Request;)V", "download", "Lio/reactivex/Flowable;", "", "initialState", "Lzlc/season/rxdownload4/downloader/RangeDownloader$InternalState;", "body", "Lokhttp3/ResponseBody;", "rangeSave", "response", "Lretrofit2/Response;", "rxdownload4_release"})
    public static final class InnerDownloader {
        private final String url;
        private final RangeTmpFile.Segment segment;
        private final File shadowFile;
        private final File tmpFile;
        private final Request request;

        @NotNull
        public final Flowable<Long> download() {
            Flowable flowable = Flowable.just((Object)this.segment).subscribeOn(Schedulers.io()).map((Function)download.1.INSTANCE).flatMap(new Function<T, Publisher<? extends R>>(this){
                final /* synthetic */ InnerDownloader this$0;

                @NotNull
                public final Flowable<Response<ResponseBody>> apply(@NotNull Map<String, String> it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    return InnerDownloader.access$getRequest$p(this.this$0).get(InnerDownloader.access$getUrl$p(this.this$0), it);
                }
                {
                    this.this$0 = innerDownloader;
                }
            }).flatMap(new Function<T, Publisher<? extends R>>(this){
                final /* synthetic */ InnerDownloader this$0;

                @NotNull
                public final Flowable<Long> apply(@NotNull Response<ResponseBody> it) {
                    Intrinsics.checkParameterIsNotNull(it, (String)"it");
                    return InnerDownloader.access$rangeSave(this.this$0, InnerDownloader.access$getSegment$p(this.this$0), it);
                }
                {
                    this.this$0 = innerDownloader;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"Flowable.just(segment)\n \u2026 rangeSave(segment, it) }");
            return flowable;
        }

        private final Flowable<Long> rangeSave(RangeTmpFile.Segment segment, Response<ResponseBody> response) {
            ResponseBody responseBody = (ResponseBody)response.body();
            if (responseBody == null) {
                throw (Throwable)new RuntimeException("Response body is NULL");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)responseBody, (String)"response.body() ?: throw\u2026(\"Response body is NULL\")");
            ResponseBody body = responseBody;
            Flowable flowable = Flowable.generate((Callable)new Callable<InternalState>(this, body, segment){
                final /* synthetic */ InnerDownloader this$0;
                final /* synthetic */ ResponseBody $body;
                final /* synthetic */ RangeTmpFile.Segment $segment;

                @NotNull
                public final InternalState call() {
                    return InnerDownloader.access$initialState(this.this$0, this.$body, this.$segment);
                }
                {
                    this.this$0 = innerDownloader;
                    this.$body = responseBody;
                    this.$segment = segment;
                }
            }, (BiConsumer)rangeSave.2.INSTANCE, (Consumer)rangeSave.3.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"Flowable.generate(\n     \u2026()\n                    })");
            return flowable;
        }

        private final InternalState initialState(ResponseBody body, RangeTmpFile.Segment segment) {
            InputStream source = body.byteStream();
            FileChannel shadowFileChannel = FileUtilsKt.channel(this.shadowFile);
            FileChannel tmpFileChannel = FileUtilsKt.channel(this.tmpFile);
            MappedByteBuffer tmpFileBuffer = tmpFileChannel.map(FileChannel.MapMode.READ_WRITE, segment.startByte(), 32L);
            Util.closeQuietly((Closeable)tmpFileChannel);
            MappedByteBuffer mappedByteBuffer = tmpFileBuffer;
            Intrinsics.checkExpressionValueIsNotNull((Object)mappedByteBuffer, (String)"tmpFileBuffer");
            return new InternalState(source, shadowFileChannel, mappedByteBuffer, null, segment.getCurrent(), 8, null);
        }

        public InnerDownloader(@NotNull String url, @NotNull RangeTmpFile.Segment segment, @NotNull File shadowFile, @NotNull File tmpFile, @NotNull Request request) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull((Object)segment, (String)"segment");
            Intrinsics.checkParameterIsNotNull((Object)shadowFile, (String)"shadowFile");
            Intrinsics.checkParameterIsNotNull((Object)tmpFile, (String)"tmpFile");
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            this.url = url;
            this.segment = segment;
            this.shadowFile = shadowFile;
            this.tmpFile = tmpFile;
            this.request = request;
        }

        public static final /* synthetic */ Request access$getRequest$p(InnerDownloader $this) {
            return $this.request;
        }

        public static final /* synthetic */ String access$getUrl$p(InnerDownloader $this) {
            return $this.url;
        }

        public static final /* synthetic */ Flowable access$rangeSave(InnerDownloader $this, RangeTmpFile.Segment segment, Response response) {
            return $this.rangeSave(segment, (Response<ResponseBody>)response);
        }

        public static final /* synthetic */ RangeTmpFile.Segment access$getSegment$p(InnerDownloader $this) {
            return $this.segment;
        }

        public static final /* synthetic */ InternalState access$initialState(InnerDownloader $this, ResponseBody body, RangeTmpFile.Segment segment) {
            return $this.initialState(body, segment);
        }
    }
}

