/*
 * Decompiled with CFR 0.152.
 */
package com.github.squti.androidwaverecorder;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import com.github.squti.androidwaverecorder.WaveConfig;
import com.github.squti.androidwaverecorder.WaveConfigKt;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0017\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ@\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/github/squti/androidwaverecorder/WaveHeaderWriter;", "", "fileUri", "Landroid/net/Uri;", "context", "Landroid/content/Context;", "waveConfig", "Lcom/github/squti/androidwaverecorder/WaveConfig;", "(Landroid/net/Uri;Landroid/content/Context;Lcom/github/squti/androidwaverecorder/WaveConfig;)V", "filePath", "", "(Ljava/lang/String;Lcom/github/squti/androidwaverecorder/WaveConfig;)V", "getWavFileHeaderByteArray", "", "totalAudioLen", "", "totalDataLen", "longSampleRate", "channels", "", "byteRate", "bitsPerSample", "isFloat", "", "writeHeader", "", "android-wave-recorder_release"})
public final class WaveHeaderWriter {
    @Nullable
    private Uri fileUri;
    @Nullable
    private String filePath;
    private Context context;
    @NotNull
    private WaveConfig waveConfig;

    public WaveHeaderWriter(@NotNull Uri fileUri, @NotNull Context context, @NotNull WaveConfig waveConfig) {
        Intrinsics.checkNotNullParameter((Object)fileUri, (String)"fileUri");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)waveConfig, (String)"waveConfig");
        this.fileUri = fileUri;
        this.context = context;
        this.waveConfig = waveConfig;
    }

    public WaveHeaderWriter(@NotNull String filePath, @NotNull WaveConfig waveConfig) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)waveConfig, (String)"waveConfig");
        this.filePath = filePath;
        this.waveConfig = waveConfig;
    }

    public final void writeHeader() {
        FileInputStream fileInputStream;
        if (this.fileUri != null) {
            Context context = this.context;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                context = null;
            }
            ContentResolver contentResolver = context.getContentResolver();
            Uri uri = this.fileUri;
            Intrinsics.checkNotNull((Object)uri);
            ParcelFileDescriptor parcelFileDescriptor = contentResolver.openFileDescriptor(uri, "rw");
            FileDescriptor fileDescriptor = parcelFileDescriptor != null ? parcelFileDescriptor.getFileDescriptor() : null;
            fileInputStream = new FileInputStream(fileDescriptor);
        } else {
            String string = this.filePath;
            Intrinsics.checkNotNull((Object)string);
            fileInputStream = new FileInputStream(new File(string));
        }
        FileInputStream inputStream = fileInputStream;
        long totalAudioLen = inputStream.getChannel().size() - (long)44;
        long totalDataLen = totalAudioLen + (long)36;
        int channels = this.waveConfig.getChannels() == 16 ? 1 : 2;
        long sampleRate = this.waveConfig.getSampleRate();
        long byteRate = WaveConfigKt.bitPerSample(this.waveConfig.getAudioEncoding()) * this.waveConfig.getSampleRate() * channels / 8;
        byte[] header = this.getWavFileHeaderByteArray(totalAudioLen, totalDataLen, sampleRate, channels, byteRate, WaveConfigKt.bitPerSample(this.waveConfig.getAudioEncoding()), this.waveConfig.getAudioEncoding() == 4);
        if (this.fileUri != null) {
            OutputStream outputStream;
            Context context = this.context;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                context = null;
            }
            ContentResolver contentResolver = context.getContentResolver();
            Uri uri = this.fileUri;
            Intrinsics.checkNotNull((Object)uri);
            OutputStream outputStream2 = outputStream = contentResolver.openOutputStream(uri, "rw");
            if (outputStream2 != null) {
                outputStream2.write(header);
            }
            OutputStream outputStream3 = outputStream;
            if (outputStream3 != null) {
                outputStream3.close();
            }
        } else {
            String string = this.filePath;
            Intrinsics.checkNotNull((Object)string);
            RandomAccessFile randomAccessFile = new RandomAccessFile(new File(string), "rw");
            randomAccessFile.seek(0L);
            randomAccessFile.write(header);
            randomAccessFile.close();
        }
    }

    private final byte[] getWavFileHeaderByteArray(long totalAudioLen, long totalDataLen, long longSampleRate, int channels, long byteRate, int bitsPerSample, boolean isFloat) {
        byte[] header = new byte[]{82, 73, 70, 70, (byte)(totalDataLen & 0xFFL), (byte)(totalDataLen >> 8 & 0xFFL), (byte)(totalDataLen >> 16 & 0xFFL), (byte)(totalDataLen >> 24 & 0xFFL), 87, 65, 86, 69, 102, 109, 116, 32, 16, 0, 0, 0, isFloat ? (byte)3 : 1, 0, (byte)channels, 0, (byte)(longSampleRate & 0xFFL), (byte)(longSampleRate >> 8 & 0xFFL), (byte)(longSampleRate >> 16 & 0xFFL), (byte)(longSampleRate >> 24 & 0xFFL), (byte)(byteRate & 0xFFL), (byte)(byteRate >> 8 & 0xFFL), (byte)(byteRate >> 16 & 0xFFL), (byte)(byteRate >> 24 & 0xFFL), (byte)(channels * bitsPerSample / 8), 0, (byte)bitsPerSample, 0, 100, 97, 116, 97, (byte)(totalAudioLen & 0xFFL), (byte)(totalAudioLen >> 8 & 0xFFL), (byte)(totalAudioLen >> 16 & 0xFFL), (byte)(totalAudioLen >> 24 & 0xFFL)};
        return header;
    }
}

