/*
 * Decompiled with CFR 0.152.
 */
package com.github.squti.androidwaverecorder;

import android.annotation.SuppressLint;
import android.media.AudioRecord;
import android.media.audiofx.NoiseSuppressor;
import com.github.squti.androidwaverecorder.RecorderState;
import com.github.squti.androidwaverecorder.WaveConfig;
import com.github.squti.androidwaverecorder.WaveHeaderWriter;
import com.github.squti.androidwaverecorder.WaveRecorder;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020.H\u0002J\u000e\u0010/\u001a\u00020\u00192\u0006\u00100\u001a\u00020\u0003J\b\u00101\u001a\u00020\u000eH\u0002J\u0006\u00102\u001a\u00020\u0019J\u0006\u00103\u001a\u00020\u0019J\b\u00104\u001a\u00020\u0019H\u0007J\u0006\u00105\u001a\u00020\u0019J\u0011\u00106\u001a\u00020\u0019H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00107R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R(\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR(\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001b\"\u0004\b!\u0010\u001dR(\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u001b\"\u0004\b%\u0010\u001dR\u001a\u0010&\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00068"}, d2={"Lcom/github/squti/androidwaverecorder/WaveRecorder;", "", "filePath", "", "(Ljava/lang/String;)V", "audioRecorder", "Landroid/media/AudioRecord;", "<set-?>", "", "audioSessionId", "getAudioSessionId", "()I", "channelModulus", "isPaused", "", "isRecording", "noiseSuppressor", "Landroid/media/audiofx/NoiseSuppressor;", "noiseSuppressorActive", "getNoiseSuppressorActive", "()Z", "setNoiseSuppressorActive", "(Z)V", "onAmplitudeListener", "Lkotlin/Function1;", "", "getOnAmplitudeListener", "()Lkotlin/jvm/functions/Function1;", "setOnAmplitudeListener", "(Lkotlin/jvm/functions/Function1;)V", "onStateChangeListener", "Lcom/github/squti/androidwaverecorder/RecorderState;", "getOnStateChangeListener", "setOnStateChangeListener", "onTimeElapsed", "", "getOnTimeElapsed", "setOnTimeElapsed", "waveConfig", "Lcom/github/squti/androidwaverecorder/WaveConfig;", "getWaveConfig", "()Lcom/github/squti/androidwaverecorder/WaveConfig;", "setWaveConfig", "(Lcom/github/squti/androidwaverecorder/WaveConfig;)V", "calculateAmplitudeMax", "data", "", "changeFilePath", "newFilePath", "isAudioRecorderInitialized", "pauseRecording", "resumeRecording", "startRecording", "stopRecording", "writeAudioDataToStorage", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "android-wave-recorder_release"})
public final class WaveRecorder {
    @NotNull
    private String filePath;
    @NotNull
    private WaveConfig waveConfig;
    @Nullable
    private Function1<? super Integer, Unit> onAmplitudeListener;
    @Nullable
    private Function1<? super RecorderState, Unit> onStateChangeListener;
    @Nullable
    private Function1<? super Long, Unit> onTimeElapsed;
    private boolean noiseSuppressorActive;
    private int audioSessionId;
    private boolean isRecording;
    private boolean isPaused;
    private AudioRecord audioRecorder;
    @Nullable
    private NoiseSuppressor noiseSuppressor;
    private int channelModulus;

    public WaveRecorder(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.filePath = filePath;
        this.waveConfig = new WaveConfig(0, 0, 0, 7, null);
        this.audioSessionId = -1;
        this.channelModulus = 2;
    }

    @NotNull
    public final WaveConfig getWaveConfig() {
        return this.waveConfig;
    }

    public final void setWaveConfig(@NotNull WaveConfig waveConfig) {
        Intrinsics.checkNotNullParameter((Object)waveConfig, (String)"<set-?>");
        this.waveConfig = waveConfig;
    }

    @Nullable
    public final Function1<Integer, Unit> getOnAmplitudeListener() {
        return this.onAmplitudeListener;
    }

    public final void setOnAmplitudeListener(@Nullable Function1<? super Integer, Unit> function1) {
        this.onAmplitudeListener = function1;
    }

    @Nullable
    public final Function1<RecorderState, Unit> getOnStateChangeListener() {
        return this.onStateChangeListener;
    }

    public final void setOnStateChangeListener(@Nullable Function1<? super RecorderState, Unit> function1) {
        this.onStateChangeListener = function1;
    }

    @Nullable
    public final Function1<Long, Unit> getOnTimeElapsed() {
        return this.onTimeElapsed;
    }

    public final void setOnTimeElapsed(@Nullable Function1<? super Long, Unit> function1) {
        this.onTimeElapsed = function1;
    }

    public final boolean getNoiseSuppressorActive() {
        return this.noiseSuppressorActive;
    }

    public final void setNoiseSuppressorActive(boolean bl) {
        this.noiseSuppressorActive = bl;
    }

    public final int getAudioSessionId() {
        return this.audioSessionId;
    }

    @SuppressLint(value={"MissingPermission"})
    public final void startRecording() {
        if (!this.isAudioRecorderInitialized()) {
            AudioRecord audioRecord;
            AudioRecord audioRecord2;
            AudioRecord audioRecord3;
            this.audioRecorder = new AudioRecord(1, this.waveConfig.getSampleRate(), this.waveConfig.getChannels(), this.waveConfig.getAudioEncoding(), AudioRecord.getMinBufferSize((int)this.waveConfig.getSampleRate(), (int)this.waveConfig.getChannels(), (int)this.waveConfig.getAudioEncoding()));
            if (this.waveConfig.getChannels() == 12) {
                this.channelModulus = 4;
            }
            if ((audioRecord3 = this.audioRecorder) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"audioRecorder");
                audioRecord2 = null;
            } else {
                audioRecord2 = audioRecord3;
            }
            this.audioSessionId = audioRecord2.getAudioSessionId();
            this.isRecording = true;
            audioRecord3 = this.audioRecorder;
            if (audioRecord3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"audioRecorder");
                audioRecord = null;
            } else {
                audioRecord = audioRecord3;
            }
            audioRecord.startRecording();
            if (this.noiseSuppressorActive) {
                AudioRecord audioRecord4;
                audioRecord3 = this.audioRecorder;
                if (audioRecord3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"audioRecorder");
                    audioRecord4 = null;
                } else {
                    audioRecord4 = audioRecord3;
                }
                this.noiseSuppressor = NoiseSuppressor.create((int)audioRecord4.getAudioSessionId());
            }
            if ((audioRecord3 = this.onStateChangeListener) != null) {
                AudioRecord audioRecord5 = audioRecord3;
                boolean bl = false;
                boolean bl2 = false;
                AudioRecord it = audioRecord5;
                boolean bl3 = false;
                it.invoke((Object)RecorderState.RECORDING);
            }
            BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ WaveRecorder this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = WaveRecorder.access$writeAudioDataToStorage(this.this$0, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Object writeAudioDataToStorage(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof writeAudioDataToStorage.1)) ** GOTO lbl-1000
        var9_2 = var1_1;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ WaveRecorder this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return WaveRecorder.access$writeAudioDataToStorage(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                bufferSize = AudioRecord.getMinBufferSize((int)this.getWaveConfig().getSampleRate(), (int)this.getWaveConfig().getChannels(), (int)this.getWaveConfig().getAudioEncoding());
                data = new byte[bufferSize];
                var6_8 = file = new File(this.filePath);
                var7_10 = false;
                outputStream = new FileOutputStream(var6_8);
lbl17:
                // 4 sources

                while (this.isRecording) {
                    var7_11 = this.audioRecorder;
                    if (var7_11 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"audioRecorder");
                        v0 = null;
                    } else {
                        v0 = var7_11;
                    }
                    if (-3 == (operationStatus = v0.read(data, 0, bufferSize))) continue;
                    if (!this.isPaused) {
                        outputStream.write(data);
                    }
                    $continuation.L$0 = this;
                    $continuation.L$1 = data;
                    $continuation.L$2 = file;
                    $continuation.L$3 = outputStream;
                    $continuation.I$0 = bufferSize;
                    $continuation.label = 1;
                    v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, data, file, null){
                        int label;
                        final /* synthetic */ WaveRecorder this$0;
                        final /* synthetic */ byte[] $data;
                        final /* synthetic */ File $file;
                        {
                            this.this$0 = $receiver;
                            this.$data = $data;
                            this.$file = $file;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    Unit unit;
                                    Function1<Integer, Unit> it;
                                    boolean bl;
                                    boolean bl2;
                                    Object object3;
                                    Object object4;
                                    Function1<Integer, Unit> function1;
                                    ResultKt.throwOnFailure((Object)object);
                                    Object object5 = this.this$0.getOnAmplitudeListener();
                                    if (object5 != null) {
                                        function1 = object5;
                                        object4 = this.this$0;
                                        object3 = this.$data;
                                        bl2 = false;
                                        bl = false;
                                        it = function1;
                                        boolean bl3 = false;
                                        it.invoke((Object)Boxing.boxInt((int)WaveRecorder.access$calculateAmplitudeMax((WaveRecorder)object4, (byte[])object3)));
                                    }
                                    object5 = this.this$0.getOnTimeElapsed();
                                    if (object5 == null) {
                                        unit = null;
                                    } else {
                                        function1 = object5;
                                        object4 = this.$file;
                                        object3 = this.this$0;
                                        bl2 = false;
                                        bl = false;
                                        it = function1;
                                        boolean bl4 = false;
                                        long audioLengthInSeconds = ((File)object4).length() / (long)(WaveRecorder.access$getChannelModulus$p((WaveRecorder)object3) * ((WaveRecorder)object3).getWaveConfig().getSampleRate());
                                        it.invoke((Object)Boxing.boxLong((long)audioLengthInSeconds));
                                        unit = Unit.INSTANCE;
                                    }
                                    return unit;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v1 != var10_4) continue;
                    return var10_4;
                }
                break;
            }
            case 1: {
                bufferSize = $continuation.I$0;
                outputStream = (FileOutputStream)$continuation.L$3;
                file = (File)$continuation.L$2;
                data = (byte[])$continuation.L$1;
                this = (WaveRecorder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
                ** GOTO lbl17
            }
        }
        outputStream.close();
        var6_8 = this.noiseSuppressor;
        if (var6_8 != null) {
            var6_8.release();
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final int calculateAmplitudeMax(byte[] data) {
        int n;
        short[] shortData = new short[data.length / 2];
        ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(shortData);
        Short s = ArraysKt.maxOrNull((short[])shortData);
        if (s == null) {
            n = 0;
        } else {
            short s2 = s;
            n = s2;
        }
        return n;
    }

    public final void changeFilePath(@NotNull String newFilePath) {
        Intrinsics.checkNotNullParameter((Object)newFilePath, (String)"newFilePath");
        if (this.isRecording) {
            throw new IllegalStateException("Cannot change filePath when still recording.");
        }
        this.filePath = newFilePath;
    }

    public final void stopRecording() {
        if (this.isAudioRecorderInitialized()) {
            Function1<? super RecorderState, Unit> function1;
            Function1<? super RecorderState, Unit> function12;
            this.isRecording = false;
            this.isPaused = false;
            Function1<? super RecorderState, Unit> function13 = this.audioRecorder;
            if (function13 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"audioRecorder");
                function12 = null;
            } else {
                function12 = function13;
            }
            function12.stop();
            function13 = this.audioRecorder;
            if (function13 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"audioRecorder");
                function1 = null;
            } else {
                function1 = function13;
            }
            function1.release();
            this.audioSessionId = -1;
            new WaveHeaderWriter(this.filePath, this.waveConfig).writeHeader();
            function13 = this.onStateChangeListener;
            if (function13 != null) {
                Function1<? super RecorderState, Unit> function14 = function13;
                boolean bl = false;
                boolean bl2 = false;
                Function1<? super RecorderState, Unit> it = function14;
                boolean bl3 = false;
                it.invoke((Object)RecorderState.STOP);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAudioRecorderInitialized() {
        AudioRecord audioRecord;
        if (this.audioRecorder == null) return false;
        AudioRecord audioRecord2 = this.audioRecorder;
        if (audioRecord2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"audioRecorder");
            audioRecord = null;
        } else {
            audioRecord = audioRecord2;
        }
        if (audioRecord.getState() != 1) return false;
        return true;
    }

    public final void pauseRecording() {
        this.isPaused = true;
        Function1<? super RecorderState, Unit> function1 = this.onStateChangeListener;
        if (function1 != null) {
            Function1<? super RecorderState, Unit> function12 = function1;
            boolean bl = false;
            boolean bl2 = false;
            Function1<? super RecorderState, Unit> it = function12;
            boolean bl3 = false;
            it.invoke((Object)RecorderState.PAUSE);
        }
    }

    public final void resumeRecording() {
        this.isPaused = false;
        Function1<? super RecorderState, Unit> function1 = this.onStateChangeListener;
        if (function1 != null) {
            Function1<? super RecorderState, Unit> function12 = function1;
            boolean bl = false;
            boolean bl2 = false;
            Function1<? super RecorderState, Unit> it = function12;
            boolean bl3 = false;
            it.invoke((Object)RecorderState.RECORDING);
        }
    }

    public static final /* synthetic */ Object access$writeAudioDataToStorage(WaveRecorder $this, Continuation $completion) {
        return $this.writeAudioDataToStorage((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ int access$calculateAmplitudeMax(WaveRecorder $this, byte[] data) {
        return $this.calculateAmplitudeMax(data);
    }

    public static final /* synthetic */ int access$getChannelModulus$p(WaveRecorder $this) {
        return $this.channelModulus;
    }
}

