/*
 * Decompiled with CFR 0.152.
 */
package com.github.squti.androidwaverecorder;

import android.media.AudioRecord;
import android.media.audiofx.NoiseSuppressor;
import com.github.squti.androidwaverecorder.WaveConfig;
import com.github.squti.androidwaverecorder.WaveHeaderWriter;
import com.github.squti.androidwaverecorder.WaveRecorder;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020\bH\u0002J\u0006\u0010#\u001a\u00020\u0014J\u0006\u0010$\u001a\u00020\u0014J\u0006\u0010%\u001a\u00020\u0014J\u0006\u0010&\u001a\u00020\u0014J\u0011\u0010'\u001a\u00020\u0014H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010(R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R(\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006)"}, d2={"Lcom/github/squti/androidwaverecorder/WaveRecorder;", "", "filePath", "", "(Ljava/lang/String;)V", "audioRecorder", "Landroid/media/AudioRecord;", "isPaused", "", "isRecording", "noiseSuppressor", "Landroid/media/audiofx/NoiseSuppressor;", "noiseSuppressorActive", "getNoiseSuppressorActive", "()Z", "setNoiseSuppressorActive", "(Z)V", "onAmplitudeListener", "Lkotlin/Function1;", "", "", "getOnAmplitudeListener", "()Lkotlin/jvm/functions/Function1;", "setOnAmplitudeListener", "(Lkotlin/jvm/functions/Function1;)V", "waveConfig", "Lcom/github/squti/androidwaverecorder/WaveConfig;", "getWaveConfig", "()Lcom/github/squti/androidwaverecorder/WaveConfig;", "setWaveConfig", "(Lcom/github/squti/androidwaverecorder/WaveConfig;)V", "calculateAmplitudeMax", "data", "", "isAudioRecorderInitialized", "pauseRecording", "resumeRecording", "startRecording", "stopRecording", "writeAudioDataToStorage", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "android-wave-recorder_release"})
public final class WaveRecorder {
    @NotNull
    private WaveConfig waveConfig;
    @Nullable
    private Function1<? super Integer, Unit> onAmplitudeListener;
    private boolean noiseSuppressorActive;
    private boolean isRecording;
    private boolean isPaused;
    private AudioRecord audioRecorder;
    private NoiseSuppressor noiseSuppressor;
    private String filePath;

    @NotNull
    public final WaveConfig getWaveConfig() {
        return this.waveConfig;
    }

    public final void setWaveConfig(@NotNull WaveConfig waveConfig) {
        Intrinsics.checkParameterIsNotNull((Object)waveConfig, (String)"<set-?>");
        this.waveConfig = waveConfig;
    }

    @Nullable
    public final Function1<Integer, Unit> getOnAmplitudeListener() {
        return this.onAmplitudeListener;
    }

    public final void setOnAmplitudeListener(@Nullable Function1<? super Integer, Unit> function1) {
        this.onAmplitudeListener = function1;
    }

    public final boolean getNoiseSuppressorActive() {
        return this.noiseSuppressorActive;
    }

    public final void setNoiseSuppressorActive(boolean bl) {
        this.noiseSuppressorActive = bl;
    }

    public final void startRecording() {
        if (!this.isAudioRecorderInitialized()) {
            this.audioRecorder = new AudioRecord(1, this.waveConfig.getSampleRate(), this.waveConfig.getChannels(), this.waveConfig.getAudioEncoding(), AudioRecord.getMinBufferSize((int)this.waveConfig.getSampleRate(), (int)this.waveConfig.getChannels(), (int)this.waveConfig.getAudioEncoding()));
            this.isRecording = true;
            AudioRecord audioRecord = this.audioRecorder;
            if (audioRecord == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"audioRecorder");
            }
            audioRecord.startRecording();
            if (this.noiseSuppressorActive) {
                AudioRecord audioRecord2 = this.audioRecorder;
                if (audioRecord2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"audioRecorder");
                }
                this.noiseSuppressor = NoiseSuppressor.create((int)audioRecord2.getAudioSessionId());
            }
            BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                private CoroutineScope p$;
                Object L$0;
                int label;
                final /* synthetic */ WaveRecorder this$0;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            CoroutineScope $this$launch = this.p$;
                            this.L$0 = $this$launch;
                            this.label = 1;
                            Object object2 = this.this$0.writeAudioDataToStorage((Continuation<? super Unit>)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.this$0 = waveRecorder;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    final /* synthetic */ Object writeAudioDataToStorage(@NotNull Continuation<? super Unit> $completion) {
        block10: {
            if (!($completion instanceof writeAudioDataToStorage.1)) ** GOTO lbl-1000
            var12_2 = $completion;
            if ((var12_2.label & -2147483648) != 0) {
                var12_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    /* synthetic */ Object result;
                    int label;
                    final /* synthetic */ WaveRecorder this$0;
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    int I$0;
                    int I$1;

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.writeAudioDataToStorage((Continuation<? super Unit>)this);
                    }
                    {
                        this.this$0 = waveRecorder;
                        super(continuation);
                    }
                };
            }
            $result = $continuation.result;
            var13_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            block0 : switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    bufferSize = AudioRecord.getMinBufferSize((int)this.waveConfig.getSampleRate(), (int)this.waveConfig.getChannels(), (int)this.waveConfig.getAudioEncoding());
                    data = new byte[bufferSize];
                    var5_7 = new File(this.filePath);
                    var6_9 = false;
                    outputStream = new FileOutputStream(var5_7);
lbl17:
                    // 5 sources

                    while (this.isRecording) {
                        v0 = this.audioRecorder;
                        if (v0 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"audioRecorder");
                        }
                        if (-3 == (operationStatus = v0.read(data, 0, bufferSize))) continue;
                        if (!this.isPaused) {
                            outputStream.write(data);
                        }
                        if (this.onAmplitudeListener == null) break block0;
                        var7_12 = false;
                        var8_13 = false;
                        it = var6_10;
                        $i$a$-let-WaveRecorder$writeAudioDataToStorage$2 = false;
                        $continuation.L$0 = this;
                        $continuation.I$0 = bufferSize;
                        $continuation.L$1 = data;
                        $continuation.L$2 = outputStream;
                        $continuation.I$1 = operationStatus;
                        $continuation.L$3 = it;
                        $continuation.label = 1;
                        v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it, null, this, (Continuation)$continuation, data){
                            private CoroutineScope p$;
                            int label;
                            final /* synthetic */ Function1 $it;
                            final /* synthetic */ WaveRecorder this$0;
                            final /* synthetic */ Continuation $continuation$inlined;
                            final /* synthetic */ byte[] $data$inlined;
                            {
                                this.$it = function1;
                                this.this$0 = waveRecorder;
                                this.$continuation$inlined = continuation2;
                                this.$data$inlined = byArray;
                                super(2, continuation);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        CoroutineScope $this$withContext = this.p$;
                                        this.$it.invoke((Object)Boxing.boxInt((int)WaveRecorder.access$calculateAmplitudeMax(this.this$0, this.$data$inlined)));
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                CoroutineScope cfr_ignored_0 = (CoroutineScope)value;
                                function2.p$ = (CoroutineScope)value;
                                Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
                                return function22;
                            }

                            public final Object invoke(Object object, Object object2) {
                                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)$continuation);
                        if (v1 != var13_4) continue;
                        return var13_4;
                    }
                    break block10;
                }
                case 1: {
                    it = (Function1<? super Integer, Unit>)$continuation.L$3;
                    operationStatus = $continuation.I$1;
                    outputStream = (FileOutputStream)$continuation.L$2;
                    data = (byte[])$continuation.L$1;
                    bufferSize = $continuation.I$0;
                    this = (WaveRecorder)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
                    ** GOTO lbl17
                }
            }
            ** GOTO lbl17
        }
        outputStream.close();
        v2 = this.noiseSuppressor;
        if (v2 != null) {
            v2.release();
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final int calculateAmplitudeMax(byte[] data) {
        short[] shortData = new short[data.length / 2];
        ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(shortData);
        Short s = ArraysKt.max((short[])shortData);
        return s != null ? s : (short)0;
    }

    public final void stopRecording() {
        if (this.isAudioRecorderInitialized()) {
            this.isRecording = false;
            AudioRecord audioRecord = this.audioRecorder;
            if (audioRecord == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"audioRecorder");
            }
            audioRecord.stop();
            AudioRecord audioRecord2 = this.audioRecorder;
            if (audioRecord2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"audioRecorder");
            }
            audioRecord2.release();
            new WaveHeaderWriter(this.filePath, this.waveConfig).writeHeader();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAudioRecorderInitialized() {
        if (this.audioRecorder == null) return false;
        AudioRecord audioRecord = this.audioRecorder;
        if (audioRecord == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"audioRecorder");
        }
        if (audioRecord.getState() != 1) return false;
        return true;
    }

    public final void pauseRecording() {
        this.isPaused = true;
    }

    public final void resumeRecording() {
        this.isPaused = false;
    }

    public WaveRecorder(@NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        this.filePath = filePath;
        this.waveConfig = new WaveConfig(0, 0, 0, 7, null);
    }

    public static final /* synthetic */ int access$calculateAmplitudeMax(WaveRecorder $this, byte[] data) {
        return $this.calculateAmplitudeMax(data);
    }

    public static final /* synthetic */ AudioRecord access$getAudioRecorder$p(WaveRecorder $this) {
        AudioRecord audioRecord = $this.audioRecorder;
        if (audioRecord == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"audioRecorder");
        }
        return audioRecord;
    }

    public static final /* synthetic */ void access$setAudioRecorder$p(WaveRecorder $this, AudioRecord audioRecord) {
        $this.audioRecorder = audioRecord;
    }
}

