/*
 * Decompiled with CFR 0.152.
 */
package com.github.squti.androidwaverecorder;

import com.github.squti.androidwaverecorder.WaveConfig;
import com.github.squti.androidwaverecorder.WaveConfigKt;
import java.io.File;
import java.io.FileInputStream;
import java.io.RandomAccessFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J8\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/github/squti/androidwaverecorder/WaveHeaderWriter;", "", "filePath", "", "waveConfig", "Lcom/github/squti/androidwaverecorder/WaveConfig;", "(Ljava/lang/String;Lcom/github/squti/androidwaverecorder/WaveConfig;)V", "getWavFileHeaderByteArray", "", "totalAudioLen", "", "totalDataLen", "longSampleRate", "channels", "", "byteRate", "bitsPerSample", "writeHeader", "", "android-wave-recorder_release"})
public final class WaveHeaderWriter {
    private final String filePath;
    private final WaveConfig waveConfig;

    public final void writeHeader() {
        File file = new File(this.filePath);
        boolean bl = false;
        FileInputStream inputStream = new FileInputStream(file);
        long totalAudioLen = inputStream.getChannel().size() - (long)44;
        long totalDataLen = totalAudioLen + (long)36;
        int channels = this.waveConfig.getChannels() == 16 ? 1 : 2;
        long sampleRate = this.waveConfig.getSampleRate();
        long byteRate = WaveConfigKt.bitPerSample(this.waveConfig.getAudioEncoding()) * this.waveConfig.getSampleRate() * channels / 8;
        byte[] header = this.getWavFileHeaderByteArray(totalAudioLen, totalDataLen, sampleRate, channels, byteRate, WaveConfigKt.bitPerSample(this.waveConfig.getAudioEncoding()));
        RandomAccessFile f = new RandomAccessFile(new File(this.filePath), "rw");
        f.seek(0L);
        f.write(header);
        f.close();
    }

    private final byte[] getWavFileHeaderByteArray(long totalAudioLen, long totalDataLen, long longSampleRate, int channels, long byteRate, int bitsPerSample) {
        byte[] header = new byte[]{(byte)82, (byte)73, (byte)70, (byte)70, (byte)(totalDataLen & 0xFFL), (byte)(totalDataLen >> 8 & 0xFFL), (byte)(totalDataLen >> 16 & 0xFFL), (byte)(totalDataLen >> 24 & 0xFFL), (byte)87, (byte)65, (byte)86, (byte)69, (byte)102, (byte)109, (byte)116, (byte)32, 16, 0, 0, 0, 1, 0, (byte)channels, 0, (byte)(longSampleRate & 0xFFL), (byte)(longSampleRate >> 8 & 0xFFL), (byte)(longSampleRate >> 16 & 0xFFL), (byte)(longSampleRate >> 24 & 0xFFL), (byte)(byteRate & 0xFFL), (byte)(byteRate >> 8 & 0xFFL), (byte)(byteRate >> 16 & 0xFFL), (byte)(byteRate >> 24 & 0xFFL), (byte)(channels * (bitsPerSample / 8)), 0, (byte)bitsPerSample, 0, (byte)100, (byte)97, (byte)116, (byte)97, (byte)(totalAudioLen & 0xFFL), (byte)(totalAudioLen >> 8 & 0xFFL), (byte)(totalAudioLen >> 16 & 0xFFL), (byte)(totalAudioLen >> 24 & 0xFFL)};
        return header;
    }

    public WaveHeaderWriter(@NotNull String filePath, @NotNull WaveConfig waveConfig) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)waveConfig, (String)"waveConfig");
        this.filePath = filePath;
        this.waveConfig = waveConfig;
    }
}

