/*
 * Decompiled with CFR 0.152.
 */
package net.iryndin.jdbf.reader;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.iryndin.jdbf.core.MemoFileHeader;
import net.iryndin.jdbf.core.MemoRecord;
import net.iryndin.jdbf.util.BitUtils;
import net.iryndin.jdbf.util.IOUtils;

public class MemoReader
implements Closeable {
    private static final int BUFFER_SIZE = 8192;
    private InputStream memoInputStream;
    private MemoFileHeader memoHeader;

    public MemoReader(File memoFile) throws IOException {
        this(new FileInputStream(memoFile));
    }

    public MemoReader(InputStream inputStream) throws IOException {
        this.memoInputStream = new BufferedInputStream(inputStream, 8192);
        this.readMetadata();
    }

    private void readMetadata() throws IOException {
        byte[] headerBytes = new byte[512];
        this.memoInputStream.mark(8192);
        if (IOUtils.readFully(this.memoInputStream, headerBytes) != 512) {
            throw new IOException("The file is corrupted or is not a dbf file");
        }
        this.memoHeader = MemoFileHeader.create(headerBytes);
    }

    @Override
    public void close() throws IOException {
        if (this.memoInputStream != null) {
            this.memoInputStream.close();
        }
    }

    public MemoFileHeader getMemoHeader() {
        return this.memoHeader;
    }

    public MemoRecord read(int offsetInBlocks) throws IOException {
        this.memoInputStream.reset();
        this.memoInputStream.skip(this.memoHeader.getBlockSize() * offsetInBlocks);
        byte[] recordHeader = new byte[8];
        if (IOUtils.readFully(this.memoInputStream, recordHeader) != 8) {
            throw new IOException("The file is corrupted or is not a dbf file");
        }
        int memoRecordLength = BitUtils.makeInt(recordHeader[7], recordHeader[6], recordHeader[5], recordHeader[4]);
        byte[] recordBody = new byte[memoRecordLength];
        if (IOUtils.readFully(this.memoInputStream, recordBody) != memoRecordLength) {
            throw new IOException("The file is corrupted or is not a dbf file");
        }
        return new MemoRecord(recordHeader, recordBody, this.memoHeader.getBlockSize(), offsetInBlocks);
    }
}

