/*
 * Decompiled with CFR 0.152.
 */
package net.iryndin.jdbf.core;

import net.iryndin.jdbf.util.BitUtils;

public class MemoFileHeader {
    private byte[] headerBytes;
    private int nextFreeBlockLocation;
    private int blockSize;

    public static MemoFileHeader create(byte[] headerBytes) {
        MemoFileHeader h = new MemoFileHeader();
        h.setHeaderBytes(headerBytes);
        h.calculateHeaderFields();
        return h;
    }

    private void calculateHeaderFields() {
        this.nextFreeBlockLocation = BitUtils.makeInt(this.headerBytes[3], this.headerBytes[2], this.headerBytes[1], this.headerBytes[0]);
        this.blockSize = BitUtils.makeInt(this.headerBytes[7], this.headerBytes[6]);
    }

    private void setHeaderBytes(byte[] headerBytes) {
        this.headerBytes = headerBytes;
    }

    public int getNextFreeBlockLocation() {
        return this.nextFreeBlockLocation;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public String toString() {
        return "MemoFileHeader{nextFreeBlockLocation=" + this.nextFreeBlockLocation + ", blockSize=" + this.blockSize + '}';
    }
}

