/*
 * Decompiled with CFR 0.152.
 */
package net.iryndin.jdbf.core;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import net.iryndin.jdbf.core.DbfField;
import net.iryndin.jdbf.core.DbfFieldTypeEnum;
import net.iryndin.jdbf.core.DbfMetadata;
import net.iryndin.jdbf.reader.MemoReader;
import net.iryndin.jdbf.util.BitUtils;
import net.iryndin.jdbf.util.JdbfUtils;

public class DbfRecord {
    public static final String NUMERIC_OVERFLOW = "*";
    private byte[] bytes;
    private DbfMetadata metadata;
    private MemoReader memoReader;
    private Charset stringCharset;
    private final int recordNumber;

    public DbfRecord(byte[] source, DbfMetadata metadata, MemoReader memoReader, int recordNumber) {
        this.recordNumber = recordNumber;
        this.bytes = new byte[source.length];
        System.arraycopy(source, 0, this.bytes, 0, source.length);
        this.metadata = metadata;
        this.memoReader = memoReader;
    }

    public boolean isDeleted() {
        return this.bytes[0] == 42;
    }

    public Charset getStringCharset() {
        return this.stringCharset;
    }

    public void setStringCharset(Charset stringCharset) {
        this.stringCharset = stringCharset;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getRecordNumber() {
        return this.recordNumber;
    }

    public String getString(String fieldName) {
        Charset charset = this.stringCharset;
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        return this.getString(fieldName, charset);
    }

    public String getString(String fieldName, String charsetName) {
        return this.getString(fieldName, Charset.forName(charsetName));
    }

    public String getString(String fieldName, Charset charset) {
        int actualLength;
        DbfField f = this.getField(fieldName);
        int actualOffset = f.getOffset();
        byte[] fieldBytes = new byte[actualLength];
        System.arraycopy(this.bytes, actualOffset, fieldBytes, 0, actualLength);
        for (actualLength = f.getLength(); actualLength > 0 && this.bytes[actualOffset] == JdbfUtils.EMPTY; --actualLength) {
            ++actualOffset;
        }
        while (actualLength > 0 && this.bytes[actualOffset + actualLength - 1] == JdbfUtils.EMPTY) {
            --actualLength;
        }
        if (actualLength == 0) {
            return null;
        }
        return new String(this.bytes, actualOffset, actualLength, charset);
    }

    public byte[] getMemoAsBytes(String fieldName) throws IOException {
        DbfField f = this.getField(fieldName);
        if (f.getType() != DbfFieldTypeEnum.Memo) {
            throw new IllegalArgumentException("Field '" + fieldName + "' is not MEMO field!");
        }
        int offsetInBlocks = 0;
        if (f.getLength() == 10) {
            offsetInBlocks = this.getBigDecimal(fieldName).intValueExact();
        } else {
            byte[] dbfFieldBytes = new byte[f.getLength()];
            System.arraycopy(this.bytes, f.getOffset(), dbfFieldBytes, 0, f.getLength());
            offsetInBlocks = BitUtils.makeInt(dbfFieldBytes[0], dbfFieldBytes[1], dbfFieldBytes[2], dbfFieldBytes[3]);
        }
        if (offsetInBlocks == 0) {
            return new byte[0];
        }
        return this.memoReader.read(offsetInBlocks).getValue();
    }

    public String getMemoAsString(String fieldName, Charset charset) throws IOException {
        DbfField f = this.getField(fieldName);
        if (f.getType() != DbfFieldTypeEnum.Memo) {
            throw new IllegalArgumentException("Field '" + fieldName + "' is not MEMO field!");
        }
        int offsetInBlocks = 0;
        if (f.getLength() == 10) {
            offsetInBlocks = this.getBigDecimal(fieldName).intValueExact();
        } else {
            byte[] dbfFieldBytes = new byte[f.getLength()];
            System.arraycopy(this.bytes, f.getOffset(), dbfFieldBytes, 0, f.getLength());
            offsetInBlocks = BitUtils.makeInt(dbfFieldBytes[0], dbfFieldBytes[1], dbfFieldBytes[2], dbfFieldBytes[3]);
        }
        if (offsetInBlocks == 0) {
            return "";
        }
        return this.memoReader.read(offsetInBlocks).getValueAsString(charset);
    }

    public String getMemoAsString(String fieldName) throws IOException {
        Charset charset = this.getStringCharset();
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        return this.getMemoAsString(fieldName, charset);
    }

    public Date getDate(String fieldName) throws ParseException {
        String s = this.getString(fieldName);
        if (s == null) {
            return null;
        }
        return JdbfUtils.parseDate(s);
    }

    public BigDecimal getBigDecimal(String fieldName) {
        DbfField f = this.getField(fieldName);
        String s = this.getString(fieldName);
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        if ((s = s.trim()).contains(NUMERIC_OVERFLOW)) {
            return null;
        }
        return new BigDecimal(s);
    }

    public Boolean getBoolean(String fieldName) {
        String s = this.getString(fieldName);
        if (s == null) {
            return null;
        }
        if (s.equalsIgnoreCase("t")) {
            return Boolean.TRUE;
        }
        if (s.equalsIgnoreCase("f")) {
            return Boolean.FALSE;
        }
        return null;
    }

    public void setBoolean(String fieldName, Boolean value) {
        DbfField f = this.getField(fieldName);
    }

    public byte[] getBytes(String fieldName) {
        DbfField f = this.getField(fieldName);
        byte[] b = new byte[f.getLength()];
        System.arraycopy(this.bytes, f.getOffset(), b, 0, f.getLength());
        return b;
    }

    public void setBytes(String fieldName, byte[] fieldBytes) {
        DbfField f = this.getField(fieldName);
        System.arraycopy(fieldBytes, 0, this.bytes, f.getOffset(), f.getLength());
    }

    public Integer getInteger(String fieldName) {
        byte[] bytes = this.getBytes(fieldName);
        return BitUtils.makeInt(bytes[0], bytes[1], bytes[2], bytes[3]);
    }

    public DbfField getField(String fieldName) {
        return this.metadata.getField(fieldName);
    }

    public Collection<DbfField> getFields() {
        return this.metadata.getFields();
    }

    public String getStringRepresentation() throws Exception {
        StringBuilder sb = new StringBuilder(this.bytes.length * 10);
        for (DbfField f : this.getFields()) {
            sb.append(f.getName()).append("=");
            switch (f.getType()) {
                case Character: {
                    String s = this.getString(f.getName());
                    sb.append(s);
                    break;
                }
                case Date: {
                    Date d = this.getDate(f.getName());
                    sb.append(d);
                    break;
                }
                case Numeric: {
                    BigDecimal bd = this.getBigDecimal(f.getName());
                    sb.append(bd);
                    break;
                }
                case Logical: {
                    Boolean b = this.getBoolean(f.getName());
                    sb.append(b);
                    break;
                }
            }
            sb.append(", ");
        }
        return sb.toString();
    }

    public Map<String, Object> toMap() throws ParseException {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(this.getFields().size() * 2);
        for (DbfField f : this.getFields()) {
            String name = f.getName();
            switch (f.getType()) {
                case Character: {
                    map.put(name, this.getString(name));
                    break;
                }
                case Date: {
                    map.put(name, this.getDate(name));
                    break;
                }
                case Numeric: {
                    map.put(name, this.getBigDecimal(name));
                    break;
                }
                case Logical: {
                    map.put(name, this.getBoolean(name));
                    break;
                }
                case Integer: {
                    map.put(name, this.getInteger(name));
                }
            }
        }
        return map;
    }
}

