/*
 * Decompiled with CFR 0.152.
 */
package net.iryndin.jdbf.core;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.iryndin.jdbf.core.DbfField;
import net.iryndin.jdbf.core.DbfFileTypeEnum;

public class DbfMetadata {
    private DbfFileTypeEnum type;
    private Date updateDate;
    private int recordsQty;
    private int fullHeaderLength;
    private int oneRecordLength;
    private byte uncompletedTxFlag;
    private byte ecnryptionFlag;
    private Map<String, DbfField> fieldMap;

    public DbfFileTypeEnum getType() {
        return this.type;
    }

    public void setType(DbfFileTypeEnum type) throws IOException {
        if (type == null) {
            throw new IOException("The file is corrupted or is not a dbf file");
        }
        this.type = type;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public int getRecordsQty() {
        return this.recordsQty;
    }

    public void setRecordsQty(int recordsQty) {
        this.recordsQty = recordsQty;
    }

    public int getFullHeaderLength() {
        return this.fullHeaderLength;
    }

    public void setFullHeaderLength(int fullHeaderLength) {
        this.fullHeaderLength = fullHeaderLength;
    }

    public int getOneRecordLength() {
        return this.oneRecordLength;
    }

    public void setOneRecordLength(int oneRecordLength) {
        this.oneRecordLength = oneRecordLength;
    }

    public byte getUncompletedTxFlag() {
        return this.uncompletedTxFlag;
    }

    public void setUncompletedTxFlag(byte uncompletedTxFlag) {
        this.uncompletedTxFlag = uncompletedTxFlag;
    }

    public byte getEcnryptionFlag() {
        return this.ecnryptionFlag;
    }

    public void setEcnryptionFlag(byte ecnryptionFlag) {
        this.ecnryptionFlag = ecnryptionFlag;
    }

    public DbfField getField(String name) {
        return this.fieldMap.get(name);
    }

    public Collection<DbfField> getFields() {
        return this.fieldMap.values();
    }

    public void setFields(List<DbfField> fields) {
        this.processFields(fields);
    }

    private void processFields(List<DbfField> fields) {
        this.fieldMap = new LinkedHashMap<String, DbfField>(fields.size() * 2);
        int offset = 1;
        for (DbfField f : fields) {
            f.setOffset(offset);
            offset += f.getLength();
            this.fieldMap.put(f.getName(), f);
        }
    }

    public String getFieldsStringRepresentation() {
        if (this.fieldMap == null) {
            return null;
        }
        int i = this.fieldMap.size();
        StringBuilder sb = new StringBuilder(i * 64);
        for (DbfField f : this.fieldMap.values()) {
            sb.append(f.getStringRepresentation());
            if (--i <= 0) continue;
            sb.append("|");
        }
        return sb.toString();
    }

    private String formatUpdateDate() {
        return new SimpleDateFormat("yyyy-MM-dd").format(this.updateDate);
    }

    public String toString() {
        return "DbfMetadata [\n  type=" + (Object)((Object)this.type) + ", \n  updateDate=" + this.formatUpdateDate() + ", \n  recordsQty=" + this.recordsQty + ", \n  fullHeaderLength=" + this.fullHeaderLength + ", \n  oneRecordLength=" + this.oneRecordLength + ", \n  uncompletedTxFlag=" + this.uncompletedTxFlag + ", \n  ecnryptionFlag=" + this.ecnryptionFlag + ", \n  fields=" + this.getFieldsStringRepresentation() + "\n]";
    }
}

