/*
 * Decompiled with CFR 0.152.
 */
package net.iryndin.jdbf.core;

public enum DbfFileTypeEnum {
    FoxBASE1(2, "FoxBASE"),
    FoxBASEPlus1(3, "FoxBASE+/Dbase III plus, no memo"),
    VisualFoxPro1(48, "Visual FoxPro"),
    VisualFoxPro2(49, "Visual FoxPro, autoincrement enabled"),
    dBASEIV1(67, "dBASE IV SQL table files, no memo"),
    dBASEIV2(99, "dBASE IV SQL system files, no memo"),
    FoxBASEPlus2(131, "FoxBASE+/dBASE III PLUS, with memo"),
    dBASEIV3(139, "dBASE IV with memo"),
    dBASEIV4(203, "dBASE IV SQL table files, with memo"),
    FoxPro2x(245, "FoxPro 2.x (or earlier) with memo"),
    FoxBASE2(251, "FoxBASE"),
    dBASEVII1(68, "dBASE VII SQL table files, no memo"),
    dBASEVII2(100, "dBASE VII SQL system files, no memo"),
    dBASEIVII3(141, "dBASE VII with memo"),
    dBASEIVII4(205, "dBASE VII SQL table files, with memo");

    final int type;
    final String description;

    private DbfFileTypeEnum(int type, String description) {
        this.type = type;
        this.description = description;
    }

    public static DbfFileTypeEnum fromInt(byte bType) {
        int iType = 0xFF & bType;
        for (DbfFileTypeEnum e : DbfFileTypeEnum.values()) {
            if (e.type != iType) continue;
            return e;
        }
        return null;
    }

    public byte toByte() {
        return (byte)this.type;
    }
}

