/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava.codes;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.github.mustachejava.TemplateContext;
import com.github.mustachejava.codes.DefaultCode;
import com.github.mustachejava.util.LatchedWriter;
import com.google.common.base.Function;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;

public class ValueCode
extends DefaultCode {
    private final String variable;
    private final boolean encoded;
    private final DefaultMustacheFactory cf;
    private ExecutorService les;

    public ValueCode(TemplateContext tc, DefaultMustacheFactory cf, String variable, boolean encoded) {
        super(tc, cf.getObjectHandler(), null, variable, "");
        this.cf = cf;
        this.variable = variable;
        this.encoded = encoded;
        this.les = cf.getExecutorService();
    }

    @Override
    public Writer execute(Writer writer, Object[] scopes) {
        Object object = this.get(this.variable, scopes);
        if (object != null) {
            try {
                if (object instanceof Function) {
                    this.handleFunction(writer, (Function)object, scopes);
                } else {
                    if (object instanceof Callable) {
                        return this.handleCallable(writer, (Callable)object, scopes);
                    }
                    this.execute(writer, object.toString());
                }
            }
            catch (Exception e) {
                throw new MustacheException("Failed to get value for " + this.variable + " at line " + this.tc.file() + ":" + this.tc.line(), e);
            }
        }
        return super.execute(writer, scopes);
    }

    protected Writer handleCallable(Writer writer, final Callable callable, Object[] scopes) throws Exception {
        if (this.les == null) {
            this.execute(writer, callable.call().toString());
            return super.execute(writer, scopes);
        }
        final LatchedWriter latchedWriter = new LatchedWriter(writer);
        final Writer finalWriter = writer;
        this.les.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Object call = callable.call();
                    ValueCode.this.execute(finalWriter, call == null ? null : call.toString());
                    latchedWriter.done();
                }
                catch (Throwable e) {
                    latchedWriter.failed(e);
                }
            }
        });
        return super.execute((Writer)latchedWriter, scopes);
    }

    protected void handleFunction(Writer writer, Function function, Object[] scopes) throws IOException {
        String value;
        Object newtemplate = function.apply(null);
        if (newtemplate != null) {
            String templateText = newtemplate.toString();
            Mustache mustache = this.cf.getTemplate(templateText);
            if (mustache == null) {
                mustache = this.cf.compile(new StringReader(templateText), this.variable, "{{", "}}");
                this.cf.putTemplate(templateText, mustache);
            }
            StringWriter sw = new StringWriter();
            mustache.execute((Writer)sw, scopes);
            value = sw.toString();
        } else {
            value = "";
        }
        this.execute(writer, value);
    }

    protected void execute(Writer writer, String value) throws IOException {
        if (this.encoded) {
            this.cf.encode(value, writer);
        } else {
            writer.write(value);
        }
    }
}

