/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.extras.minify.engine;

import java.util.regex.Pattern;
import org.thymeleaf.extras.minify.engine.AbstractMinifierTemplateHandler;
import org.thymeleaf.util.StringUtils;

public class SimpleMinifierTemplateHandler
extends AbstractMinifierTemplateHandler {
    protected static final Pattern LINE_BREAK_PATTERN = Pattern.compile("[\r\n]");
    protected static final Pattern LEFT_SPACES_PATTERN = Pattern.compile("^[ \\t]+");
    protected static final Pattern RIGHT_SPACES_PATTERN = Pattern.compile("[ \\t]+$");
    protected static final Pattern MIDDLE_SPACES_PATTERN = Pattern.compile("[ \\t]+");
    private boolean removeLineBreak = true;
    private String lineBreakReplacement = "";
    private boolean removeLeftSpaces = true;
    private String leftSpacesReplacement = "";
    private boolean removeRightSpaces = true;
    private String rightSpacesReplacement = "";
    private boolean removeMiddleSpaces = true;
    private String middleSpacesReplacement = " ";

    @Override
    protected String minifyInlineStyle(String value) {
        return this.minifyTextInternal(value);
    }

    @Override
    protected String minifyInlineScript(String value) {
        return this.minifyTextInternal(value);
    }

    @Override
    protected String minifyText(String value) {
        return this.minifyTextInternal(value);
    }

    protected String minifyTextInternal(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return value;
        }
        String minified = value;
        if (this.removeLineBreak) {
            minified = LINE_BREAK_PATTERN.matcher(minified).replaceAll(this.lineBreakReplacement);
        }
        if (this.removeLeftSpaces) {
            minified = LEFT_SPACES_PATTERN.matcher(minified).replaceAll(this.leftSpacesReplacement);
        }
        if (this.removeRightSpaces) {
            minified = RIGHT_SPACES_PATTERN.matcher(minified).replaceAll(this.rightSpacesReplacement);
        }
        if (this.removeMiddleSpaces) {
            minified = MIDDLE_SPACES_PATTERN.matcher(minified).replaceAll(this.middleSpacesReplacement);
        }
        return minified;
    }

    protected boolean isRemoveLineBreak() {
        return this.removeLineBreak;
    }

    public SimpleMinifierTemplateHandler setRemoveLineBreak(boolean removeLineBreak) {
        this.removeLineBreak = removeLineBreak;
        return this;
    }

    protected String getLineBreakReplacement() {
        return this.lineBreakReplacement;
    }

    public SimpleMinifierTemplateHandler setLineBreakReplacement(String lineBreakReplacement) {
        this.lineBreakReplacement = lineBreakReplacement;
        return this;
    }

    protected boolean isRemoveLeftSpaces() {
        return this.removeLeftSpaces;
    }

    public SimpleMinifierTemplateHandler setRemoveLeftSpaces(boolean removeLeftSpaces) {
        this.removeLeftSpaces = removeLeftSpaces;
        return this;
    }

    protected String getLeftSpacesReplacement() {
        return this.leftSpacesReplacement;
    }

    public SimpleMinifierTemplateHandler setLeftSpacesReplacement(String leftSpacesReplacement) {
        this.leftSpacesReplacement = leftSpacesReplacement;
        return this;
    }

    protected boolean isRemoveRightSpaces() {
        return this.removeRightSpaces;
    }

    public SimpleMinifierTemplateHandler setRemoveRightSpaces(boolean removeRightSpaces) {
        this.removeRightSpaces = removeRightSpaces;
        return this;
    }

    protected String getRightSpacesReplacement() {
        return this.rightSpacesReplacement;
    }

    public SimpleMinifierTemplateHandler setRightSpacesReplacement(String rightSpacesReplacement) {
        this.rightSpacesReplacement = rightSpacesReplacement;
        return this;
    }

    protected boolean isRemoveMiddleSpaces() {
        return this.removeMiddleSpaces;
    }

    public SimpleMinifierTemplateHandler setRemoveMiddleSpaces(boolean removeMiddleSpaces) {
        this.removeMiddleSpaces = removeMiddleSpaces;
        return this;
    }

    protected String getMiddleSpacesReplacement() {
        return this.middleSpacesReplacement;
    }

    public SimpleMinifierTemplateHandler setMiddleSpacesReplacement(String middleSpacesReplacement) {
        this.middleSpacesReplacement = middleSpacesReplacement;
        return this;
    }
}

