/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.thymeleaf;

import lombok.NonNull;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.thymeleaf.CustomThymeleafProperties;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafAutoConfiguration;
import org.springframework.boot.autoconfigure.web.reactive.WebFluxAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.thymeleaf.extras.minify.dialect.MinifierDialect;
import org.thymeleaf.templatemode.TemplateMode;

@Configuration
@EnableConfigurationProperties(value={CustomThymeleafProperties.class})
@ConditionalOnClass(value={TemplateMode.class})
@AutoConfigureBefore(value={ThymeleafAutoConfiguration.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class, WebFluxAutoConfiguration.class})
public class CustomThymeleafAutoConfiguration
extends ThymeleafAutoConfiguration {
    @Bean
    @Primary
    public CustomThymeleafProperties thymeleafProperties() {
        return new CustomThymeleafProperties();
    }

    @Configuration
    @ConditionalOnProperty(prefix="spring.thymeleaf", name={"minify.enabled"}, havingValue="true")
    @ConditionalOnClass(value={MinifierDialect.class})
    protected static class ThymeleafMinifierDialectConfiguration {
        @NonNull
        private final CustomThymeleafProperties properties;

        @Bean
        @ConditionalOnMissingBean
        public MinifierDialect minifierDialect() {
            return new MinifierDialect(this.properties.getMinify().getHandlerClass());
        }

        public ThymeleafMinifierDialectConfiguration(@NonNull CustomThymeleafProperties properties) {
            if (properties == null) {
                throw new NullPointerException("properties is marked @NonNull but is null");
            }
            this.properties = properties;
        }
    }
}

