/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.h2;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.SocketUtils;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="spring.h2.server")
public class H2ServerProperties {
    public static final String PREFIX = "spring.h2.server";
    private int port;
    private String baseDir;
    private boolean allowOthers;
    private boolean daemon = true;

    public String[] createArguments() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-tcp");
        args.add("-tcpPort");
        args.add(String.valueOf(this.determinePort()));
        args.add("-baseDir");
        args.add(this.determineBaseDir());
        if (this.allowOthers) {
            args.add("-tcpAllowOthers");
        }
        if (this.daemon) {
            args.add("-tcpDaemon");
        }
        return args.toArray(new String[0]);
    }

    protected int determinePort() throws IllegalStateException {
        if (this.port != 0) {
            return this.port;
        }
        return SocketUtils.findAvailableTcpPort();
    }

    protected String determineBaseDir() throws IllegalStateException {
        if (StringUtils.hasText((String)this.baseDir)) {
            return this.baseDir;
        }
        try {
            return Files.createTempDirectory("H2-", new FileAttribute[0]).toString();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to determine base directory", e);
        }
    }

    public int getPort() {
        return this.port;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public boolean isAllowOthers() {
        return this.allowOthers;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public void setAllowOthers(boolean allowOthers) {
        this.allowOthers = allowOthers;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof H2ServerProperties)) {
            return false;
        }
        H2ServerProperties other = (H2ServerProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$baseDir = this.getBaseDir();
        String other$baseDir = other.getBaseDir();
        if (this$baseDir == null ? other$baseDir != null : !this$baseDir.equals(other$baseDir)) {
            return false;
        }
        if (this.isAllowOthers() != other.isAllowOthers()) {
            return false;
        }
        return this.isDaemon() == other.isDaemon();
    }

    protected boolean canEqual(Object other) {
        return other instanceof H2ServerProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        String $baseDir = this.getBaseDir();
        result = result * 59 + ($baseDir == null ? 43 : $baseDir.hashCode());
        result = result * 59 + (this.isAllowOthers() ? 79 : 97);
        result = result * 59 + (this.isDaemon() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "H2ServerProperties(port=" + this.getPort() + ", baseDir=" + this.getBaseDir() + ", allowOthers=" + this.isAllowOthers() + ", daemon=" + this.isDaemon() + ")";
    }
}

