/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.flyway;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.flywaydb.core.CustomFlyway;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.callback.FlywayCallback;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.flyway.CustomFlywayProperties;
import org.springframework.boot.autoconfigure.flyway.FlywayAutoConfiguration;
import org.springframework.boot.autoconfigure.flyway.FlywayMigrationStrategy;
import org.springframework.boot.autoconfigure.flyway.FlywayProperties;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.jdbc.JdbcTemplateAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.ResourceLoader;

@Configuration
@ConditionalOnClass(value={CustomFlyway.class})
@ConditionalOnBean(value={DataSource.class})
@ConditionalOnProperty(prefix="spring.flyway", name={"enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={FlywayAutoConfiguration.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, JdbcTemplateAutoConfiguration.class, HibernateJpaAutoConfiguration.class})
public class CustomFlywayAutoConfiguration
extends FlywayAutoConfiguration {
    @Bean
    @Primary
    public CustomFlywayProperties flywayProperties() {
        return new CustomFlywayProperties();
    }

    @Configuration
    @ConditionalOnMissingBean(value={Flyway.class})
    @EnableConfigurationProperties(value={FlywayProperties.class})
    public static class CustomFlywayConfiguration
    extends FlywayAutoConfiguration.FlywayConfiguration {
        public CustomFlywayConfiguration(CustomFlywayProperties properties, DataSourceProperties dataSourceProperties, ResourceLoader resourceLoader, ObjectProvider<DataSource> dataSource, ObjectProvider<DataSource> flywayDataSource, ObjectProvider<FlywayMigrationStrategy> migrationStrategy, ObjectProvider<List<FlywayCallback>> flywayCallbacks) {
            super((FlywayProperties)properties, dataSourceProperties, resourceLoader, dataSource, flywayDataSource, migrationStrategy, flywayCallbacks);
        }

        @Bean
        @ConfigurationProperties(prefix="spring.flyway")
        public Flyway flyway() {
            Flyway config = super.flyway();
            String[] locations = Arrays.asList(config.getLocations()).stream().map(location -> location.getDescriptor()).collect(Collectors.toList()).toArray(new String[0]);
            CustomFlyway flyway = new CustomFlyway();
            flyway.setDataSource(config.getDataSource());
            flyway.setCallbacks(config.getCallbacks());
            flyway.setLocations(locations);
            return flyway;
        }
    }
}

