/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.claudb;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.SocketUtils;

@ConfigurationProperties(value="spring.claudb")
public class ClauDbProperties {
    public static final String PREFIX = "spring.claudb";
    private int port;

    public int determinePort() throws IllegalStateException {
        if (this.port != 0) {
            return this.port;
        }
        return SocketUtils.findAvailableTcpPort();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClauDbProperties)) {
            return false;
        }
        ClauDbProperties other = (ClauDbProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getPort() == other.getPort();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClauDbProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        return result;
    }

    public String toString() {
        return "ClauDbProperties(port=" + this.getPort() + ")";
    }
}

