/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.claudb;

import com.github.tonivade.claudb.ClauDB;
import com.github.tonivade.resp.RespServer;
import lombok.NonNull;
import org.springframework.boot.autoconfigure.AbstractDependsOnBeanFactoryPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.claudb.ClauDbProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@Configuration
@ConditionalOnClass(value={RespServer.class})
@ConditionalOnProperty(prefix="spring.claudb", name={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={ClauDbProperties.class})
@AutoConfigureOrder(value=-2147483648)
public class ClauDbAutoConfiguration {
    @NonNull
    private final ClauDbProperties properties;

    @Bean(initMethod="start", destroyMethod="stop")
    public RespServer respServer() {
        return ClauDB.builder().port(this.properties.determinePort()).build();
    }

    public ClauDbAutoConfiguration(@NonNull ClauDbProperties properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked @NonNull but is null");
        }
        this.properties = properties;
    }

    @Configuration
    @ConditionalOnClass(value={RedisConnectionFactory.class})
    public static class DataSourceDependsOnBeanFactoryPostProcessor
    extends AbstractDependsOnBeanFactoryPostProcessor {
        public DataSourceDependsOnBeanFactoryPostProcessor() {
            super(RedisConnectionFactory.class, new String[]{"clauDbServer"});
        }
    }
}

