/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.snom.internal;

import com.github.spotbugs.snom.SpotBugsReport;
import com.github.spotbugs.snom.SpotBugsTask;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.util.Optional;
import javax.inject.Inject;
import org.gradle.api.file.RegularFile;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;

public abstract class SpotBugsXmlReport
extends SpotBugsReport {
    @Inject
    public SpotBugsXmlReport(ObjectFactory objects, SpotBugsTask task) {
        super(objects, task);
        this.setDestination((Provider<File>)task.getReportsDir().file(task.getBaseName() + ".xml").map(RegularFile::getAsFile));
    }

    @Override
    @NonNull
    public Optional<String> toCommandLineOption() {
        return Optional.of("-xml:withMessages");
    }

    public String getName() {
        return "XML";
    }

    @Override
    public String getDisplayName() {
        return String.format("XML type report generated by the task %s", this.getTask().getPath());
    }
}

