/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs;

import com.github.spotbugs.SpotBugsExtension;
import com.github.spotbugs.SpotBugsReports;
import com.github.spotbugs.SpotBugsTask;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Properties;
import java.util.stream.StreamSupport;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.plugins.quality.CodeQualityExtension;
import org.gradle.api.plugins.quality.internal.AbstractCodeQualityPlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.util.GradleVersion;

public class SpotBugsPlugin
extends AbstractCodeQualityPlugin<SpotBugsTask> {
    private static final GradleVersion SUPPORTED_VERSION = GradleVersion.version((String)"4.0");
    private SpotBugsExtension extension;

    protected String getToolName() {
        return "SpotBugs";
    }

    protected Class<SpotBugsTask> getTaskType() {
        return SpotBugsTask.class;
    }

    protected void beforeApply() {
        this.verifyGradleVersion(GradleVersion.current());
        this.configureSpotBugsConfigurations();
        this.project.afterEvaluate(this::verify);
    }

    private void verify(Project p) {
        p.getTasks().withType(SpotBugsTask.class).forEach(task -> {
            SpotBugsReports reports = task.getReports();
            if (reports.getText() != null && reports.getText().getDestination() == null) {
                String message = String.format("Task '%s' has no destination for TEXT report. Set reports.text.destination to this task.", task.getName());
                throw new IllegalStateException(message);
            }
            if (reports.getXml() != null && reports.getXml().getDestination() == null) {
                String message = String.format("Task '%s' has no destination for XML report. Set reports.xml.destination to this task.", task.getName());
                throw new IllegalStateException(message);
            }
            if (reports.getHtml() != null && reports.getHtml().getDestination() == null) {
                String message = String.format("Task '%s' has no destination for HTML report. Set reports.html.destination. to this task", task.getName());
                throw new IllegalStateException(message);
            }
            if (reports.getEmacs() != null && reports.getEmacs().getDestination() == null) {
                String message = String.format("Task '%s' has no destination for EMACS report. Set reports.emacs.destination. to this task", task.getName());
                throw new IllegalStateException(message);
            }
        });
    }

    void verifyGradleVersion(GradleVersion version) throws IllegalArgumentException {
        if (version.compareTo(SUPPORTED_VERSION) < 0) {
            String message = String.format("Gradle version %s is unsupported. Please use %s or later.", version, SUPPORTED_VERSION);
            throw new IllegalArgumentException(message);
        }
    }

    private void configureSpotBugsConfigurations() {
        Configuration configuration = (Configuration)this.project.getConfigurations().create("spotbugsPlugins");
        configuration.setVisible(false);
        configuration.setTransitive(true);
        configuration.setDescription("The SpotBugs plugins to be used for this project.");
    }

    protected CodeQualityExtension createExtension() {
        this.extension = (SpotBugsExtension)((Object)this.project.getExtensions().create("spotbugs", SpotBugsExtension.class, new Object[]{this.project}));
        this.extension.setToolVersion(this.loadToolVersion());
        return this.extension;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String loadToolVersion() {
        URL url = SpotBugsPlugin.class.getClassLoader().getResource("spotbugs-gradle-plugin.properties");
        try (InputStream input = url.openStream();){
            Properties prop = new Properties();
            prop.load(input);
            String string = prop.getProperty("spotbugs-version");
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected void configureTaskDefaults(SpotBugsTask task, String baseName) {
        task.setPluginClasspath((FileCollection)this.project.getConfigurations().getAt("spotbugsPlugins"));
        Configuration configuration = this.project.getConfigurations().getAt("spotbugs");
        this.configureDefaultDependencies(configuration);
        this.configureTaskConventionMapping(configuration, task);
        this.configureReportsConventionMapping(task, baseName);
    }

    protected void configureConfiguration(Configuration configuration) {
    }

    private void configureDefaultDependencies(Configuration configuration) {
        configuration.defaultDependencies(dependencies -> dependencies.add((Object)this.project.getDependencies().create((Object)("com.github.spotbugs:spotbugs:" + this.extension.getToolVersion()))));
    }

    private void configureTaskConventionMapping(Configuration configuration, SpotBugsTask task) {
        ConventionMapping taskMapping = task.getConventionMapping();
        taskMapping.map("spotbugsClasspath", () -> configuration);
        taskMapping.map("ignoreFailures", () -> ((SpotBugsExtension)this.extension).isIgnoreFailures());
        taskMapping.map("effort", this.extension::getEffort);
        taskMapping.map("reportLevel", this.extension::getReportLevel);
        taskMapping.map("visitors", this.extension::getVisitors);
        taskMapping.map("omitVisitors", this.extension::getOmitVisitors);
        taskMapping.map("excludeFilterConfig", this.extension::getExcludeFilterConfig);
        taskMapping.map("includeFilterConfig", this.extension::getIncludeFilterConfig);
        taskMapping.map("excludeBugsFilterConfig", this.extension::getExcludeBugsFilterConfig);
        taskMapping.map("extraArgs", this.extension::getExtraArgs);
        taskMapping.map("showProgress", this.extension::isShowProgress);
    }

    private void configureReportsConventionMapping(SpotBugsTask task, String baseName) {
        task.getReports().all(report -> {
            ConventionMapping reportMapping = SpotBugsPlugin.conventionMappingOf((Object)report);
            reportMapping.map("enabled", () -> report.getName().equals("xml"));
            reportMapping.map("destination", () -> new File(this.extension.getReportsDir(), baseName + "." + report.getName()));
        });
    }

    protected void configureForSourceSet(SourceSet sourceSet, SpotBugsTask task) {
        task.setDescription("Run SpotBugs analysis for " + sourceSet.getName() + " classes");
        task.setSource((FileTree)sourceSet.getAllJava());
        ConventionMapping taskMapping = task.getConventionMapping();
        taskMapping.map("classes", () -> {
            FileCollection presentClassDirs = sourceSet.getOutput().getClassesDirs().filter(File::exists);
            StreamSupport.stream(presentClassDirs.spliterator(), false).map(file -> this.project.fileTree(file)).forEach(tree -> tree.builtBy(new Object[]{sourceSet.getClassesTaskName()}));
            return presentClassDirs;
        });
        taskMapping.map("classpath", () -> ((SourceSet)sourceSet).getCompileClasspath());
    }
}

