/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.internal.spotbugs;

import com.github.spotbugs.SpotBugsReports;
import com.github.spotbugs.internal.SpotBugsReportsImpl;
import com.github.spotbugs.internal.spotbugs.SpotBugsSpec;
import com.github.spotbugs.internal.spotbugs.SpotBugsXmlReportImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.api.reporting.internal.CustomizableHtmlReportImpl;
import org.gradle.api.specs.Spec;
import org.gradle.util.CollectionUtils;

public class SpotBugsSpecBuilder {
    private static final Set<String> VALID_EFFORTS = SpotBugsSpecBuilder.createImmutableSet("min", "default", "max");
    private static final Set<String> VALID_REPORT_LEVELS = SpotBugsSpecBuilder.createImmutableSet("experimental", "low", "medium", "high");
    private FileCollection pluginsList;
    private FileCollection sources;
    private FileCollection classpath;
    private FileCollection classes;
    private SpotBugsReports reports;
    private String effort;
    private String reportLevel;
    private String maxHeapSize;
    private Collection<String> visitors;
    private Collection<String> omitVisitors;
    private File excludeFilter;
    private File includeFilter;
    private File excludeBugsFilter;
    private Collection<String> extraArgs;
    private boolean showProgress;
    private boolean debugEnabled;

    public SpotBugsSpecBuilder(FileCollection classes) {
        if (classes == null || classes.isEmpty()) {
            throw new InvalidUserDataException("No classes configured for SpotBugs analysis.");
        }
        this.classes = classes;
    }

    public SpotBugsSpecBuilder withPluginsList(FileCollection pluginsClasspath) {
        this.pluginsList = pluginsClasspath;
        return this;
    }

    public SpotBugsSpecBuilder withSources(FileCollection sources) {
        this.sources = sources;
        return this;
    }

    public SpotBugsSpecBuilder withClasspath(FileCollection classpath) {
        this.classpath = classpath;
        return this;
    }

    public SpotBugsSpecBuilder configureReports(SpotBugsReports reports) {
        this.reports = reports;
        return this;
    }

    public SpotBugsSpecBuilder withEffort(String effort) {
        if (effort != null && !VALID_EFFORTS.contains(effort)) {
            throw new InvalidUserDataException("Invalid value for SpotBugs 'effort' property: " + effort);
        }
        this.effort = effort;
        return this;
    }

    public SpotBugsSpecBuilder withReportLevel(String reportLevel) {
        if (reportLevel != null && !VALID_REPORT_LEVELS.contains(reportLevel)) {
            throw new InvalidUserDataException("Invalid value for SpotBugs 'reportLevel' property: " + reportLevel);
        }
        this.reportLevel = reportLevel;
        return this;
    }

    public SpotBugsSpecBuilder withMaxHeapSize(String maxHeapSize) {
        this.maxHeapSize = maxHeapSize;
        return this;
    }

    public SpotBugsSpecBuilder withVisitors(Collection<String> visitors) {
        this.visitors = visitors;
        return this;
    }

    public SpotBugsSpecBuilder withOmitVisitors(Collection<String> omitVisitors) {
        this.omitVisitors = omitVisitors;
        return this;
    }

    public SpotBugsSpecBuilder withExcludeFilter(File excludeFilter) {
        if (excludeFilter != null && !excludeFilter.canRead()) {
            String errorStr = String.format("Cannot read file specified for SpotBugs 'excludeFilter' property: %s", excludeFilter);
            throw new InvalidUserDataException(errorStr);
        }
        this.excludeFilter = excludeFilter;
        return this;
    }

    public SpotBugsSpecBuilder withIncludeFilter(File includeFilter) {
        if (includeFilter != null && !includeFilter.canRead()) {
            String errorStr = String.format("Cannot read file specified for SpotBugs 'includeFilter' property: %s", includeFilter);
            throw new InvalidUserDataException(errorStr);
        }
        this.includeFilter = includeFilter;
        return this;
    }

    public SpotBugsSpecBuilder withExcludeBugsFilter(File excludeBugsFilter) {
        if (excludeBugsFilter != null && !excludeBugsFilter.canRead()) {
            String errorStr = String.format("Cannot read file specified for SpotBugs 'excludeBugsFilter' property: %s", excludeBugsFilter);
            throw new InvalidUserDataException(errorStr);
        }
        this.excludeBugsFilter = excludeBugsFilter;
        return this;
    }

    public SpotBugsSpecBuilder withExtraArgs(Collection<String> extraArgs) {
        this.extraArgs = extraArgs;
        return this;
    }

    public SpotBugsSpecBuilder withShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
        return this;
    }

    public SpotBugsSpecBuilder withDebugging(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
        return this;
    }

    public SpotBugsSpec build() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-pluginList");
        args.add(this.pluginsList == null ? "" : this.pluginsList.getAsPath());
        args.add("-sortByClass");
        args.add("-timestampNow");
        if (this.showProgress) {
            args.add("-progress");
        }
        if (this.reports != null && !this.reports.getEnabled().isEmpty()) {
            if (this.reports.getEnabled().size() == 1) {
                SpotBugsXmlReportImpl r;
                SpotBugsReportsImpl reportsImpl = (SpotBugsReportsImpl)this.reports;
                String outputArg = "-" + ((SingleFileReport)reportsImpl.getFirstEnabled()).getName();
                if (reportsImpl.getFirstEnabled() instanceof SpotBugsXmlReportImpl) {
                    r = (SpotBugsXmlReportImpl)reportsImpl.getFirstEnabled();
                    if (r.isWithMessages()) {
                        outputArg = outputArg + ":withMessages";
                    }
                } else if (reportsImpl.getFirstEnabled() instanceof CustomizableHtmlReportImpl && (r = (CustomizableHtmlReportImpl)reportsImpl.getFirstEnabled()).getStylesheet() != null) {
                    outputArg = outputArg + ':' + r.getStylesheet().asFile().getAbsolutePath();
                }
                args.add(outputArg);
                args.add("-outputFile");
                args.add(((SingleFileReport)reportsImpl.getFirstEnabled()).getDestination().getAbsolutePath());
            } else {
                throw new InvalidUserDataException("SpotBugs tasks can only have one report enabled, however more than one report was enabled. You need to disable all but one of them.");
            }
        }
        if (this.has(this.sources)) {
            args.add("-sourcepath");
            args.add(this.sources.getAsPath());
        }
        if (this.has(this.classpath)) {
            args.add("-auxclasspath");
            args.add(this.classpath.filter((Spec)new Spec<File>(){

                public boolean isSatisfiedBy(File element) {
                    return element.exists();
                }
            }).getAsPath());
        }
        if (this.has(this.effort)) {
            args.add(String.format("-effort:%s", this.effort));
        }
        if (this.has(this.reportLevel)) {
            args.add(String.format("-%s", this.reportLevel));
        }
        if (this.has(this.visitors)) {
            args.add("-visitors");
            args.add(CollectionUtils.join((String)",", this.visitors));
        }
        if (this.has(this.omitVisitors)) {
            args.add("-omitVisitors");
            args.add(CollectionUtils.join((String)",", this.omitVisitors));
        }
        if (this.has(this.excludeFilter)) {
            args.add("-exclude");
            args.add(this.excludeFilter.getPath());
        }
        if (this.has(this.includeFilter)) {
            args.add("-include");
            args.add(this.includeFilter.getPath());
        }
        if (this.has(this.excludeBugsFilter)) {
            args.add("-excludeBugs");
            args.add(this.excludeBugsFilter.getPath());
        }
        if (this.has(this.extraArgs)) {
            args.addAll(this.extraArgs);
        }
        for (File classFile : this.classes.getFiles()) {
            args.add(classFile.getAbsolutePath());
        }
        return new SpotBugsSpec(args, this.maxHeapSize, this.debugEnabled);
    }

    private boolean has(String str) {
        return str != null && str.length() > 0;
    }

    private boolean has(File file) {
        return file != null && file.canRead();
    }

    private boolean has(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    private boolean has(FileCollection fileCollection) {
        return fileCollection != null && !fileCollection.isEmpty();
    }

    private static final Set<String> createImmutableSet(String ... strings) {
        Set set = Arrays.asList(strings).stream().collect(Collectors.toSet());
        return Collections.unmodifiableSet(set);
    }
}

