/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.anttask;

import edu.umd.cs.findbugs.anttask.AbstractFindBugsTask;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileSet;

public class UnionBugs2
extends AbstractFindBugsTask {
    private String to;
    private final ArrayList<FileSet> fileSets = new ArrayList();

    public UnionBugs2() {
        super("edu.umd.cs.findbugs.workflow.UnionResults");
        this.setFailOnError(true);
    }

    public void addFileset(FileSet arg) {
        this.fileSets.add(arg);
    }

    public void setTo(String arg) {
        this.to = arg;
    }

    @Override
    protected void checkParameters() {
        super.checkParameters();
        if (this.to == null) {
            throw new BuildException("to attribute is required", this.getLocation());
        }
        if (this.fileSets.isEmpty()) {
            throw new BuildException("fileset is required");
        }
    }

    @Override
    protected void beforeExecuteJavaProcess() {
        this.log("unioning bugs...");
    }

    @Override
    protected void configureFindbugsEngine() {
        Path tempFile;
        this.addArg("-withMessages");
        this.addArg("-output");
        this.addArg(this.to);
        StringBuilder builder = new StringBuilder();
        for (FileSet s : this.fileSets) {
            File fromDir = s.getDir(this.getProject());
            for (String file : s.getDirectoryScanner(this.getProject()).getIncludedFiles()) {
                builder.append(new File(fromDir, file)).append("\n");
            }
        }
        try {
            tempFile = Files.createTempFile("spotbugs-argument-file", ".txt", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new BuildException("unable to create temporary argument file", (Throwable)e);
        }
        String pathAsString = tempFile.toAbsolutePath().toString();
        try (PrintWriter writer = new PrintWriter(tempFile.toFile(), "UTF-8");){
            writer.print(builder);
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            throw new BuildException(String.format("unable to write to temporary argument file: '%s'", pathAsString), (Throwable)e);
        }
        this.addArg(pathAsString);
    }
}

