/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.snom.internal;

import com.github.spotbugs.snom.SpotBugsTask;
import com.github.spotbugs.snom.internal.OutputScanner;
import com.github.spotbugs.snom.internal.SpotBugsRunner;
import com.github.spotbugs.snom.internal.SpotBugsRunnerForJavaExec;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.provider.Property;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.process.ExecOperations;
import org.gradle.process.JavaExecSpec;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/github/spotbugs/snom/internal/SpotBugsRunnerForJavaExec;", "Lcom/github/spotbugs/snom/internal/SpotBugsRunner;", "execOps", "Lorg/gradle/process/ExecOperations;", "javaLauncher", "Lorg/gradle/api/provider/Property;", "Lorg/gradle/jvm/toolchain/JavaLauncher;", "<init>", "(Lorg/gradle/process/ExecOperations;Lorg/gradle/api/provider/Property;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "stderrOutputScanner", "Lcom/github/spotbugs/snom/internal/OutputScanner;", "run", "", "task", "Lcom/github/spotbugs/snom/SpotBugsTask;", "configureJavaExec", "Lorg/gradle/api/Action;", "Lorg/gradle/process/JavaExecSpec;", "spotbugs-gradle-plugin"})
public final class SpotBugsRunnerForJavaExec
extends SpotBugsRunner {
    @NotNull
    private final ExecOperations execOps;
    @NotNull
    private final Property<JavaLauncher> javaLauncher;
    private final Logger log;
    private OutputScanner stderrOutputScanner;

    @Inject
    public SpotBugsRunnerForJavaExec(@NotNull ExecOperations execOps, @NotNull Property<JavaLauncher> javaLauncher) {
        Intrinsics.checkNotNullParameter((Object)execOps, (String)"execOps");
        Intrinsics.checkNotNullParameter(javaLauncher, (String)"javaLauncher");
        this.execOps = execOps;
        this.javaLauncher = javaLauncher;
        this.log = LoggerFactory.getLogger(SpotBugsRunnerForJavaExec.class);
    }

    @Override
    public void run(@NotNull SpotBugsTask task) {
        Intrinsics.checkNotNullParameter((Object)((Object)task), (String)"task");
        try {
            this.execOps.javaexec(this.configureJavaExec(task)).rethrowFailure().assertNormalExitValue();
            OutputScanner outputScanner = this.stderrOutputScanner;
            if (outputScanner == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"stderrOutputScanner");
                outputScanner = null;
            }
            if (outputScanner.isFailedToReport() && !task.getIgnoreFailures()) {
                throw new GradleException("SpotBugs analysis succeeded but report generation failed");
            }
        }
        catch (GradleException e) {
            StringBuilder stringBuilder;
            if (task.getIgnoreFailures()) {
                this.log.warn("SpotBugs reported failures", (Throwable)((Boolean)task.getShowStackTraces().get() != false ? e : null));
            }
            StringBuilder $this$run_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$run_u24lambda_u240.append("Verification failed: SpotBugs execution thrown exception.");
            List reportPaths2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.map(task.getRequiredReports$spotbugs_gradle_plugin(), (Function1)run.errorMessage.1.reportPaths.1.INSTANCE), (Function1)run.errorMessage.1.reportPaths.2.INSTANCE), (Function1)run.errorMessage.1.reportPaths.3.INSTANCE), (Function1)run.errorMessage.1.reportPaths.4.INSTANCE), (Function1)run.errorMessage.1.reportPaths.5.INSTANCE), (Function1)run.errorMessage.1.reportPaths.6.INSTANCE));
            if (!((Collection)reportPaths2).isEmpty()) {
                $this$run_u24lambda_u240.append("See the report at: ");
                $this$run_u24lambda_u240.append(CollectionsKt.joinToString$default((Iterable)reportPaths2, null, null, null, (int)0, null, null, (int)63, null));
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String errorMessage2 = string;
            throw new GradleException(errorMessage2, (Throwable)e);
        }
    }

    private final Action<JavaExecSpec> configureJavaExec(SpotBugsTask task) {
        return arg_0 -> SpotBugsRunnerForJavaExec.configureJavaExec$lambda$1(this, task, arg_0);
    }

    private static final void configureJavaExec$lambda$1(SpotBugsRunnerForJavaExec this$0, SpotBugsTask $task, JavaExecSpec it) {
        List args = new ArrayList();
        args.add("-exitcode");
        args.addAll((Collection)this$0.buildArguments($task));
        Object[] objectArray = new Object[]{$task.getSpotbugsClasspath()};
        it.classpath(objectArray);
        it.setJvmArgs(this$0.buildJvmArguments($task));
        it.getMainClass().set((Object)"edu.umd.cs.findbugs.FindBugs2");
        it.setArgs(args);
        String maxHeapSize = (String)$task.getMaxHeapSize().getOrNull();
        if (maxHeapSize != null) {
            it.setMaxHeapSize(maxHeapSize);
        }
        PrintStream printStream = System.err;
        Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"err");
        this$0.stderrOutputScanner = new OutputScanner(printStream);
        OutputScanner outputScanner = this$0.stderrOutputScanner;
        if (outputScanner == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"stderrOutputScanner");
            outputScanner = null;
        }
        it.setErrorOutput((OutputStream)outputScanner);
        if (this$0.javaLauncher.isPresent()) {
            this$0.log.info("Spotbugs will be executed using Java Toolchain configuration: Vendor: {} | Version: {}", (Object)((JavaLauncher)this$0.javaLauncher.get()).getMetadata().getVendor(), (Object)((JavaLauncher)this$0.javaLauncher.get()).getMetadata().getLanguageVersion().asInt());
            it.setExecutable(((JavaLauncher)this$0.javaLauncher.get()).getExecutablePath().getAsFile().getAbsolutePath());
        }
    }
}

