/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.snom;

import com.github.spotbugs.snom.SpotBugsExtension;
import com.github.spotbugs.snom.SpotBugsPlugin;
import com.github.spotbugs.snom.SpotBugsTask;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Properties;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.util.GradleVersion;

public class SpotBugsBasePlugin
implements Plugin<Project> {
    private static final String FEATURE_FLAG_WORKER_API = "com.github.spotbugs.snom.worker";
    private static final String FEATURE_FLAG_HYBRID_WORKER = "com.github.spotbugs.snom.javaexec-in-worker";
    private static final GradleVersion SUPPORTED_VERSION = GradleVersion.version((String)"7.0");

    public void apply(Project project) {
        this.verifyGradleVersion(GradleVersion.current());
        project.getPluginManager().apply(ReportingBasePlugin.class);
        SpotBugsExtension extension = this.createExtension(project);
        this.createConfiguration(project, extension);
        this.createPluginConfiguration(project.getConfigurations());
        String enableWorkerApi = this.getPropertyOrDefault(project, FEATURE_FLAG_WORKER_API, "true");
        String enableHybridWorker = this.getPropertyOrDefault(project, FEATURE_FLAG_HYBRID_WORKER, "true");
        project.getTasks().withType(SpotBugsTask.class).configureEach(task -> task.init(extension, Boolean.parseBoolean(enableWorkerApi), Boolean.parseBoolean(enableHybridWorker)));
    }

    private SpotBugsExtension createExtension(Project project) {
        return (SpotBugsExtension)project.getExtensions().create("spotbugs", SpotBugsExtension.class, new Object[]{project, project.getObjects()});
    }

    private void createConfiguration(Project project, SpotBugsExtension extension) {
        Properties props = this.loadProperties();
        extension.getToolVersion().convention((Object)props.getProperty("spotbugs-version"));
        ConfigurationContainer configs = project.getConfigurations();
        configs.register("spotbugs", c -> {
            c.setDescription("configuration for the SpotBugs engine");
            c.setVisible(false);
            c.setTransitive(true);
            c.defaultDependencies(d -> {
                Dependency dep = project.getDependencies().create((Object)("com.github.spotbugs:spotbugs:" + (String)extension.getToolVersion().get()));
                d.add((Object)dep);
            });
        });
        configs.register("spotbugsSlf4j", c -> {
            c.setDescription("configuration for the SLF4J provider to run SpotBugs");
            c.setVisible(false);
            c.setTransitive(true);
            c.defaultDependencies(d -> {
                Dependency dep = project.getDependencies().create((Object)("org.slf4j:slf4j-simple:" + props.getProperty("slf4j-version")));
                d.add((Object)dep);
            });
        });
    }

    Properties loadProperties() {
        Properties properties;
        block8: {
            URL url = SpotBugsPlugin.class.getClassLoader().getResource("spotbugs-gradle-plugin.properties");
            InputStream input = url.openStream();
            try {
                Properties prop = new Properties();
                prop.load(input);
                properties = prop;
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            input.close();
        }
        return properties;
    }

    private void createPluginConfiguration(ConfigurationContainer configs) {
        configs.register("spotbugsPlugins", c -> {
            c.setDescription("configuration for the external SpotBugs plugins");
            c.setVisible(false);
            c.setTransitive(false);
        });
    }

    void verifyGradleVersion(GradleVersion version) {
        if (version.compareTo(SUPPORTED_VERSION) < 0) {
            String message = String.format("Gradle version %s is unsupported. Please use %s or later.", version, SUPPORTED_VERSION);
            throw new IllegalArgumentException(message);
        }
    }

    private String getPropertyOrDefault(Project project, String propertyName, String defaultValue) {
        return project.hasProperty(propertyName) ? project.property(propertyName).toString() : defaultValue;
    }
}

