/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.snom.internal;

import com.github.spotbugs.snom.SpotBugsReport;
import com.github.spotbugs.snom.SpotBugsTask;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Optional;
import javax.inject.Inject;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.resources.TextResource;
import org.gradle.api.resources.TextResourceFactory;

public abstract class SpotBugsHtmlReport
extends SpotBugsReport {
    private final Property<TextResource> stylesheet;

    @Inject
    public SpotBugsHtmlReport(ObjectFactory objects, SpotBugsTask task) {
        super(objects, task);
        this.getOutputLocation().convention(task.getReportsDir().file(task.getBaseName() + ".html"));
        this.stylesheet = objects.property(TextResource.class);
    }

    @Override
    @NonNull
    public String toCommandLineOption() {
        return (String)this.stylesheet.map(textResource -> "-html:" + textResource.asFile().getAbsolutePath()).getOrElse((Object)"-html");
    }

    @Override
    public TextResource getStylesheet() {
        return (TextResource)this.stylesheet.getOrNull();
    }

    private TextResource resolve(String path, Configuration configuration, TextResourceFactory factory) {
        Optional spotbugsJar = configuration.files(dependency -> dependency.getGroup().equals("com.github.spotbugs") && dependency.getName().equals("spotbugs")).stream().findFirst();
        if (spotbugsJar.isPresent()) {
            return factory.fromArchiveEntry(spotbugsJar.get(), path);
        }
        throw new InvalidUserDataException("The dependency on SpotBugs not found in 'spotbugs' configuration");
    }

    @Override
    public void setStylesheet(@Nullable TextResource textResource) {
        this.stylesheet.set((Object)textResource);
    }

    @Override
    public void setStylesheet(@Nullable String path) {
        Configuration configuration = this.getTask().getProject().getConfigurations().getByName("spotbugs");
        TextResourceFactory factory = this.getTask().getProject().getResources().getText();
        this.stylesheet.set(this.getTask().getProject().provider(() -> this.resolve(path, configuration, factory)));
    }
}

