/*
 * Decompiled with CFR 0.152.
 */
package com.viewpagerindicator;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.ViewConfigurationCompat;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import com.viewpagerindicator.PageIndicator;
import com.viewpagerindicator.R;
import java.util.ArrayList;

public class TitlePageIndicator
extends View
implements PageIndicator {
    private static final float SELECTION_FADE_PERCENTAGE = 0.25f;
    private static final float BOLD_FADE_PERCENTAGE = 0.05f;
    private static final String EMPTY_TITLE = "";
    private ViewPager mViewPager;
    private ViewPager.OnPageChangeListener mListener;
    private int mCurrentPage = -1;
    private float mPageOffset;
    private int mScrollState;
    private final Paint mPaintText = new Paint();
    private boolean mBoldText;
    private int mColorText;
    private int mColorSelected;
    private Path mPath = new Path();
    private final Rect mBounds = new Rect();
    private final Paint mPaintFooterLine = new Paint();
    private IndicatorStyle mFooterIndicatorStyle;
    private LinePosition mLinePosition;
    private final Paint mPaintFooterIndicator = new Paint();
    private float mFooterIndicatorHeight;
    private float mFooterIndicatorUnderlinePadding;
    private float mFooterPadding;
    private float mTitlePadding;
    private float mTopPadding;
    private float mClipPadding;
    private float mFooterLineHeight;
    private static final int INVALID_POINTER = -1;
    private int mTouchSlop;
    private float mLastMotionX = -1.0f;
    private int mActivePointerId = -1;
    private boolean mIsDragging;
    private OnCenterItemClickListener mCenterItemClickListener;

    public TitlePageIndicator(Context context) {
        this(context, null);
    }

    public TitlePageIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.vpiTitlePageIndicatorStyle);
    }

    public TitlePageIndicator(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (this.isInEditMode()) {
            return;
        }
        Resources res = this.getResources();
        int defaultFooterColor = res.getColor(R.color.default_title_indicator_footer_color);
        float defaultFooterLineHeight = res.getDimension(R.dimen.default_title_indicator_footer_line_height);
        int defaultFooterIndicatorStyle = res.getInteger(R.integer.default_title_indicator_footer_indicator_style);
        float defaultFooterIndicatorHeight = res.getDimension(R.dimen.default_title_indicator_footer_indicator_height);
        float defaultFooterIndicatorUnderlinePadding = res.getDimension(R.dimen.default_title_indicator_footer_indicator_underline_padding);
        float defaultFooterPadding = res.getDimension(R.dimen.default_title_indicator_footer_padding);
        int defaultLinePosition = res.getInteger(R.integer.default_title_indicator_line_position);
        int defaultSelectedColor = res.getColor(R.color.default_title_indicator_selected_color);
        boolean defaultSelectedBold = res.getBoolean(R.bool.default_title_indicator_selected_bold);
        int defaultTextColor = res.getColor(R.color.default_title_indicator_text_color);
        float defaultTextSize = res.getDimension(R.dimen.default_title_indicator_text_size);
        float defaultTitlePadding = res.getDimension(R.dimen.default_title_indicator_title_padding);
        float defaultClipPadding = res.getDimension(R.dimen.default_title_indicator_clip_padding);
        float defaultTopPadding = res.getDimension(R.dimen.default_title_indicator_top_padding);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TitlePageIndicator, defStyle, 0);
        this.mFooterLineHeight = a.getDimension(R.styleable.TitlePageIndicator_footerLineHeight, defaultFooterLineHeight);
        this.mFooterIndicatorStyle = IndicatorStyle.fromValue(a.getInteger(R.styleable.TitlePageIndicator_footerIndicatorStyle, defaultFooterIndicatorStyle));
        this.mFooterIndicatorHeight = a.getDimension(R.styleable.TitlePageIndicator_footerIndicatorHeight, defaultFooterIndicatorHeight);
        this.mFooterIndicatorUnderlinePadding = a.getDimension(R.styleable.TitlePageIndicator_footerIndicatorUnderlinePadding, defaultFooterIndicatorUnderlinePadding);
        this.mFooterPadding = a.getDimension(R.styleable.TitlePageIndicator_footerPadding, defaultFooterPadding);
        this.mLinePosition = LinePosition.fromValue(a.getInteger(R.styleable.TitlePageIndicator_linePosition, defaultLinePosition));
        this.mTopPadding = a.getDimension(R.styleable.TitlePageIndicator_topPadding, defaultTopPadding);
        this.mTitlePadding = a.getDimension(R.styleable.TitlePageIndicator_titlePadding, defaultTitlePadding);
        this.mClipPadding = a.getDimension(R.styleable.TitlePageIndicator_clipPadding, defaultClipPadding);
        this.mColorSelected = a.getColor(R.styleable.TitlePageIndicator_selectedColor, defaultSelectedColor);
        this.mColorText = a.getColor(R.styleable.TitlePageIndicator_android_textColor, defaultTextColor);
        this.mBoldText = a.getBoolean(R.styleable.TitlePageIndicator_selectedBold, defaultSelectedBold);
        float textSize = a.getDimension(R.styleable.TitlePageIndicator_android_textSize, defaultTextSize);
        int footerColor = a.getColor(R.styleable.TitlePageIndicator_footerColor, defaultFooterColor);
        this.mPaintText.setTextSize(textSize);
        this.mPaintText.setAntiAlias(true);
        this.mPaintFooterLine.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mPaintFooterLine.setStrokeWidth(this.mFooterLineHeight);
        this.mPaintFooterLine.setColor(footerColor);
        this.mPaintFooterIndicator.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mPaintFooterIndicator.setColor(footerColor);
        Drawable background = a.getDrawable(R.styleable.TitlePageIndicator_android_background);
        if (background != null) {
            this.setBackgroundDrawable(background);
        }
        a.recycle();
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.mTouchSlop = ViewConfigurationCompat.getScaledPagingTouchSlop((ViewConfiguration)configuration);
    }

    public int getFooterColor() {
        return this.mPaintFooterLine.getColor();
    }

    public void setFooterColor(int footerColor) {
        this.mPaintFooterLine.setColor(footerColor);
        this.mPaintFooterIndicator.setColor(footerColor);
        this.invalidate();
    }

    public float getFooterLineHeight() {
        return this.mFooterLineHeight;
    }

    public void setFooterLineHeight(float footerLineHeight) {
        this.mFooterLineHeight = footerLineHeight;
        this.mPaintFooterLine.setStrokeWidth(this.mFooterLineHeight);
        this.invalidate();
    }

    public float getFooterIndicatorHeight() {
        return this.mFooterIndicatorHeight;
    }

    public void setFooterIndicatorHeight(float footerTriangleHeight) {
        this.mFooterIndicatorHeight = footerTriangleHeight;
        this.invalidate();
    }

    public float getFooterIndicatorPadding() {
        return this.mFooterPadding;
    }

    public void setFooterIndicatorPadding(float footerIndicatorPadding) {
        this.mFooterPadding = footerIndicatorPadding;
        this.invalidate();
    }

    public IndicatorStyle getFooterIndicatorStyle() {
        return this.mFooterIndicatorStyle;
    }

    public void setFooterIndicatorStyle(IndicatorStyle indicatorStyle) {
        this.mFooterIndicatorStyle = indicatorStyle;
        this.invalidate();
    }

    public LinePosition getLinePosition() {
        return this.mLinePosition;
    }

    public void setLinePosition(LinePosition linePosition) {
        this.mLinePosition = linePosition;
        this.invalidate();
    }

    public int getSelectedColor() {
        return this.mColorSelected;
    }

    public void setSelectedColor(int selectedColor) {
        this.mColorSelected = selectedColor;
        this.invalidate();
    }

    public boolean isSelectedBold() {
        return this.mBoldText;
    }

    public void setSelectedBold(boolean selectedBold) {
        this.mBoldText = selectedBold;
        this.invalidate();
    }

    public int getTextColor() {
        return this.mColorText;
    }

    public void setTextColor(int textColor) {
        this.mPaintText.setColor(textColor);
        this.mColorText = textColor;
        this.invalidate();
    }

    public float getTextSize() {
        return this.mPaintText.getTextSize();
    }

    public void setTextSize(float textSize) {
        this.mPaintText.setTextSize(textSize);
        this.invalidate();
    }

    public float getTitlePadding() {
        return this.mTitlePadding;
    }

    public void setTitlePadding(float titlePadding) {
        this.mTitlePadding = titlePadding;
        this.invalidate();
    }

    public float getTopPadding() {
        return this.mTopPadding;
    }

    public void setTopPadding(float topPadding) {
        this.mTopPadding = topPadding;
        this.invalidate();
    }

    public float getClipPadding() {
        return this.mClipPadding;
    }

    public void setClipPadding(float clipPadding) {
        this.mClipPadding = clipPadding;
        this.invalidate();
    }

    public void setTypeface(Typeface typeface) {
        this.mPaintText.setTypeface(typeface);
        this.invalidate();
    }

    public Typeface getTypeface() {
        return this.mPaintText.getTypeface();
    }

    protected void onDraw(Canvas canvas) {
        int w;
        Rect bound;
        int i;
        float offsetPercent;
        ArrayList<Rect> bounds;
        int boundsSize;
        super.onDraw(canvas);
        if (this.mViewPager == null) {
            return;
        }
        int count = this.mViewPager.getAdapter().getCount();
        if (count == 0) {
            return;
        }
        if (this.mCurrentPage == -1 && this.mViewPager != null) {
            this.mCurrentPage = this.mViewPager.getCurrentItem();
        }
        if (this.mCurrentPage >= (boundsSize = (bounds = this.calculateAllBounds(this.mPaintText)).size())) {
            this.setCurrentItem(boundsSize - 1);
            return;
        }
        int countMinusOne = count - 1;
        float halfWidth = (float)this.getWidth() / 2.0f;
        int left = this.getLeft();
        float leftClip = (float)left + this.mClipPadding;
        int width = this.getWidth();
        int height = this.getHeight();
        int right = left + width;
        float rightClip = (float)right - this.mClipPadding;
        int page = this.mCurrentPage;
        if ((double)this.mPageOffset <= 0.5) {
            offsetPercent = this.mPageOffset;
        } else {
            ++page;
            offsetPercent = 1.0f - this.mPageOffset;
        }
        boolean currentSelected = offsetPercent <= 0.25f;
        boolean currentBold = offsetPercent <= 0.05f;
        float selectedPercent = (0.25f - offsetPercent) / 0.25f;
        Rect curPageBound = bounds.get(this.mCurrentPage);
        float curPageWidth = curPageBound.right - curPageBound.left;
        if ((float)curPageBound.left < leftClip) {
            this.clipViewOnTheLeft(curPageBound, curPageWidth, left);
        }
        if ((float)curPageBound.right > rightClip) {
            this.clipViewOnTheRight(curPageBound, curPageWidth, right);
        }
        if (this.mCurrentPage > 0) {
            for (i = this.mCurrentPage - 1; i >= 0; --i) {
                bound = bounds.get(i);
                if (!((float)bound.left < leftClip)) continue;
                w = bound.right - bound.left;
                this.clipViewOnTheLeft(bound, w, left);
                Rect rightBound = bounds.get(i + 1);
                if (!((float)bound.right + this.mTitlePadding > (float)rightBound.left)) continue;
                bound.left = (int)((float)(rightBound.left - w) - this.mTitlePadding);
                bound.right = bound.left + w;
            }
        }
        if (this.mCurrentPage < countMinusOne) {
            for (i = this.mCurrentPage + 1; i < count; ++i) {
                bound = bounds.get(i);
                if (!((float)bound.right > rightClip)) continue;
                w = bound.right - bound.left;
                this.clipViewOnTheRight(bound, w, right);
                Rect leftBound = bounds.get(i - 1);
                if (!((float)bound.left - this.mTitlePadding < (float)leftBound.right)) continue;
                bound.left = (int)((float)leftBound.right + this.mTitlePadding);
                bound.right = bound.left + w;
            }
        }
        int colorTextAlpha = this.mColorText >>> 24;
        for (int i2 = 0; i2 < count; ++i2) {
            Rect bound2 = bounds.get(i2);
            if ((bound2.left <= left || bound2.left >= right) && (bound2.right <= left || bound2.right >= right)) continue;
            boolean currentPage = i2 == page;
            CharSequence pageTitle = this.getTitle(i2);
            this.mPaintText.setFakeBoldText(currentPage && currentBold && this.mBoldText);
            this.mPaintText.setColor(this.mColorText);
            if (currentPage && currentSelected) {
                this.mPaintText.setAlpha(colorTextAlpha - (int)((float)colorTextAlpha * selectedPercent));
            }
            if (i2 < boundsSize - 1) {
                Rect rightBound = bounds.get(i2 + 1);
                if ((float)bound2.right + this.mTitlePadding > (float)rightBound.left) {
                    int w2 = bound2.right - bound2.left;
                    bound2.left = (int)((float)(rightBound.left - w2) - this.mTitlePadding);
                    bound2.right = bound2.left + w2;
                }
            }
            canvas.drawText(pageTitle, 0, pageTitle.length(), (float)bound2.left, (float)bound2.bottom + this.mTopPadding, this.mPaintText);
            if (!currentPage || !currentSelected) continue;
            this.mPaintText.setColor(this.mColorSelected);
            this.mPaintText.setAlpha((int)((float)(this.mColorSelected >>> 24) * selectedPercent));
            canvas.drawText(pageTitle, 0, pageTitle.length(), (float)bound2.left, (float)bound2.bottom + this.mTopPadding, this.mPaintText);
        }
        float footerLineHeight = this.mFooterLineHeight;
        float footerIndicatorLineHeight = this.mFooterIndicatorHeight;
        if (this.mLinePosition == LinePosition.Top) {
            height = 0;
            footerLineHeight = -footerLineHeight;
            footerIndicatorLineHeight = -footerIndicatorLineHeight;
        }
        this.mPath.reset();
        this.mPath.moveTo(0.0f, (float)height - footerLineHeight / 2.0f);
        this.mPath.lineTo((float)width, (float)height - footerLineHeight / 2.0f);
        this.mPath.close();
        canvas.drawPath(this.mPath, this.mPaintFooterLine);
        float heightMinusLine = (float)height - footerLineHeight;
        switch (this.mFooterIndicatorStyle) {
            case Triangle: {
                this.mPath.reset();
                this.mPath.moveTo(halfWidth, heightMinusLine - footerIndicatorLineHeight);
                this.mPath.lineTo(halfWidth + footerIndicatorLineHeight, heightMinusLine);
                this.mPath.lineTo(halfWidth - footerIndicatorLineHeight, heightMinusLine);
                this.mPath.close();
                canvas.drawPath(this.mPath, this.mPaintFooterIndicator);
                break;
            }
            case Underline: {
                if (!currentSelected || page >= boundsSize) break;
                Rect underlineBounds = bounds.get(page);
                float rightPlusPadding = (float)underlineBounds.right + this.mFooterIndicatorUnderlinePadding;
                float leftMinusPadding = (float)underlineBounds.left - this.mFooterIndicatorUnderlinePadding;
                float heightMinusLineMinusIndicator = heightMinusLine - footerIndicatorLineHeight;
                this.mPath.reset();
                this.mPath.moveTo(leftMinusPadding, heightMinusLine);
                this.mPath.lineTo(rightPlusPadding, heightMinusLine);
                this.mPath.lineTo(rightPlusPadding, heightMinusLineMinusIndicator);
                this.mPath.lineTo(leftMinusPadding, heightMinusLineMinusIndicator);
                this.mPath.close();
                this.mPaintFooterIndicator.setAlpha((int)(255.0f * selectedPercent));
                canvas.drawPath(this.mPath, this.mPaintFooterIndicator);
                this.mPaintFooterIndicator.setAlpha(255);
            }
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (super.onTouchEvent(ev)) {
            return true;
        }
        if (this.mViewPager == null || this.mViewPager.getAdapter().getCount() == 0) {
            return false;
        }
        int action = ev.getAction() & 0xFF;
        switch (action) {
            case 0: {
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
                this.mLastMotionX = ev.getX();
                break;
            }
            case 2: {
                int activePointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId);
                float x = MotionEventCompat.getX((MotionEvent)ev, (int)activePointerIndex);
                float deltaX = x - this.mLastMotionX;
                if (!this.mIsDragging && Math.abs(deltaX) > (float)this.mTouchSlop) {
                    this.mIsDragging = true;
                }
                if (!this.mIsDragging) break;
                this.mLastMotionX = x;
                if (!this.mViewPager.isFakeDragging() && !this.mViewPager.beginFakeDrag()) break;
                this.mViewPager.fakeDragBy(deltaX);
                break;
            }
            case 1: 
            case 3: {
                if (!this.mIsDragging) {
                    int count = this.mViewPager.getAdapter().getCount();
                    int width = this.getWidth();
                    float halfWidth = (float)width / 2.0f;
                    float sixthWidth = (float)width / 6.0f;
                    float leftThird = halfWidth - sixthWidth;
                    float rightThird = halfWidth + sixthWidth;
                    float eventX = ev.getX();
                    if (eventX < leftThird) {
                        if (this.mCurrentPage > 0) {
                            if (action != 3) {
                                this.mViewPager.setCurrentItem(this.mCurrentPage - 1);
                            }
                            return true;
                        }
                    } else if (eventX > rightThird) {
                        if (this.mCurrentPage < count - 1) {
                            if (action != 3) {
                                this.mViewPager.setCurrentItem(this.mCurrentPage + 1);
                            }
                            return true;
                        }
                    } else if (this.mCenterItemClickListener != null && action != 3) {
                        this.mCenterItemClickListener.onCenterItemClick(this.mCurrentPage);
                    }
                }
                this.mIsDragging = false;
                this.mActivePointerId = -1;
                if (!this.mViewPager.isFakeDragging()) break;
                this.mViewPager.endFakeDrag();
                break;
            }
            case 5: {
                int index = MotionEventCompat.getActionIndex((MotionEvent)ev);
                this.mLastMotionX = MotionEventCompat.getX((MotionEvent)ev, (int)index);
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)index);
                break;
            }
            case 6: {
                int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
                int pointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)pointerIndex);
                if (pointerId == this.mActivePointerId) {
                    int newPointerIndex = pointerIndex == 0 ? 1 : 0;
                    this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)newPointerIndex);
                }
                this.mLastMotionX = MotionEventCompat.getX((MotionEvent)ev, (int)MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId));
            }
        }
        return true;
    }

    private void clipViewOnTheRight(Rect curViewBound, float curViewWidth, int right) {
        curViewBound.right = (int)((float)right - this.mClipPadding);
        curViewBound.left = (int)((float)curViewBound.right - curViewWidth);
    }

    private void clipViewOnTheLeft(Rect curViewBound, float curViewWidth, int left) {
        curViewBound.left = (int)((float)left + this.mClipPadding);
        curViewBound.right = (int)(this.mClipPadding + curViewWidth);
    }

    private ArrayList<Rect> calculateAllBounds(Paint paint) {
        ArrayList<Rect> list = new ArrayList<Rect>();
        int count = this.mViewPager.getAdapter().getCount();
        int width = this.getWidth();
        int halfWidth = width / 2;
        for (int i = 0; i < count; ++i) {
            Rect bounds = this.calcBounds(i, paint);
            int w = bounds.right - bounds.left;
            int h = bounds.bottom - bounds.top;
            bounds.left = (int)((float)halfWidth - (float)w / 2.0f + ((float)(i - this.mCurrentPage) - this.mPageOffset) * (float)width);
            bounds.right = bounds.left + w;
            bounds.top = 0;
            bounds.bottom = h;
            list.add(bounds);
        }
        return list;
    }

    private Rect calcBounds(int index, Paint paint) {
        Rect bounds = new Rect();
        CharSequence title = this.getTitle(index);
        bounds.right = (int)paint.measureText(title, 0, title.length());
        bounds.bottom = (int)(paint.descent() - paint.ascent());
        return bounds;
    }

    @Override
    public void setViewPager(ViewPager view) {
        if (this.mViewPager == view) {
            return;
        }
        if (this.mViewPager != null) {
            this.mViewPager.setOnPageChangeListener(null);
        }
        if (view.getAdapter() == null) {
            throw new IllegalStateException("ViewPager does not have adapter instance.");
        }
        this.mViewPager = view;
        this.mViewPager.setOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.invalidate();
    }

    @Override
    public void setViewPager(ViewPager view, int initialPosition) {
        this.setViewPager(view);
        this.setCurrentItem(initialPosition);
    }

    @Override
    public void notifyDataSetChanged() {
        this.invalidate();
    }

    public void setOnCenterItemClickListener(OnCenterItemClickListener listener) {
        this.mCenterItemClickListener = listener;
    }

    @Override
    public void setCurrentItem(int item) {
        if (this.mViewPager == null) {
            throw new IllegalStateException("ViewPager has not been bound.");
        }
        this.mViewPager.setCurrentItem(item);
        this.mCurrentPage = item;
        this.invalidate();
    }

    public void onPageScrollStateChanged(int state) {
        this.mScrollState = state;
        if (this.mListener != null) {
            this.mListener.onPageScrollStateChanged(state);
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        this.mCurrentPage = position;
        this.mPageOffset = positionOffset;
        this.invalidate();
        if (this.mListener != null) {
            this.mListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
        }
    }

    public void onPageSelected(int position) {
        if (this.mScrollState == 0) {
            this.mCurrentPage = position;
            this.invalidate();
        }
        if (this.mListener != null) {
            this.mListener.onPageSelected(position);
        }
    }

    @Override
    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.mListener = listener;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        float height;
        int measuredWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (heightSpecMode == 0x40000000) {
            height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        } else {
            this.mBounds.setEmpty();
            this.mBounds.bottom = (int)(this.mPaintText.descent() - this.mPaintText.ascent());
            height = (float)(this.mBounds.bottom - this.mBounds.top) + this.mFooterLineHeight + this.mFooterPadding + this.mTopPadding;
            if (this.mFooterIndicatorStyle != IndicatorStyle.None) {
                height += this.mFooterIndicatorHeight;
            }
        }
        int measuredHeight = (int)height;
        this.setMeasuredDimension(measuredWidth, measuredHeight);
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mCurrentPage = savedState.currentPage;
        this.requestLayout();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.currentPage = this.mCurrentPage;
        return savedState;
    }

    private CharSequence getTitle(int i) {
        CharSequence title = this.mViewPager.getAdapter().getPageTitle(i);
        if (title == null) {
            title = EMPTY_TITLE;
        }
        return title;
    }

    static class SavedState
    extends View.BaseSavedState {
        int currentPage;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.currentPage = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.currentPage);
        }
    }

    public static enum LinePosition {
        Bottom(0),
        Top(1);

        public final int value;

        private LinePosition(int value) {
            this.value = value;
        }

        public static LinePosition fromValue(int value) {
            for (LinePosition position : LinePosition.values()) {
                if (position.value != value) continue;
                return position;
            }
            return null;
        }
    }

    public static enum IndicatorStyle {
        None(0),
        Triangle(1),
        Underline(2);

        public final int value;

        private IndicatorStyle(int value) {
            this.value = value;
        }

        public static IndicatorStyle fromValue(int value) {
            for (IndicatorStyle style : IndicatorStyle.values()) {
                if (style.value != value) continue;
                return style;
            }
            return null;
        }
    }

    public static interface OnCenterItemClickListener {
        public void onCenterItemClick(int var1);
    }
}

