/*
 * Decompiled with CFR 0.152.
 */
package com.github.sparkzxl.redisson.aspect;

import com.github.sparkzxl.redisson.annotation.RedisLock;
import com.github.sparkzxl.redisson.aspect.LockKeyGenerator;
import com.github.sparkzxl.redisson.lock.RedisDistributedLock;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

@Aspect
public class RedisLockAspect {
    private static final Logger log = LoggerFactory.getLogger(RedisLockAspect.class);
    private final RedisDistributedLock redisDistributedLock;

    public RedisLockAspect(RedisDistributedLock redisDistributedLock) {
        this.redisDistributedLock = redisDistributedLock;
    }

    @Pointcut(value="@annotation(redisLock)")
    public void redisLockAspect(RedisLock redisLock) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="redisLockAspect(redisLock)", argNames="proceedingJoinPoint,redisLock")
    public Object around(ProceedingJoinPoint proceedingJoinPoint, RedisLock redisLock) throws Throwable {
        Object result;
        long threadId = Thread.currentThread().getId();
        String keyPrefix = redisLock.prefix();
        if (StringUtils.isEmpty((Object)keyPrefix)) {
            throw new RuntimeException("lock key don't null...");
        }
        long waitTime = redisLock.waitTime();
        long leaseTime = redisLock.leaseTime();
        int tryCount = redisLock.tryCount();
        long sleepTime = redisLock.sleepTime();
        String lockKey = LockKeyGenerator.getLockKey(proceedingJoinPoint);
        log.info("\u7ebf\u7a0b[{}] -> \u8981\u52a0\u9501\u7684key\uff1a[{}]\uff0cvalue\uff1a[{}]", new Object[]{threadId, lockKey, lockKey});
        if (this.redisDistributedLock.lock(lockKey, waitTime, leaseTime, tryCount, sleepTime)) {
            log.info("\u7ebf\u7a0b[{}] -> \u83b7\u53d6\u9501key[{}] \u6210\u529f", (Object)threadId, (Object)lockKey);
            try {
                result = proceedingJoinPoint.proceed();
            }
            finally {
                log.info("\u7ebf\u7a0b[{}] -> \u91ca\u653e\u9501 key [{}]", (Object)threadId, (Object)lockKey);
                this.redisDistributedLock.releaseLock(lockKey);
            }
        } else {
            log.error("\u7ebf\u7a0b[{}] -> \u83b7\u53d6\u9501key[{}] \u5931\u8d25", (Object)threadId, (Object)lockKey);
            throw new RuntimeException("\u54ce\u5440\uff0c\u5f00\u4e86\u4e2a\u5c0f\u5dee\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return result;
    }
}

