/*
 * Decompiled with CFR 0.152.
 */
package com.github.sparkzxl.redisson.aspect;

import com.github.sparkzxl.redisson.annotation.RedisLock;
import com.github.sparkzxl.redisson.annotation.RedisLockParam;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class LockKeyGenerator {
    public static String getLockKey(ProceedingJoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        RedisLock redisLock = method.getAnnotation(RedisLock.class);
        Object[] args = joinPoint.getArgs();
        Parameter[] parameters = method.getParameters();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < parameters.length; ++i) {
            RedisLockParam annotation = parameters[i].getAnnotation(RedisLockParam.class);
            if (annotation == null) continue;
            builder.append(redisLock.delimiter()).append(args[i]);
        }
        if (StringUtils.isEmpty((Object)builder.toString())) {
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            for (int i = 0; i < parameterAnnotations.length; ++i) {
                Field[] fields;
                Object object = args[i];
                for (Field field : fields = object.getClass().getDeclaredFields()) {
                    RedisLockParam annotation = field.getAnnotation(RedisLockParam.class);
                    if (annotation == null) continue;
                    field.setAccessible(true);
                    builder.append(redisLock.delimiter()).append(ReflectionUtils.getField((Field)field, (Object)object));
                }
            }
        }
        return redisLock.prefix() + builder;
    }
}

