/*
 * Decompiled with CFR 0.152.
 */
package com.github.sparkzxl.redisson.lock;

import com.github.sparkzxl.redisson.lock.AbstractDistributedLock;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RMapCache;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisDistributedLock
extends AbstractDistributedLock {
    private static final Logger log = LoggerFactory.getLogger(RedisDistributedLock.class);
    public RedissonClient redissonClient;

    public void setRedissonClient(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }

    @Override
    public boolean lock(String key, long waitTime, long leaseTime) {
        RLock lock = this.redissonClient.getLock(key);
        try {
            return lock.tryLock(waitTime, leaseTime, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public boolean lock(String key, long waitTime, long leaseTime, int tryCount, long sleepTime) {
        boolean result;
        block4: {
            result = false;
            try {
                boolean unlock = this.lock(key, waitTime, leaseTime);
                log.info("\u7ebf\u7a0b" + Thread.currentThread().getId() + "\u5c1d\u8bd5[{}]\u83b7\u53d6\u9501[{}] -> [{}]", new Object[]{tryCount, key, unlock});
                if (unlock) {
                    result = true;
                    break block4;
                }
                while (tryCount > 0) {
                    boolean res;
                    Thread.sleep(sleepTime);
                    if (!(res = this.lock(key, waitTime, leaseTime, --tryCount, sleepTime))) continue;
                    result = true;
                    break;
                }
            }
            catch (InterruptedException e) {
                log.error("RedisLock \u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5f02\u5e38 -> [{}]", (Object)e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
        return result;
    }

    @Override
    public void releaseLock(String key) {
        RLock lock = this.redissonClient.getLock(key);
        if (lock.isLocked()) {
            lock.unlock();
        }
    }

    public void initCount(String key, int count) {
        RMapCache mapCache = this.redissonClient.getMapCache("skill");
        mapCache.putIfAbsent((Object)key, (Object)count, 3L, TimeUnit.DAYS);
    }

    public int incr(String key, int delta) {
        RMapCache mapCache = this.redissonClient.getMapCache("skill");
        if (delta < 0) {
            throw new RuntimeException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return (Integer)mapCache.addAndGet((Object)key, (Number)1);
    }

    public int decr(String key, int delta) {
        RMapCache mapCache = this.redissonClient.getMapCache("skill");
        if (delta < 0) {
            throw new RuntimeException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return (Integer)mapCache.addAndGet((Object)key, (Number)(-delta));
    }
}

