/*
 * Decompiled with CFR 0.152.
 */
package com.sophoun.utils.validation;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import androidx.core.util.PatternsCompat;
import kotlin.Metadata;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\t\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/sophoun/utils/validation/Validators;", "", "()V", "isValidEmail", "", "email", "", "isValidIpAddress", "ipAddress", "isValidUrl", "url", "library_release"})
@SuppressLint(value={"RestrictedApi"})
public final class Validators {
    public static final Validators INSTANCE;

    public final boolean isValidEmail(@Nullable CharSequence email) {
        return !TextUtils.isEmpty((CharSequence)email) && PatternsCompat.AUTOLINK_EMAIL_ADDRESS.matcher(email).matches();
    }

    public final boolean isValidUrl(@Nullable CharSequence url) {
        return !TextUtils.isEmpty((CharSequence)url) && PatternsCompat.AUTOLINK_WEB_URL.matcher(url).matches();
    }

    public final boolean isValidIpAddress(@Nullable CharSequence ipAddress) {
        return !TextUtils.isEmpty((CharSequence)ipAddress) && PatternsCompat.IP_ADDRESS.matcher(ipAddress).matches();
    }

    private Validators() {
    }

    static {
        Validators validators;
        INSTANCE = validators = new Validators();
    }
}

