/*
 * Decompiled with CFR 0.152.
 */
package com.sophoun.utils;

import android.content.Context;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\r"}, d2={"Lcom/sophoun/utils/SoftKeyboard;", "", "()V", "getInputMethodManager", "Landroid/view/inputmethod/InputMethodManager;", "context", "Landroid/content/Context;", "hide", "", "view", "Landroid/view/View;", "show", "showWithDialog", "library_release"})
public final class SoftKeyboard {
    public static final SoftKeyboard INSTANCE;

    private final InputMethodManager getInputMethodManager(Context context) {
        Object object = context.getSystemService("input_method");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        }
        return (InputMethodManager)object;
    }

    public final void show(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        if (view.requestFocus()) {
            Context context = view.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"view.context");
            this.getInputMethodManager(context).showSoftInput(view, 1);
        }
    }

    public final void showWithDialog(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        if (view.requestFocus()) {
            Context context = view.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"view.context");
            this.getInputMethodManager(context).toggleSoftInput(2, 0);
        }
    }

    public final void hide(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Context context = view.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"view.context");
        this.getInputMethodManager(context).hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    private SoftKeyboard() {
    }

    static {
        SoftKeyboard softKeyboard;
        INSTANCE = softKeyboard = new SoftKeyboard();
    }
}

