/*
 * Decompiled with CFR 0.152.
 */
package com.sqsong.qrcodelib.camera;

import android.os.Handler;
import android.os.Message;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.ResultPointCallback;
import com.sqsong.qrcodelib.camera.CameraManager;
import com.sqsong.qrcodelib.camera.DecodeThread;
import com.sqsong.qrcodelib.camera.QRCodeDecodeCallback;

public final class QRCodeDecodeHandler
extends Handler
implements ResultPointCallback {
    private static final String TAG = QRCodeDecodeHandler.class.getSimpleName();
    private State state;
    private final DecodeThread decodeThread;
    private final CameraManager cameraManager;
    private QRCodeDecodeCallback mDecodeCallback;

    public void foundPossibleResultPoint(ResultPoint resultPoint) {
        if (this.mDecodeCallback != null) {
            this.mDecodeCallback.foundPossibleResultPoint(resultPoint);
        }
    }

    public QRCodeDecodeHandler(CameraManager cameraManager, QRCodeDecodeCallback l) {
        this.decodeThread = new DecodeThread(this, cameraManager, this);
        this.mDecodeCallback = l;
        this.decodeThread.start();
        this.state = State.SUCCESS;
        this.cameraManager = cameraManager;
        cameraManager.startPreview();
        this.restartPreviewAndDecode();
    }

    public void handleMessage(Message message) {
        switch (message.what) {
            case 0: {
                this.restartPreviewAndDecode();
                break;
            }
            case 1: {
                this.state = State.SUCCESS;
                if (this.mDecodeCallback == null) break;
                this.mDecodeCallback.onDecodeSuccess((Result)message.obj);
                break;
            }
            case 2: {
                this.state = State.PREVIEW;
                this.cameraManager.requestPreviewFrame(this.decodeThread.getHandler(), 3);
            }
        }
    }

    public void quitSynchronously() {
        this.state = State.DONE;
        this.cameraManager.stopPreview();
        Message quit = Message.obtain((Handler)this.decodeThread.getHandler(), (int)4);
        quit.sendToTarget();
        try {
            this.decodeThread.join(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.removeMessages(1);
        this.removeMessages(2);
    }

    private void restartPreviewAndDecode() {
        if (this.state == State.SUCCESS) {
            this.state = State.PREVIEW;
            this.cameraManager.requestPreviewFrame(this.decodeThread.getHandler(), 3);
        }
    }

    private static enum State {
        PREVIEW,
        SUCCESS,
        DONE;

    }
}

