/*
 * Decompiled with CFR 0.152.
 */
package com.sqsong.qrcodelib.camera;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.ResultPointCallback;
import com.sqsong.qrcodelib.camera.CameraManager;
import com.sqsong.qrcodelib.camera.DecodeFormatManager;
import com.sqsong.qrcodelib.camera.DecodeHandler;
import com.sqsong.qrcodelib.camera.QRCodeDecodeHandler;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

final class DecodeThread
extends Thread {
    public static final String BARCODE_BITMAP = "barcode_bitmap";
    public static final String BARCODE_SCALED_FACTOR = "barcode_scaled_factor";
    private Handler mDecodeHandler;
    private CameraManager mCameraManager;
    private QRCodeDecodeHandler mHandler;
    private final CountDownLatch handlerInitLatch;
    private final Map<DecodeHintType, Object> hints;
    private Collection<BarcodeFormat> decodeFormats;

    public DecodeThread(QRCodeDecodeHandler handler, CameraManager cameraManager, ResultPointCallback resultPointCallback) {
        this.mHandler = handler;
        this.mCameraManager = cameraManager;
        this.handlerInitLatch = new CountDownLatch(1);
        this.hints = new EnumMap<DecodeHintType, Object>(DecodeHintType.class);
        if (this.decodeFormats == null || this.decodeFormats.isEmpty()) {
            this.decodeFormats = EnumSet.noneOf(BarcodeFormat.class);
            this.decodeFormats.addAll(DecodeFormatManager.PRODUCT_FORMATS);
            this.decodeFormats.addAll(DecodeFormatManager.INDUSTRIAL_FORMATS);
            this.decodeFormats.addAll(DecodeFormatManager.QR_CODE_FORMATS);
            this.decodeFormats.addAll(DecodeFormatManager.DATA_MATRIX_FORMATS);
            this.decodeFormats.addAll(DecodeFormatManager.AZTEC_FORMATS);
            this.decodeFormats.addAll(DecodeFormatManager.PDF417_FORMATS);
        }
        this.hints.put(DecodeHintType.POSSIBLE_FORMATS, this.decodeFormats);
        this.hints.put(DecodeHintType.NEED_RESULT_POINT_CALLBACK, resultPointCallback);
        Log.i((String)"DecodeThread", (String)("Hints: " + this.hints));
    }

    Handler getHandler() {
        try {
            this.handlerInitLatch.await();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        return this.mDecodeHandler;
    }

    @Override
    public void run() {
        Looper.prepare();
        this.mDecodeHandler = new DecodeHandler(this.mHandler, this.mCameraManager, this.hints);
        this.handlerInitLatch.countDown();
        Looper.loop();
    }
}

