/*
 * Decompiled with CFR 0.152.
 */
package com.sqsong.qrcodelib.camera;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.Camera;
import android.os.Handler;
import android.util.Log;
import android.view.SurfaceHolder;
import com.google.zxing.PlanarYUVLuminanceSource;
import com.sqsong.qrcodelib.camera.AutoFocusManager;
import com.sqsong.qrcodelib.camera.CameraConfigurationManager;
import com.sqsong.qrcodelib.camera.PreviewCallback;
import com.sqsong.qrcodelib.camera.open.OpenCamera;
import com.sqsong.qrcodelib.camera.open.OpenCameraInterface;
import java.io.IOException;

public final class CameraManager {
    private static final String TAG = CameraManager.class.getSimpleName();
    private Rect framingRect;
    private OpenCamera camera;
    private boolean previewing;
    private boolean initialized;
    private final Context context;
    private Rect framingRectInPreview;
    private AutoFocusManager autoFocusManager;
    private final PreviewCallback previewCallback;
    private final CameraConfigurationManager configManager;
    private int requestedCameraId = -1;

    public CameraManager(Context context) {
        this.context = context;
        this.configManager = new CameraConfigurationManager(context);
        this.previewCallback = new PreviewCallback(this.configManager);
    }

    public synchronized void openDriver(SurfaceHolder holder) throws IOException {
        Camera cameraObject;
        block7: {
            Camera.Parameters parameters;
            OpenCamera theCamera = this.camera;
            if (theCamera == null) {
                theCamera = OpenCameraInterface.open(this.requestedCameraId);
                if (theCamera == null) {
                    throw new IOException("Camera.open() failed to return object from driver");
                }
                this.camera = theCamera;
            }
            if (!this.initialized) {
                this.initialized = true;
                this.configManager.initFromCameraParameters(theCamera);
            }
            String parametersFlattened = (parameters = (cameraObject = theCamera.getCamera()).getParameters()) == null ? null : parameters.flatten();
            try {
                this.configManager.setDesiredCameraParameters(theCamera, false);
            }
            catch (RuntimeException re) {
                Log.w((String)TAG, (String)"Camera rejected parameters. Setting only minimal safe-mode parameters");
                Log.i((String)TAG, (String)("Resetting to saved camera params: " + parametersFlattened));
                if (parametersFlattened == null) break block7;
                parameters = cameraObject.getParameters();
                parameters.unflatten(parametersFlattened);
                try {
                    cameraObject.setParameters(parameters);
                    this.configManager.setDesiredCameraParameters(theCamera, true);
                }
                catch (RuntimeException re2) {
                    Log.w((String)TAG, (String)"Camera rejected even safe-mode parameters! No configuration");
                }
            }
        }
        cameraObject.setPreviewDisplay(holder);
    }

    public synchronized boolean isOpen() {
        return this.camera != null;
    }

    public synchronized void closeDriver() {
        if (this.camera != null) {
            this.camera.getCamera().release();
            this.camera = null;
            this.framingRect = null;
            this.framingRectInPreview = null;
        }
    }

    public synchronized void startPreview() {
        OpenCamera theCamera = this.camera;
        if (theCamera != null && !this.previewing) {
            theCamera.getCamera().startPreview();
            this.previewing = true;
            this.autoFocusManager = new AutoFocusManager(this.context, theCamera.getCamera());
        }
    }

    public synchronized void stopPreview() {
        if (this.autoFocusManager != null) {
            this.autoFocusManager.stop();
            this.autoFocusManager = null;
        }
        if (this.camera != null && this.previewing) {
            this.camera.getCamera().stopPreview();
            this.previewCallback.setHandler(null, 0);
            this.previewing = false;
        }
    }

    public synchronized void setTorch(boolean newSetting) {
        OpenCamera theCamera = this.camera;
        if (theCamera != null && newSetting != this.configManager.getTorchState(theCamera.getCamera())) {
            boolean wasAutoFocusManager;
            boolean bl = wasAutoFocusManager = this.autoFocusManager != null;
            if (wasAutoFocusManager) {
                this.autoFocusManager.stop();
                this.autoFocusManager = null;
            }
            this.configManager.setTorch(theCamera.getCamera(), newSetting);
            if (wasAutoFocusManager) {
                this.autoFocusManager = new AutoFocusManager(this.context, theCamera.getCamera());
                this.autoFocusManager.start();
            }
        }
    }

    public synchronized void requestPreviewFrame(Handler handler, int message) {
        OpenCamera theCamera = this.camera;
        if (theCamera != null && this.previewing) {
            this.previewCallback.setHandler(handler, message);
            theCamera.getCamera().setOneShotPreviewCallback((Camera.PreviewCallback)this.previewCallback);
        }
    }

    public synchronized Rect getFramingRect() {
        if (this.framingRect == null) {
            int width;
            if (this.camera == null) {
                return null;
            }
            Point screenResolution = this.configManager.getScreenResolution();
            if (screenResolution == null) {
                return null;
            }
            int height = width = (int)((float)screenResolution.x * 1.0f / 2.0f);
            int leftOffset = (int)((float)(screenResolution.x - width) * 1.0f / 2.0f);
            int topOffset = (int)((float)(screenResolution.y - height) * 1.0f / 2.0f);
            this.framingRect = new Rect(leftOffset, topOffset, leftOffset + width, topOffset + height);
            Log.d((String)TAG, (String)("Calculated framing rect: " + this.framingRect));
        }
        return this.framingRect;
    }

    public synchronized Rect getFramingRectInPreview() {
        if (this.framingRectInPreview == null) {
            Rect framingRect = this.getFramingRect();
            if (framingRect == null) {
                return null;
            }
            Rect rect = new Rect(framingRect);
            Point cameraResolution = this.configManager.getCameraResolution();
            Point screenResolution = this.configManager.getScreenResolution();
            if (cameraResolution == null || screenResolution == null) {
                return null;
            }
            rect.left = (int)((float)(rect.left * cameraResolution.y) * 1.0f / (float)screenResolution.x);
            rect.right = (int)((float)(rect.right * cameraResolution.y) * 1.0f / (float)screenResolution.x);
            rect.top = (int)((float)(rect.top * cameraResolution.x) * 1.0f / (float)screenResolution.y);
            rect.bottom = (int)((float)(rect.bottom * cameraResolution.x) * 1.0f / (float)screenResolution.y);
            this.framingRectInPreview = rect;
        }
        return this.framingRectInPreview;
    }

    public synchronized void setManualCameraId(int cameraId) {
        this.requestedCameraId = cameraId;
    }

    public PlanarYUVLuminanceSource buildLuminanceSource(byte[] data, int width, int height) {
        Rect rect = this.getFramingRectInPreview();
        if (rect == null) {
            return null;
        }
        return new PlanarYUVLuminanceSource(data, width, height, rect.left, rect.top, rect.width(), rect.height(), false);
    }
}

