/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.utils;

import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.NotACssException;
import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.AnonymousExpression;
import com.github.sommeri.less4j.core.ast.BinaryExpression;
import com.github.sommeri.less4j.core.ast.BinaryExpressionOperator;
import com.github.sommeri.less4j.core.ast.Body;
import com.github.sommeri.less4j.core.ast.CharsetDeclaration;
import com.github.sommeri.less4j.core.ast.ColorExpression;
import com.github.sommeri.less4j.core.ast.Comment;
import com.github.sommeri.less4j.core.ast.CssClass;
import com.github.sommeri.less4j.core.ast.CssString;
import com.github.sommeri.less4j.core.ast.Declaration;
import com.github.sommeri.less4j.core.ast.Document;
import com.github.sommeri.less4j.core.ast.ElementSubsequent;
import com.github.sommeri.less4j.core.ast.EmbeddedScript;
import com.github.sommeri.less4j.core.ast.EmptyExpression;
import com.github.sommeri.less4j.core.ast.EscapedValue;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FaultyExpression;
import com.github.sommeri.less4j.core.ast.FaultyNode;
import com.github.sommeri.less4j.core.ast.FixedMediaExpression;
import com.github.sommeri.less4j.core.ast.FontFace;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.ast.GeneralBody;
import com.github.sommeri.less4j.core.ast.IdSelector;
import com.github.sommeri.less4j.core.ast.IdentifierExpression;
import com.github.sommeri.less4j.core.ast.Import;
import com.github.sommeri.less4j.core.ast.InlineContent;
import com.github.sommeri.less4j.core.ast.InterpolableName;
import com.github.sommeri.less4j.core.ast.InterpolatedMediaExpression;
import com.github.sommeri.less4j.core.ast.Keyframes;
import com.github.sommeri.less4j.core.ast.KeyframesName;
import com.github.sommeri.less4j.core.ast.ListExpression;
import com.github.sommeri.less4j.core.ast.ListExpressionOperator;
import com.github.sommeri.less4j.core.ast.Media;
import com.github.sommeri.less4j.core.ast.MediaExpression;
import com.github.sommeri.less4j.core.ast.MediaExpressionFeature;
import com.github.sommeri.less4j.core.ast.MediaQuery;
import com.github.sommeri.less4j.core.ast.Medium;
import com.github.sommeri.less4j.core.ast.MediumModifier;
import com.github.sommeri.less4j.core.ast.MediumType;
import com.github.sommeri.less4j.core.ast.Name;
import com.github.sommeri.less4j.core.ast.NamedColorExpression;
import com.github.sommeri.less4j.core.ast.NamedExpression;
import com.github.sommeri.less4j.core.ast.Nth;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.ast.Page;
import com.github.sommeri.less4j.core.ast.PageMarginBox;
import com.github.sommeri.less4j.core.ast.PseudoClass;
import com.github.sommeri.less4j.core.ast.PseudoElement;
import com.github.sommeri.less4j.core.ast.RuleSet;
import com.github.sommeri.less4j.core.ast.Selector;
import com.github.sommeri.less4j.core.ast.SelectorAttribute;
import com.github.sommeri.less4j.core.ast.SelectorCombinator;
import com.github.sommeri.less4j.core.ast.SelectorOperator;
import com.github.sommeri.less4j.core.ast.SelectorPart;
import com.github.sommeri.less4j.core.ast.SimpleSelector;
import com.github.sommeri.less4j.core.ast.StyleSheet;
import com.github.sommeri.less4j.core.ast.Supports;
import com.github.sommeri.less4j.core.ast.SupportsCondition;
import com.github.sommeri.less4j.core.ast.SupportsConditionInParentheses;
import com.github.sommeri.less4j.core.ast.SupportsConditionNegation;
import com.github.sommeri.less4j.core.ast.SupportsLogicalCondition;
import com.github.sommeri.less4j.core.ast.SupportsLogicalOperator;
import com.github.sommeri.less4j.core.ast.SupportsQuery;
import com.github.sommeri.less4j.core.ast.SyntaxOnlyElement;
import com.github.sommeri.less4j.core.ast.UnicodeRangeExpression;
import com.github.sommeri.less4j.core.ast.UnknownAtRule;
import com.github.sommeri.less4j.core.ast.Viewport;
import com.github.sommeri.less4j.core.output.ExtendedStringBuilder;
import com.github.sommeri.less4j.core.output.SourceMapBuilder;
import com.github.sommeri.less4j.utils.LastOfKindSet;
import com.github.sommeri.less4j.utils.PrintUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CssPrinter {
    private static final String ERROR = "!#error#!";
    protected ExtendedStringBuilder cssOnly = new ExtendedStringBuilder();
    protected SourceMapBuilder cssAndSM;
    private LessSource lessSource;
    private LessSource cssDestination;
    private LessCompiler.Configuration options;

    public CssPrinter() {
    }

    public CssPrinter(LessSource lessSource, LessSource cssDestination, LessCompiler.Configuration options) {
        this.lessSource = lessSource;
        this.cssDestination = cssDestination;
        this.options = options;
        this.cssAndSM = new SourceMapBuilder(this.cssOnly, cssDestination, this.getSourceMapConfiguration(options));
    }

    public CssPrinter(CssPrinter configureFromPrinter) {
        this.options = configureFromPrinter.options;
        this.lessSource = configureFromPrinter.lessSource;
        this.cssDestination = configureFromPrinter.cssDestination;
        this.cssOnly = new ExtendedStringBuilder(configureFromPrinter.cssOnly);
        this.cssAndSM = new SourceMapBuilder(this.cssOnly, this.cssDestination, this.getSourceMapConfiguration(this.options));
    }

    private LessCompiler.SourceMapConfiguration getSourceMapConfiguration(LessCompiler.Configuration options) {
        return options != null ? options.getSourceMapConfiguration() : new LessCompiler.SourceMapConfiguration();
    }

    public boolean append(ASTCssNode node) {
        if (node == null || node.isSilent()) {
            return false;
        }
        this.appendComments(node.getOpeningComments(), true);
        boolean result = this.switchOnType(node);
        this.appendComments(node.getTrailingComments(), false);
        return result;
    }

    public boolean switchOnType(ASTCssNode node) {
        switch (node.getType()) {
            case RULE_SET: {
                return this.appendRuleset((RuleSet)node);
            }
            case CSS_CLASS: {
                return this.appendCssClass((CssClass)node);
            }
            case PSEUDO_CLASS: {
                return this.appendPseudoClass((PseudoClass)node);
            }
            case PSEUDO_ELEMENT: {
                return this.appendPseudoElement((PseudoElement)node);
            }
            case NTH: {
                return this.appendNth((Nth)node);
            }
            case SELECTOR: {
                return this.appendSelector((Selector)node);
            }
            case SIMPLE_SELECTOR: {
                return this.appendSimpleSelector((SimpleSelector)node);
            }
            case SELECTOR_OPERATOR: {
                return this.appendSelectorOperator((SelectorOperator)node);
            }
            case SELECTOR_COMBINATOR: {
                return this.appendSelectorCombinator((SelectorCombinator)node);
            }
            case SELECTOR_ATTRIBUTE: {
                return this.appendSelectorAttribute((SelectorAttribute)node);
            }
            case ID_SELECTOR: {
                return this.appendIdSelector((IdSelector)node);
            }
            case CHARSET_DECLARATION: {
                return this.appendCharsetDeclaration((CharsetDeclaration)node);
            }
            case FONT_FACE: {
                return this.appendFontFace((FontFace)node);
            }
            case NAMED_EXPRESSION: {
                return this.appendNamedExpression((NamedExpression)node);
            }
            case BINARY_EXPRESSION: {
                return this.appendComposedExpression((BinaryExpression)node);
            }
            case BINARY_EXPRESSION_OPERATOR: {
                return this.appendBinaryExpressionOperator((BinaryExpressionOperator)node);
            }
            case LIST_EXPRESSION: {
                return this.appendListExpression((ListExpression)node);
            }
            case LIST_EXPRESSION_OPERATOR: {
                return this.appendListExpressionOperator((ListExpressionOperator)node);
            }
            case STRING_EXPRESSION: {
                return this.appendCssString((CssString)node);
            }
            case EMPTY_EXPRESSION: {
                return this.appendEmptyExpression((EmptyExpression)node);
            }
            case NUMBER: {
                return this.appendNumberExpression((NumberExpression)node);
            }
            case IDENTIFIER_EXPRESSION: {
                return this.appendIdentifierExpression((IdentifierExpression)node);
            }
            case UNICODE_RANGE_EXPRESSION: {
                return this.appendUnicodeRangeExpression((UnicodeRangeExpression)node);
            }
            case COLOR_EXPRESSION: {
                return this.appendColorExpression((ColorExpression)node);
            }
            case FUNCTION: {
                return this.appendFunctionExpression((FunctionExpression)node);
            }
            case DECLARATION: {
                return this.appendDeclaration((Declaration)node);
            }
            case MEDIA: {
                return this.appendMedia((Media)node);
            }
            case MEDIA_QUERY: {
                return this.appendMediaQuery((MediaQuery)node);
            }
            case MEDIUM: {
                return this.appendMedium((Medium)node);
            }
            case MEDIUM_MODIFIER: {
                return this.appendMediumModifier((MediumModifier)node);
            }
            case MEDIUM_TYPE: {
                return this.appendMediumType((MediumType)node);
            }
            case FIXED_MEDIA_EXPRESSION: {
                return this.appendMediaExpression((FixedMediaExpression)node);
            }
            case INTERPOLATED_MEDIA_EXPRESSION: {
                return this.appendInterpolatedMediaExpression((InterpolatedMediaExpression)node);
            }
            case MEDIUM_EX_FEATURE: {
                return this.appendMediaExpressionFeature((MediaExpressionFeature)node);
            }
            case STYLE_SHEET: {
                return this.appendStyleSheet((StyleSheet)node);
            }
            case FAULTY_EXPRESSION: {
                return this.appendFaultyExpression((FaultyExpression)node);
            }
            case FAULTY_NODE: {
                return this.appendFaultyNode((FaultyNode)node);
            }
            case ESCAPED_VALUE: {
                return this.appendEscapedValue((EscapedValue)node);
            }
            case EMBEDDED_SCRIPT: {
                return this.appendEmbeddedScript((EmbeddedScript)node);
            }
            case KEYFRAMES: {
                return this.appendKeyframes((Keyframes)node);
            }
            case KEYFRAMES_NAME: {
                return this.appendKeyframesName((KeyframesName)node);
            }
            case UNKNOWN_AT_RULE: {
                return this.appendUnknownAtRule((UnknownAtRule)node);
            }
            case DOCUMENT: {
                return this.appendDocument((Document)node);
            }
            case VIEWPORT: {
                return this.appendViewport((Viewport)node);
            }
            case GENERAL_BODY: {
                return this.appendBodyOptimizeDuplicates((GeneralBody)node);
            }
            case PAGE: {
                return this.appendPage((Page)node);
            }
            case PAGE_MARGIN_BOX: {
                return this.appendPageMarginBox((PageMarginBox)node);
            }
            case NAME: {
                return this.appendName((Name)node);
            }
            case IMPORT: {
                return this.appendImport((Import)node);
            }
            case ANONYMOUS: {
                return this.appendAnonymous((AnonymousExpression)node);
            }
            case SYNTAX_ONLY_ELEMENT: {
                return this.appendSyntaxOnlyElement((SyntaxOnlyElement)node);
            }
            case SUPPORTS: {
                return this.appendSupports((Supports)node);
            }
            case SUPPORTS_QUERY: {
                return this.appendSupportsQuery((SupportsQuery)node);
            }
            case SUPPORTS_CONDITION_NEGATION: {
                return this.appendSupportsConditionNegation((SupportsConditionNegation)node);
            }
            case SUPPORTS_CONDITION_PARENTHESES: {
                return this.appendSupportsConditionParentheses((SupportsConditionInParentheses)node);
            }
            case SUPPORTS_CONDITION_LOGICAL: {
                return this.appendSupportsConditionLogical((SupportsLogicalCondition)node);
            }
            case SUPPORTS_LOGICAL_OPERATOR: {
                return this.appendSupportsLogicalOperator((SupportsLogicalOperator)node);
            }
            case INLINE_CONTENT: {
                return this.appendInlineContent((InlineContent)node);
            }
            case ESCAPED_SELECTOR: 
            case PARENTHESES_EXPRESSION: 
            case SIGNED_EXPRESSION: 
            case VARIABLE: 
            case DETACHED_RULESET: 
            case DETACHED_RULESET_REFERENCE: 
            case INDIRECT_VARIABLE: 
            case VARIABLE_DECLARATION: {
                throw new NotACssException(node);
            }
        }
        throw new IllegalStateException("Unknown: " + (Object)((Object)node.getType()) + " " + node.getSourceLine() + ":" + node.getSourceColumn());
    }

    public boolean appendCommaSeparated(List<? extends ASTCssNode> values) {
        boolean result = false;
        Iterator<? extends ASTCssNode> names = values.iterator();
        if (names.hasNext()) {
            result |= this.append(names.next());
        }
        while (names.hasNext()) {
            this.cssOnly.append(",").ensureSeparator();
            this.append(names.next());
            result = true;
        }
        return result;
    }

    private boolean appendInlineContent(InlineContent node) {
        this.cssOnly.appendAsIs(node.getValue());
        return false;
    }

    private boolean appendSyntaxOnlyElement(SyntaxOnlyElement node) {
        this.cssOnly.append(node.getSymbol());
        return true;
    }

    private boolean appendAnonymous(AnonymousExpression node) {
        this.cssOnly.append(node.getValue());
        return true;
    }

    private boolean appendImport(Import node) {
        this.cssOnly.append("@import").ensureSeparator();
        this.append(node.getUrlExpression());
        this.appendCommaSeparated(node.getMediums());
        this.cssOnly.append(";");
        return true;
    }

    private boolean appendName(Name node) {
        this.cssOnly.append(node.getName());
        return true;
    }

    private boolean appendPage(Page node) {
        this.cssOnly.append("@page").ensureSeparator();
        if (node.hasName()) {
            this.append(node.getName());
            if (!node.hasDockedPseudopage()) {
                this.cssOnly.ensureSeparator();
            }
        }
        if (node.hasPseudopage()) {
            this.append(node.getPseudopage());
            this.cssOnly.ensureSeparator();
        }
        this.appendBodySortDeclarations(node.getBody());
        return true;
    }

    private boolean appendPageMarginBox(PageMarginBox node) {
        this.append(node.getName());
        this.appendBodySortDeclarations(node.getBody());
        return true;
    }

    private boolean appendKeyframesName(KeyframesName node) {
        this.append(node.getName());
        return true;
    }

    private boolean appendKeyframes(Keyframes node) {
        this.cssOnly.append(node.getDialect()).ensureSeparator();
        this.appendCommaSeparated(node.getNames());
        this.append(node.getBody());
        return true;
    }

    private boolean appendUnknownAtRule(UnknownAtRule node) {
        this.cssOnly.append(node.getName()).ensureSeparator();
        this.appendCommaSeparated(node.getNames());
        this.append(node.getBody());
        this.append(node.getSemicolon());
        return true;
    }

    private boolean appendSupports(Supports node) {
        this.cssOnly.append(node.getDialect()).ensureSeparator();
        this.append(node.getCondition());
        this.cssOnly.ensureSeparator();
        this.append(node.getBody());
        return true;
    }

    private boolean appendSupportsConditionNegation(SupportsConditionNegation node) {
        this.append(node.getNegation());
        this.cssOnly.ensureSeparator();
        this.append(node.getCondition());
        return true;
    }

    private boolean appendSupportsConditionParentheses(SupportsConditionInParentheses node) {
        this.append(node.getOpeningParentheses());
        this.append(node.getCondition());
        this.append(node.getClosingParentheses());
        return true;
    }

    private boolean appendSupportsConditionLogical(SupportsLogicalCondition node) {
        Iterator<SupportsLogicalOperator> operators = node.getLogicalOperators().iterator();
        Iterator<SupportsCondition> conditions = node.getConditions().iterator();
        this.append(conditions.next());
        while (operators.hasNext()) {
            this.cssOnly.ensureSeparator();
            this.append(operators.next());
            this.cssOnly.ensureSeparator();
            this.append(conditions.next());
        }
        return true;
    }

    private boolean appendSupportsLogicalOperator(SupportsLogicalOperator node) {
        if (node.getOperator() == null) {
            this.cssOnly.append(ERROR);
        }
        this.cssOnly.append(node.getOperator().getSymbol());
        return true;
    }

    private boolean appendSupportsQuery(SupportsQuery node) {
        this.append(node.getOpeningParentheses());
        this.append(node.getDeclaration());
        this.append(node.getClosingParentheses());
        return true;
    }

    private boolean appendDocument(Document node) {
        this.cssOnly.append(node.getDialect()).ensureSeparator();
        this.appendCommaSeparated(node.getUrlMatchFunctions());
        this.append(node.getBody());
        return true;
    }

    private boolean appendViewport(Viewport node) {
        this.cssOnly.append(node.getDialect());
        this.append(node.getBody());
        return true;
    }

    private boolean appendFaultyNode(FaultyNode node) {
        this.cssOnly.append(ERROR);
        return true;
    }

    private boolean appendFaultyExpression(FaultyExpression node) {
        this.cssOnly.append(ERROR);
        return true;
    }

    private boolean appendNth(Nth node) {
        switch (node.getForm()) {
            case EVEN: {
                this.cssOnly.append("even");
                return true;
            }
            case ODD: {
                this.cssOnly.append("odd");
                return true;
            }
            case STANDARD: {
                if (node.getRepeater() != null) {
                    this.append(node.getRepeater());
                }
                if (node.getMod() == null) break;
                this.append(node.getMod());
            }
        }
        return true;
    }

    protected void appendComments(List<Comment> comments, boolean ensureSeparator) {
        if (comments == null || comments.isEmpty()) {
            return;
        }
        this.cssOnly.ensureSeparator();
        for (Comment comment : comments) {
            String text = comment.getComment();
            if (text != null) {
                this.cssOnly.append(text);
            }
            if (!comment.hasNewLine()) continue;
            this.cssOnly.ensureNewLine();
        }
        if (ensureSeparator) {
            this.cssOnly.ensureSeparator();
        }
    }

    public boolean appendFontFace(FontFace node) {
        this.cssOnly.append("@font-face").ensureSeparator();
        this.append(node.getBody());
        return true;
    }

    public boolean appendCharsetDeclaration(CharsetDeclaration node) {
        this.cssAndSM.append("@charset", node.getUnderlyingStructure()).ensureSeparator();
        this.append(node.getCharset());
        this.cssOnly.append(";");
        return true;
    }

    public boolean appendIdSelector(IdSelector node) {
        this.cssAndSM.append(node.getFullName(), node.getUnderlyingStructure());
        return true;
    }

    public boolean appendSelectorAttribute(SelectorAttribute node) {
        this.cssOnly.append("[");
        this.cssOnly.append(node.getName());
        this.append(node.getOperator());
        this.append(node.getValue());
        this.cssOnly.append("]");
        return true;
    }

    private boolean appendSelectorOperator(SelectorOperator operator) {
        SelectorOperator.Operator realOperator = operator.getOperator();
        switch (realOperator) {
            case NONE: {
                break;
            }
            default: {
                this.cssOnly.append(realOperator.getSymbol());
            }
        }
        return true;
    }

    public boolean appendPseudoClass(PseudoClass node) {
        this.cssOnly.append(":");
        this.cssOnly.append(node.getName());
        if (node.hasParameters()) {
            this.cssOnly.append("(");
            this.append(node.getParameter());
            this.cssOnly.append(")");
        }
        return true;
    }

    public boolean appendPseudoElement(PseudoElement node) {
        this.cssOnly.append(":");
        if (!node.isLevel12Form()) {
            this.cssOnly.append(":");
        }
        this.cssOnly.append(node.getName());
        return true;
    }

    public boolean appendStyleSheet(StyleSheet styleSheet) {
        this.appendComments(styleSheet.getOrphanComments(), false);
        this.appendAllChilds(styleSheet);
        return true;
    }

    public boolean appendRuleset(RuleSet ruleSet) {
        if (ruleSet.hasEmptyBody()) {
            return false;
        }
        this.appendSelectors(ruleSet.getSelectors());
        this.append(ruleSet.getBody());
        return true;
    }

    private boolean appendBodyOptimizeDuplicates(Body body) {
        if (body.isEmpty()) {
            return false;
        }
        this.cssOnly.ensureSeparator();
        this.append(body.getOpeningCurlyBrace());
        this.cssOnly.ensureNewLine().increaseIndentationLevel();
        Iterable<CssPrinter> declarationsBuilders = this.collectUniqueBodyMembersStrings(body);
        for (CssPrinter miniBuilder : declarationsBuilders) {
            this.append(miniBuilder);
        }
        this.appendComments(body.getOrphanComments(), false);
        this.cssOnly.decreaseIndentationLevel();
        this.append(body.getClosingCurlyBrace());
        return true;
    }

    private void append(CssPrinter miniBuilder) {
        this.cssAndSM.append(miniBuilder.cssAndSM);
    }

    private Iterable<CssPrinter> collectUniqueBodyMembersStrings(Body body) {
        LastOfKindSet<String, CssPrinter> declarationsStrings = new LastOfKindSet<String, CssPrinter>();
        for (ASTCssNode declaration : body.getMembers()) {
            CssPrinter miniPrinter = new CssPrinter(this);
            miniPrinter.append(declaration);
            miniPrinter.cssOnly.ensureNewLine();
            declarationsStrings.add(miniPrinter.toCss().toString(), miniPrinter);
        }
        return declarationsStrings;
    }

    public boolean appendDeclaration(Declaration declaration) {
        this.cssOnly.appendIgnoreNull(declaration.getNameAsString());
        this.cssOnly.append(":").ensureSeparator();
        if (declaration.getExpression() != null) {
            this.append(declaration.getExpression());
        }
        if (declaration.isImportant()) {
            this.cssOnly.ensureSeparator().append("!important");
        }
        if (this.shouldHaveSemicolon(declaration)) {
            this.cssOnly.appendIgnoreNull(";");
        }
        return true;
    }

    private boolean shouldHaveSemicolon(Declaration declaration) {
        return null == declaration.getParent() || declaration.getParent().getType() != ASTCssNodeType.SUPPORTS_QUERY;
    }

    private boolean appendMedia(Media node) {
        this.cssOnly.append("@media");
        this.appendCommaSeparated(node.getMediums());
        this.appendBodySortDeclarations(node.getBody());
        return true;
    }

    private void appendBodySortDeclarations(Body node) {
        this.appendComments(node.getOpeningComments(), true);
        this.cssOnly.ensureSeparator();
        this.append(node.getOpeningCurlyBrace());
        this.cssOnly.ensureNewLine().increaseIndentationLevel();
        Iterator<ASTCssNode> declarations = node.getDeclarations().iterator();
        List<ASTCssNode> notDeclarations = node.getNotDeclarations();
        while (declarations.hasNext()) {
            ASTCssNode declaration = declarations.next();
            this.append(declaration);
            if (!declarations.hasNext() && !notDeclarations.isEmpty()) continue;
            this.cssOnly.ensureNewLine();
        }
        for (ASTCssNode body : notDeclarations) {
            boolean changedAnything = this.append(body);
            if (!changedAnything) continue;
            this.cssOnly.ensureNewLine();
        }
        this.appendComments(node.getOrphanComments(), false);
        this.cssOnly.decreaseIndentationLevel();
        this.append(node.getClosingCurlyBrace());
        this.appendComments(node.getTrailingComments(), false);
    }

    public boolean appendMediaQuery(MediaQuery mediaQuery) {
        this.cssOnly.ensureSeparator();
        this.append(mediaQuery.getMedium());
        boolean needSeparator = mediaQuery.getMedium() != null;
        for (MediaExpression mediaExpression : mediaQuery.getExpressions()) {
            if (needSeparator) {
                this.cssOnly.ensureSeparator().append("and");
            }
            this.append(mediaExpression);
            needSeparator = true;
        }
        return true;
    }

    public boolean appendMedium(Medium medium) {
        this.append(medium.getModifier());
        this.append(medium.getMediumType());
        return true;
    }

    public boolean appendMediumModifier(MediumModifier modifier) {
        MediumModifier.Modifier kind = modifier.getModifier();
        switch (kind) {
            case ONLY: {
                this.cssOnly.ensureSeparator().append("only");
                break;
            }
            case NOT: {
                this.cssOnly.ensureSeparator().append("not");
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown modifier type.");
            }
        }
        return true;
    }

    public boolean appendMediumType(MediumType medium) {
        this.cssOnly.ensureSeparator().append(medium.getName());
        return true;
    }

    public boolean appendMediaExpression(FixedMediaExpression expression) {
        this.cssOnly.ensureSeparator().append("(");
        this.append(expression.getFeature());
        if (expression.getExpression() != null) {
            this.cssOnly.append(":").ensureSeparator();
            this.append(expression.getExpression());
        }
        this.cssOnly.append(")");
        return true;
    }

    private boolean appendInterpolatedMediaExpression(InterpolatedMediaExpression expression) {
        this.cssOnly.ensureSeparator();
        return this.append(expression.getExpression());
    }

    public boolean appendMediaExpressionFeature(MediaExpressionFeature feature) {
        this.cssOnly.append(feature.getFeature());
        return true;
    }

    public boolean appendNamedExpression(NamedExpression expression) {
        this.cssOnly.append(expression.getName());
        this.cssOnly.append("=");
        this.append(expression.getExpression());
        return true;
    }

    public boolean appendComposedExpression(BinaryExpression expression) {
        this.append(expression.getLeft());
        this.append(expression.getOperator());
        this.append(expression.getRight());
        return true;
    }

    public boolean appendListExpression(ListExpression expression) {
        Iterator<Expression> iterator = expression.getExpressions().iterator();
        if (!iterator.hasNext()) {
            return false;
        }
        this.append(iterator.next());
        while (iterator.hasNext()) {
            this.append(expression.getOperator());
            this.append(iterator.next());
        }
        return true;
    }

    public boolean appendExpressionOperator(ListExpressionOperator operator) {
        ListExpressionOperator.Operator realOperator = operator.getOperator();
        switch (realOperator) {
            case COMMA: {
                this.cssOnly.append(realOperator.getSymbol()).ensureSeparator();
                break;
            }
            case EMPTY_OPERATOR: {
                this.cssOnly.ensureSeparator();
                break;
            }
            default: {
                this.cssOnly.append(realOperator.getSymbol());
            }
        }
        return true;
    }

    public boolean appendBinaryExpressionOperator(BinaryExpressionOperator operator) {
        BinaryExpressionOperator.Operator realOperator = operator.getOperator();
        switch (realOperator) {
            case MINUS: {
                this.cssOnly.ensureSeparator().append("-");
                break;
            }
            default: {
                this.cssOnly.append(realOperator.getSymbol());
            }
        }
        return true;
    }

    public boolean appendListExpressionOperator(ListExpressionOperator operator) {
        ListExpressionOperator.Operator realOperator = operator.getOperator();
        switch (realOperator) {
            case COMMA: {
                this.cssOnly.append(realOperator.getSymbol()).ensureSeparator();
                break;
            }
            case EMPTY_OPERATOR: {
                this.cssOnly.ensureSeparator();
                break;
            }
            default: {
                this.cssOnly.append(realOperator.getSymbol());
            }
        }
        return true;
    }

    public boolean appendCssString(CssString expression) {
        String quoteType = expression.getQuoteType();
        this.cssOnly.append(quoteType).append(expression.getValue()).append(quoteType);
        return true;
    }

    public boolean appendEmptyExpression(EmptyExpression node) {
        return true;
    }

    public boolean appendEscapedValue(EscapedValue escaped) {
        this.cssOnly.append(escaped.getValue());
        return true;
    }

    public boolean appendEmbeddedScript(EmbeddedScript escaped) {
        this.cssOnly.append(escaped.getValue());
        return true;
    }

    public boolean appendIdentifierExpression(IdentifierExpression expression) {
        this.cssOnly.append(expression.getValue());
        return true;
    }

    public boolean appendUnicodeRangeExpression(UnicodeRangeExpression expression) {
        this.cssOnly.append(expression.getValue());
        return true;
    }

    protected boolean appendColorExpression(ColorExpression expression) {
        if (expression instanceof NamedColorExpression) {
            NamedColorExpression named = (NamedColorExpression)expression;
            this.cssOnly.append(named.getColorName());
        } else {
            this.cssOnly.append(expression.getValue());
        }
        return true;
    }

    private boolean appendFunctionExpression(FunctionExpression node) {
        this.cssOnly.append(node.getName());
        this.cssOnly.append("(");
        this.append(node.getParameter());
        this.cssOnly.append(")");
        return true;
    }

    private boolean appendNumberExpression(NumberExpression node) {
        if (node.hasOriginalString()) {
            this.cssOnly.append(node.getOriginalString());
        } else {
            if (node.hasExpliciteSign()) {
                if (0.0 < node.getValueAsDouble()) {
                    this.cssOnly.append("+");
                } else {
                    this.cssOnly.append("-");
                }
            }
            this.cssOnly.append(PrintUtils.formatNumber(node.getValueAsDouble()) + node.getSuffix());
        }
        return true;
    }

    public void appendSelectors(List<Selector> selectors) {
        if ((selectors = this.filterSilent(selectors)).size() == 1 && this.isEmptySelector(selectors.get(0))) {
            this.cssOnly.append(" ");
        }
        Iterator<Selector> iterator = selectors.iterator();
        while (iterator.hasNext()) {
            Selector selector = iterator.next();
            this.append(selector);
            if (!iterator.hasNext()) continue;
            this.cssOnly.append(",").newLine();
        }
    }

    private <T extends ASTCssNode> List<T> filterSilent(List<T> nodes) {
        ArrayList<ASTCssNode> result = new ArrayList<ASTCssNode>();
        for (ASTCssNode t : nodes) {
            if (t.isSilent()) continue;
            result.add(t);
        }
        return result;
    }

    private boolean isEmptySelector(Selector selector) {
        if (selector.isCombined()) {
            return false;
        }
        SelectorPart head = selector.getHead();
        if (head.getType() != ASTCssNodeType.SIMPLE_SELECTOR) {
            return false;
        }
        SimpleSelector simpleHead = (SimpleSelector)head;
        if (!simpleHead.isEmptyForm() || !simpleHead.isStar()) {
            return false;
        }
        return !simpleHead.hasSubsequent();
    }

    public boolean appendSelector(Selector selector) {
        for (SelectorPart part : selector.getParts()) {
            this.append(part);
        }
        return true;
    }

    private boolean appendSimpleSelector(SimpleSelector selector) {
        if (selector.hasLeadingCombinator()) {
            this.append(selector.getLeadingCombinator());
        }
        this.appendSimpleSelectorHead(selector);
        this.appendSimpleSelectorTail(selector);
        return true;
    }

    private void appendSimpleSelectorTail(SimpleSelector selector) {
        List<ElementSubsequent> allChilds = selector.getSubsequent();
        for (ElementSubsequent astCssNode : allChilds) {
            this.append(astCssNode);
        }
    }

    private boolean appendCssClass(CssClass cssClass) {
        this.cssAndSM.append(cssClass.getFullName(), cssClass.getUnderlyingStructure());
        return true;
    }

    private void appendSimpleSelectorHead(SimpleSelector selector) {
        this.cssOnly.ensureSeparator();
        if (!selector.isStar() || !selector.isEmptyForm()) {
            InterpolableName elementName = selector.getElementName();
            this.cssAndSM.appendIgnoreNull(elementName.getName(), elementName.getUnderlyingStructure());
        }
    }

    public boolean appendSelectorCombinator(SelectorCombinator combinator) {
        SelectorCombinator.Combinator realCombinator = combinator.getCombinator();
        switch (realCombinator) {
            case DESCENDANT: {
                this.cssOnly.ensureSeparator();
                break;
            }
            default: {
                this.cssOnly.ensureSeparator().append(realCombinator.getSymbol());
            }
        }
        return true;
    }

    private void appendAllChilds(ASTCssNode node) {
        List<? extends ASTCssNode> allChilds = node.getChilds();
        this.appendAll(allChilds);
    }

    private void appendAll(List<? extends ASTCssNode> all) {
        for (ASTCssNode aSTCssNode : all) {
            if (!this.append(aSTCssNode)) continue;
            this.cssOnly.ensureNewLine();
        }
    }

    public String toString() {
        return this.cssOnly.toString();
    }

    public StringBuilder toCss() {
        return this.cssOnly.toStringBuilder();
    }

    public String toSourceMap() {
        return this.cssAndSM.toSourceMap();
    }
}

