/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j;

import com.github.sommeri.less4j.EmbeddedScriptGenerator;
import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.LessFunction;
import com.github.sommeri.less4j.LessSource;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public interface LessCompiler {
    public CompilationResult compile(String var1) throws Less4jException;

    public CompilationResult compile(String var1, Configuration var2) throws Less4jException;

    public CompilationResult compile(File var1) throws Less4jException;

    public CompilationResult compile(File var1, Configuration var2) throws Less4jException;

    public CompilationResult compile(URL var1) throws Less4jException;

    public CompilationResult compile(URL var1, Configuration var2) throws Less4jException;

    public CompilationResult compile(LessSource var1) throws Less4jException;

    public CompilationResult compile(LessSource var1, Configuration var2) throws Less4jException;

    public static interface Problem {
        public Type getType();

        public File getFile();

        public URL getURL();

        public LessSource getSource();

        public int getLine();

        public int getCharacter();

        public String getMessage();

        public static enum Type {
            WARNING,
            ERROR;

        }
    }

    public static class CompilationResult {
        private final String css;
        private final String sourceMap;
        private final List<Problem> warnings;

        public CompilationResult(String css) {
            this(css, "", CompilationResult.emptyList());
        }

        private static List<Problem> emptyList() {
            return Collections.emptyList();
        }

        public CompilationResult(String css, String sourceMap, List<Problem> warnings) {
            this.css = css;
            this.sourceMap = sourceMap;
            this.warnings = warnings;
        }

        public String getCss() {
            return this.css;
        }

        public List<Problem> getWarnings() {
            return this.warnings;
        }

        public String getSourceMap() {
            return this.sourceMap;
        }
    }

    public static class SourceMapConfiguration {
        private boolean linkSourceMap = true;
        private boolean inline = false;
        private String encodingCharset = "UTF-8";
        private boolean relativizePaths = true;
        private boolean includeSourcesContent = false;

        public boolean shouldLinkSourceMap() {
            return this.linkSourceMap;
        }

        public SourceMapConfiguration setLinkSourceMap(boolean linkSourceMap) {
            this.linkSourceMap = linkSourceMap;
            return this;
        }

        public boolean isInline() {
            return this.inline;
        }

        public SourceMapConfiguration setInline(boolean inline) {
            this.inline = inline;
            return this;
        }

        public String getEncodingCharset() {
            return this.encodingCharset;
        }

        public SourceMapConfiguration setEncodingCharset(String encodingCharset) {
            this.encodingCharset = encodingCharset;
            return this;
        }

        public boolean isRelativizePaths() {
            return this.relativizePaths;
        }

        public SourceMapConfiguration setRelativizePaths(boolean relativizePaths) {
            this.relativizePaths = relativizePaths;
            return this;
        }

        public boolean isIncludeSourcesContent() {
            return this.includeSourcesContent;
        }

        public void setIncludeSourcesContent(boolean includeSourcesContent) {
            this.includeSourcesContent = includeSourcesContent;
        }
    }

    public static class Configuration {
        private LessSource cssResultLocation;
        private SourceMapConfiguration sourceMapConfiguration = new SourceMapConfiguration();
        private List<LessFunction> functionPackages = new ArrayList<LessFunction>();
        private EmbeddedScriptGenerator embeddedScriptGenerator;

        public LessSource getCssResultLocation() {
            return this.cssResultLocation;
        }

        public void setCssResultLocation(LessSource cssResultLocation) {
            this.cssResultLocation = cssResultLocation;
        }

        public void setCssResultLocation(File cssResultLocation) {
            this.cssResultLocation = cssResultLocation == null ? null : new LessSource.FileSource(cssResultLocation);
        }

        @Deprecated
        public boolean shouldLinkSourceMap() {
            return this.sourceMapConfiguration.shouldLinkSourceMap();
        }

        public void setLinkSourceMap(boolean linkSourceMap) {
            this.sourceMapConfiguration.setLinkSourceMap(linkSourceMap);
        }

        public List<LessFunction> getCustomFunctions() {
            return this.functionPackages;
        }

        public void addCustomFunctions(List<LessFunction> functionPackages) {
            this.functionPackages.addAll(functionPackages);
        }

        public void addCustomFunction(LessFunction functionPackage) {
            this.functionPackages.add(functionPackage);
        }

        public EmbeddedScriptGenerator getEmbeddedScriptGenerator() {
            return this.embeddedScriptGenerator;
        }

        public void setEmbeddedScriptGenerator(EmbeddedScriptGenerator embeddedScripting) {
            this.embeddedScriptGenerator = embeddedScripting;
        }

        public SourceMapConfiguration getSourceMapConfiguration() {
            return this.sourceMapConfiguration;
        }
    }
}

