/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler;

import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Comment;
import com.github.sommeri.less4j.core.ast.Declaration;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FixedMediaExpression;
import com.github.sommeri.less4j.core.ast.MediaExpressionFeature;
import com.github.sommeri.less4j.core.ast.StyleSheet;
import com.github.sommeri.less4j.core.compiler.expressions.ExpressionEvaluator;
import com.github.sommeri.less4j.core.compiler.scopes.IScope;
import com.github.sommeri.less4j.core.compiler.selectors.ExtendsSolver;
import com.github.sommeri.less4j.core.compiler.selectors.UselessLessElementsRemover;
import com.github.sommeri.less4j.core.compiler.stages.ASTManipulator;
import com.github.sommeri.less4j.core.compiler.stages.ImportsAndScopeSolver;
import com.github.sommeri.less4j.core.compiler.stages.MediaBubblerAndMerger;
import com.github.sommeri.less4j.core.compiler.stages.PropertiesMerger;
import com.github.sommeri.less4j.core.compiler.stages.ReferencesSolver;
import com.github.sommeri.less4j.core.compiler.stages.UnNestingAndBubbling;
import com.github.sommeri.less4j.core.compiler.stages.UrlsAndImportsNormalizer;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import com.github.sommeri.less4j.core.validators.CssAstValidator;
import com.github.sommeri.less4j.utils.ArraysUtils;
import com.github.sommeri.less4j.utils.URIUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class LessToCssCompiler {
    private ProblemsHandler problemsHandler;
    private LessCompiler.Configuration configuration;

    public LessToCssCompiler(ProblemsHandler problemsHandler, LessCompiler.Configuration configuration) {
        this.problemsHandler = problemsHandler;
        this.configuration = configuration;
    }

    public ASTCssNode compileToCss(StyleSheet less, LessSource source, LessCompiler.Configuration options) {
        this.resolveImportsAndReferences(less, source);
        this.evaluateExpressions(less);
        this.freeNestedRulesetsAndMedia(less);
        this.solveExtends(less);
        this.finalMediaMergingAndBubbling(less);
        this.removeUselessLessElements(less);
        this.mergeMergingProperties(less);
        this.sortTopLevelElements(less);
        this.removeUselessCharsets(less);
        this.handleSourceMapLink(less, options, source);
        this.validateFinalCss(less);
        return less;
    }

    private void mergeMergingProperties(StyleSheet less) {
        PropertiesMerger propertiesMerger = new PropertiesMerger();
        propertiesMerger.propertiesMerger(less);
    }

    private void solveExtends(StyleSheet less) {
        ExtendsSolver extendsSolver = new ExtendsSolver();
        extendsSolver.solveExtends(less);
    }

    private void freeNestedRulesetsAndMedia(StyleSheet less) {
        UnNestingAndBubbling nestingBubbling = new UnNestingAndBubbling();
        nestingBubbling.unnestRulesetAndMedia(less);
    }

    private void handleSourceMapLink(StyleSheet less, LessCompiler.Configuration options, LessSource source) {
        String cssResultLocation = this.getCssResultLocationName(options, source);
        if (!options.shouldLinkSourceMap() || cssResultLocation == null) {
            return;
        }
        List<Comment> comments = less.getTrailingComments();
        if (!comments.isEmpty()) {
            ArraysUtils.last(comments).setHasNewLine(true);
        }
        String url = URIUtils.addSuffix(cssResultLocation, ".map");
        String commentTest = "/*# sourceMappingURL=" + url + " */";
        Comment linkComment = new Comment(less.getUnderlyingStructure(), commentTest, true);
        comments.add(linkComment);
    }

    private String getCssResultLocationName(LessCompiler.Configuration options, LessSource source) {
        String name;
        LessSource location = options.getCssResultLocation();
        String string = name = location == null ? null : location.getName();
        if (name == null) {
            name = URIUtils.changeSuffix(source.getName(), ".css");
        }
        return name;
    }

    private void resolveImportsAndReferences(StyleSheet less, LessSource source) {
        ImportsAndScopeSolver solver = new ImportsAndScopeSolver(this.problemsHandler, this.configuration);
        IScope scope = solver.buildImportsAndScope(less, source);
        ReferencesSolver referencesSolver = new ReferencesSolver(this.problemsHandler, this.configuration);
        referencesSolver.solveReferences(less, scope);
    }

    private void removeUselessLessElements(StyleSheet node) {
        UselessLessElementsRemover remover = new UselessLessElementsRemover();
        remover.removeUselessLessElements(node);
    }

    private void normalizeUrlsAndImportsInImportedFiles(StyleSheet node) {
        UrlsAndImportsNormalizer normalizer = new UrlsAndImportsNormalizer(this.problemsHandler, this.configuration);
        normalizer.normalizeUrlsAndImports(node);
    }

    private void removeUselessCharsets(StyleSheet less) {
        ASTManipulator astManipulator = new ASTManipulator();
        Iterator<ASTCssNode> iterator = less.getChilds().iterator();
        if (!iterator.hasNext()) {
            return;
        }
        ASTCssNode node = iterator.next();
        if (node.getType() != ASTCssNodeType.CHARSET_DECLARATION) {
            return;
        }
        if (!iterator.hasNext()) {
            return;
        }
        while (iterator.hasNext()) {
            node = iterator.next();
            if (node.getType() != ASTCssNodeType.CHARSET_DECLARATION) {
                return;
            }
            astManipulator.removeFromBody(node);
        }
    }

    private void finalMediaMergingAndBubbling(StyleSheet less) {
        MediaBubblerAndMerger bubblerAndMerger = new MediaBubblerAndMerger(this.problemsHandler);
        bubblerAndMerger.bubbleAndMergeMedia(less);
    }

    private void sortTopLevelElements(StyleSheet less) {
        Collections.sort(less.getMembers(), new Comparator<ASTCssNode>(){

            @Override
            public int compare(ASTCssNode first, ASTCssNode second) {
                return this.code(first) - this.code(second);
            }

            private int code(ASTCssNode node) {
                if (node.getType() == ASTCssNodeType.CHARSET_DECLARATION) {
                    return 0;
                }
                if (node.getType() == ASTCssNodeType.IMPORT) {
                    return 1;
                }
                return 2;
            }
        });
    }

    private void evaluateExpressions(ASTCssNode node) {
        ASTManipulator manipulator = new ASTManipulator();
        ExpressionEvaluator expressionEvaluator = new ExpressionEvaluator(this.problemsHandler, this.configuration);
        if (node instanceof Expression) {
            Expression value = expressionEvaluator.evaluate((Expression)node);
            manipulator.replace(node, value);
        } else {
            List<? extends ASTCssNode> childs = node.getChilds();
            block4: for (ASTCssNode aSTCssNode : childs) {
                switch (aSTCssNode.getType()) {
                    case FIXED_MEDIA_EXPRESSION: {
                        this.evaluateInMediaExpressions((FixedMediaExpression)aSTCssNode);
                        continue block4;
                    }
                    case DECLARATION: {
                        this.evaluateInDeclaration((Declaration)aSTCssNode);
                        continue block4;
                    }
                }
                this.evaluateExpressions(aSTCssNode);
            }
        }
    }

    private void evaluateInDeclaration(Declaration node) {
        if (!node.isFontDeclaration()) {
            this.evaluateExpressions(node);
            return;
        }
    }

    private void evaluateInMediaExpressions(FixedMediaExpression node) {
        MediaExpressionFeature feature = node.getFeature();
        if (!feature.isRatioFeature()) {
            this.evaluateExpressions(node);
            return;
        }
    }

    private void validateFinalCss(StyleSheet less) {
        CssAstValidator validator = new CssAstValidator(this.problemsHandler);
        validator.validate(less);
    }
}

