/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.FixedNamePart;
import com.github.sommeri.less4j.core.ast.InterpolableNamePart;
import com.github.sommeri.less4j.core.ast.annotations.NotAstProperty;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class InterpolableName
extends ASTCssNode {
    private List<InterpolableNamePart> parts = new ArrayList<InterpolableNamePart>();

    public InterpolableName(HiddenTokenAwareTree underlyingStructure) {
        super(underlyingStructure);
    }

    public InterpolableName(HiddenTokenAwareTree underlyingStructure, InterpolableNamePart ... fixedNameParts) {
        super(underlyingStructure);
        this.add(fixedNameParts);
    }

    public boolean isInterpolated() {
        if (this.parts == null) {
            return false;
        }
        for (InterpolableNamePart part : this.parts) {
            if (part.getType() != ASTCssNodeType.VARIABLE_NAME_PART) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        String result = "";
        for (InterpolableNamePart part : this.parts) {
            result = result + part.getName();
        }
        return result;
    }

    public void add(InterpolableNamePart part) {
        this.parts.add(part);
    }

    public void add(InterpolableNamePart ... parts) {
        this.parts.addAll(Arrays.asList(parts));
        this.configureParentToAllChilds();
    }

    public List<InterpolableNamePart> getParts() {
        return this.parts;
    }

    public void replaceMember(InterpolableNamePart oldMember, InterpolableNamePart newMember) {
        this.parts.add(this.parts.indexOf(oldMember), newMember);
        newMember.setParent(this);
        this.parts.remove(oldMember);
        oldMember.setParent(null);
    }

    @Override
    @NotAstProperty
    public List<? extends ASTCssNode> getChilds() {
        return this.parts;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.INTERPOLABLE_NAME;
    }

    @Override
    public InterpolableName clone() {
        InterpolableName clone = (InterpolableName)super.clone();
        clone.parts = ArraysUtils.deeplyClonedList(this.getParts());
        clone.configureParentToAllChilds();
        return clone;
    }

    public void extendName(String extension) {
        this.parts.add(new FixedNamePart(this.getUnderlyingStructure(), extension));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (InterpolableNamePart part : this.getParts()) {
            builder.append(part);
        }
        return builder.toString();
    }
}

