/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.annotations.NotAstProperty;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.PrintUtils;
import java.awt.Color;
import java.util.Collections;
import java.util.List;

public class ColorExpression
extends Expression {
    protected String value;
    protected double red;
    protected double green;
    protected double blue;

    ColorExpression(HiddenTokenAwareTree token, ColorExpression colorExpression) {
        super(token);
        this.red = colorExpression.red;
        this.green = colorExpression.green;
        this.blue = colorExpression.blue;
        this.value = this.encode(this.red, this.green, this.blue);
    }

    public ColorExpression(HiddenTokenAwareTree token, double red, double green, double blue) {
        super(token);
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.value = this.encode(red, green, blue);
    }

    public ColorExpression(HiddenTokenAwareTree token, String value, double red, double green, double blue) {
        super(token);
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isShorthand() {
        String value = this.getValue();
        return !this.isNamed() && value != null && value.length() < 7;
    }

    public String getValueInHexadecimal() {
        return this.encode(this.red, this.green, this.blue);
    }

    public void setValue(String value) {
        this.value = value;
        this.red = this.decode(value, 0);
        this.green = this.decode(value, 1);
        this.blue = this.decode(value, 2);
    }

    public double getRed() {
        return this.red;
    }

    public double getGreen() {
        return this.green;
    }

    public double getBlue() {
        return this.blue;
    }

    public double getAlpha() {
        return 1.0;
    }

    private int decode(String color, int i) {
        if (color.length() < 7) {
            String substring = color.substring(i + 1, i + 2);
            return Integer.parseInt(substring + substring, 16);
        }
        return Integer.parseInt(color.substring(i * 2 + 1, i * 2 + 3), 16);
    }

    private String encode(double red, double green, double blue) {
        return "#" + this.toHex(red) + this.toHex(green) + this.toHex(blue);
    }

    protected String toHex(double color) {
        String prefix = "";
        if (color < 16.0) {
            prefix = "0";
        }
        return prefix + Integer.toHexString((int)Math.round(color));
    }

    @Override
    @NotAstProperty
    public List<? extends ASTCssNode> getChilds() {
        return Collections.emptyList();
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.COLOR_EXPRESSION;
    }

    @Override
    public String toString() {
        return "" + this.value;
    }

    @Override
    public ColorExpression clone() {
        return (ColorExpression)super.clone();
    }

    public String toARGB() {
        return "#ff" + this.toHex(this.red) + this.toHex(this.green) + this.toHex(this.blue);
    }

    public Color toColor() {
        return new Color((int)Math.round(this.red), (int)Math.round(this.green), (int)Math.round(this.blue));
    }

    public boolean hasAlpha() {
        return false;
    }

    public boolean isNamed() {
        return false;
    }

    public String getColorName() {
        return null;
    }

    public static class ColorWithAlphaExpression
    extends ColorExpression {
        private double alpha;

        public ColorWithAlphaExpression(HiddenTokenAwareTree token, ColorExpression colorExpression) {
            super(token, colorExpression);
            this.alpha = colorExpression.getAlpha();
            this.value = this.encode(this.red, this.green, this.blue, this.alpha);
        }

        public ColorWithAlphaExpression(HiddenTokenAwareTree token, double red, double green, double blue, double alpha) {
            super(token, red, green, blue);
            this.alpha = alpha;
            if (alpha != 1.0) {
                this.value = this.encode(red, green, blue, alpha);
            }
        }

        public ColorWithAlphaExpression(HiddenTokenAwareTree token, String originalValue, double red, double green, double blue, double alpha) {
            super(token, originalValue, red, green, blue);
            this.alpha = alpha;
        }

        @Override
        public double getAlpha() {
            return this.alpha;
        }

        protected String encode(double red, double green, double blue, double alpha) {
            return "rgba(" + this.roundFormat(red) + ", " + this.roundFormat(green) + ", " + this.roundFormat(blue) + ", " + this.format(alpha) + ")";
        }

        @Override
        public String getValueInHexadecimal() {
            return this.getValue();
        }

        private String format(double value) {
            return PrintUtils.formatNumber(value);
        }

        private String roundFormat(double value) {
            return PrintUtils.formatNumber(Math.round(value));
        }

        @Override
        public String toARGB() {
            return "#" + this.toHex(Math.round(this.alpha * 255.0)) + this.toHex(this.red) + this.toHex(this.green) + this.toHex(this.blue);
        }

        @Override
        public Color toColor() {
            return new Color((float)((int)Math.round(this.red)), (float)((int)Math.round(this.green)), (float)((int)Math.round(this.blue)), Math.round(this.alpha * 255.0));
        }

        @Override
        public boolean hasAlpha() {
            return true;
        }
    }
}

